/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.ResourceManager;

public class ImageUtils {
    private static final List<String> IMG_FILE_EXTENSIONS = new ArrayList<String>();

    static {
        IMG_FILE_EXTENSIONS.add("png");
        IMG_FILE_EXTENSIONS.add("gif");
        IMG_FILE_EXTENSIONS.add("jpg");
        IMG_FILE_EXTENSIONS.add("jpeg");
        IMG_FILE_EXTENSIONS.add("bmp");
        IMG_FILE_EXTENSIONS.add("tiff");
    }

    private ImageUtils() {
    }

    public static Image resize(Image originalImage, int width, int height) {
        Assert.isNotNull((Object)originalImage, (String)"The image to resize can not be null.");
        Assert.isTrue((!originalImage.isDisposed() ? 1 : 0) != 0, (String)"The image to resize is disposed.");
        Assert.isTrue((width > 1 ? 1 : 0) != 0, (String)"Please specify a valid width value for the new image.");
        Assert.isTrue((height > 1 ? 1 : 0) != 0, (String)"Please specify a valid height value for the new image.");
        Image scaled = new Image((Device)UIUtils.getDisplay(), width, height);
        GC gc = new GC((Drawable)scaled);
        try {
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(originalImage, 0, 0, originalImage.getBounds().width, originalImage.getBounds().height, 0, 0, width, height);
        }
        finally {
            gc.dispose();
        }
        return scaled;
    }

    public static ImageData resizeKeepingRatio(int size, Image source) {
        Assert.isNotNull((Object)source, (String)"The image to resize can not be null.");
        Assert.isTrue((!source.isDisposed() ? 1 : 0) != 0, (String)"The image to resize is disposed.");
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"Please specify a valid size value for the new image.");
        int width = source.getImageData().width;
        int height = source.getImageData().height;
        boolean needResize = false;
        if (width > height) {
            if (width != size) {
                height = (int)Math.round((double)(size * height) / (double)width);
                width = size;
                needResize = true;
            }
        } else if (height != size) {
            width = (int)Math.round((double)(size * width) / (double)height);
            height = size;
            needResize = true;
        }
        if (needResize) {
            Image scaled = new Image((Device)Display.getDefault(), width, height);
            GC gc = new GC((Drawable)scaled);
            try {
                gc.setAntialias(1);
                gc.setInterpolation(2);
                gc.drawImage(source, 0, 0, source.getBounds().width, source.getBounds().height, 0, 0, width, height);
            }
            finally {
                gc.dispose();
            }
            ImageData result = scaled.getImageData();
            scaled.dispose();
            return result;
        }
        return source.getImageData();
    }

    public static Image padImage(Image originalImage, int width, int height, RGB backGround) {
        Assert.isNotNull((Object)originalImage, (String)"The image to resize can not be null.");
        Assert.isTrue((!originalImage.isDisposed() ? 1 : 0) != 0, (String)"The image to resize is disposed.");
        Assert.isTrue((width >= originalImage.getImageData().width ? 1 : 0) != 0, (String)"Please specify a valid width value for the new image.");
        Assert.isTrue((height >= originalImage.getImageData().height ? 1 : 0) != 0, (String)"Please specify a valid height value for the new image.");
        int originalHeight = originalImage.getImageData().height;
        int originalWidth = originalImage.getImageData().width;
        if (width == originalWidth && height == originalHeight) {
            return originalImage;
        }
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        try {
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.setBackground(ResourceManager.getColor((RGB)backGround));
            gc.fillRectangle(0, 0, width, height);
            int destX = (width - originalImage.getImageData().width) / 2;
            int destY = (height - originalImage.getImageData().height) / 2;
            gc.drawImage(originalImage, 0, 0, originalWidth, originalHeight, destX, destY, originalHeight, originalWidth);
        }
        finally {
            gc.dispose();
        }
        return scaled;
    }

    public static Image addTextToImage(Image originalImage, String text) {
        Assert.isNotNull((Object)originalImage, (String)"The image to resize can not be null.");
        Assert.isTrue((!originalImage.isDisposed() ? 1 : 0) != 0, (String)"The image to resize is disposed.");
        int originalHeight = originalImage.getImageData().height;
        int originalWidth = originalImage.getImageData().width;
        Image scaled = new Image((Device)Display.getDefault(), 1, 1);
        GC gc = new GC((Drawable)scaled);
        Point size = gc.textExtent(text);
        scaled.dispose();
        gc.dispose();
        scaled = new Image((Device)Display.getDefault(), originalWidth + size.x + 5, originalHeight);
        gc = new GC((Drawable)scaled);
        try {
            gc.setAntialias(1);
            gc.setInterpolation(2);
            int destY = (originalImage.getImageData().height - size.y) / 2;
            gc.drawImage(originalImage, 0, 0, originalWidth, originalHeight, size.x + 3, 0, originalHeight, originalWidth);
            gc.drawText(text, 2, destY, true);
        }
        finally {
            gc.dispose();
        }
        return scaled;
    }

    public static boolean hasValidFileImageExtension(String extension) {
        for (String ext : IMG_FILE_EXTENSIONS) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getAllowedImageFileExtensions() {
        return IMG_FILE_EXTENSIONS;
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    public static boolean arrayContains(Object[] arr, Object targetValue) {
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            if (s.equals(targetValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ImageData createGrayImage(Image baseImage) {
        if (baseImage == null) {
            return null;
        }
        ImageData data = (ImageData)baseImage.getImageData().clone();
        PaletteData palette = data.palette;
        int i = 0;
        while (i < data.width) {
            int j = 0;
            while (j < data.height) {
                RGB color = palette.getRGB(data.getPixel(i, j));
                int newColor = (color.blue + color.green + color.red) % 104 + 128;
                RGB grayedColor = new RGB(newColor, newColor, newColor);
                if (!palette.isDirect && !ImageUtils.arrayContains(palette.colors, grayedColor)) {
                    RGB[] newPalette = Arrays.copyOf(palette.colors, palette.colors.length + 1);
                    newPalette[newPalette.length - 1] = grayedColor;
                    palette.colors = newPalette;
                }
                data.setPixel(i, j, palette.getPixel(grayedColor));
                ++j;
            }
            ++i;
        }
        return data;
    }
}

