/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SWTImageEffects {
    public static ImageData extendArea(ImageData originalImageData, int size, RGB backgroundRGB) {
        if (originalImageData == null) {
            return null;
        }
        if (size == 0) {
            return originalImageData;
        }
        ImageData newImageData = new ImageData(originalImageData.width + size * 2, originalImageData.height + size * 2, 24, new PaletteData(255, 65280, 0xFF0000));
        int[] pixels = new int[originalImageData.width];
        RGB backRGB = new RGB(255, 255, 255);
        if (backgroundRGB != null) {
            backRGB = backgroundRGB;
        }
        int pixel = newImageData.palette.getPixel(backRGB);
        int[] backPixels = new int[newImageData.width];
        int i = 0;
        while (i < backPixels.length) {
            backPixels[i] = pixel;
            ++i;
        }
        int row = 0;
        while (row < newImageData.height) {
            newImageData.setPixels(0, row, newImageData.width, backPixels, 0);
            ++row;
        }
        row = size;
        while (row < size + originalImageData.height) {
            originalImageData.getPixels(0, row - size, originalImageData.width, pixels, 0);
            int col = 0;
            while (col < pixels.length) {
                pixels[col] = newImageData.palette.getPixel(originalImageData.palette.getRGB(pixels[col]));
                ++col;
            }
            newImageData.setPixels(size, row, originalImageData.width, pixels, 0);
            ++row;
        }
        return newImageData;
    }

    public static class Blur {
        public static ImageData blur(ImageData originalImageData, int radius) {
            if (radius < 1) {
                return originalImageData;
            }
            ImageData newImageData = new ImageData(originalImageData.width, originalImageData.height, 24, new PaletteData(255, 65280, 0xFF0000));
            if (radius >= newImageData.height || radius >= newImageData.width) {
                radius = Math.min(newImageData.height, newImageData.width) - 1;
            }
            ArrayList<RGB[]> rowCache = new ArrayList<RGB[]>();
            int cacheSize = radius * 2 + 1 > newImageData.height ? newImageData.height : radius * 2 + 1;
            int cacheStartIndex = 0;
            int row = 0;
            while (row < cacheSize) {
                rowCache.add(rowCache.size(), Blur.blurRow(originalImageData, row, radius));
                ++row;
            }
            RGB[] rowRGBSums = new RGB[newImageData.width];
            int[] rowRGBAverages = new int[newImageData.width];
            int topSumBoundary = 0;
            int targetRow = 0;
            int bottomSumBoundary = 0;
            int numRows = 0;
            int i = 0;
            while (i < newImageData.width) {
                rowRGBSums[i] = new RGB(0, 0, 0);
                ++i;
            }
            while (targetRow < newImageData.height) {
                int col;
                if (bottomSumBoundary < newImageData.height) {
                    do {
                        col = 0;
                        while (col < newImageData.width) {
                            rowRGBSums[col].red += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].red;
                            rowRGBSums[col].green += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].green;
                            rowRGBSums[col].blue += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].blue;
                            ++col;
                        }
                        ++numRows;
                        if (++bottomSumBoundary >= newImageData.height || bottomSumBoundary - cacheStartIndex <= radius * 2) continue;
                        rowCache.add(rowCache.size(), Blur.blurRow(originalImageData, bottomSumBoundary, radius));
                    } while (bottomSumBoundary <= radius);
                }
                if (targetRow - topSumBoundary > radius) {
                    col = 0;
                    while (col < newImageData.width) {
                        rowRGBSums[col].red -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].red;
                        rowRGBSums[col].green -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].green;
                        rowRGBSums[col].blue -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].blue;
                        ++col;
                    }
                    --numRows;
                    ++topSumBoundary;
                    rowCache.remove(0);
                    ++cacheStartIndex;
                }
                col = 0;
                while (col < newImageData.width) {
                    rowRGBAverages[col] = newImageData.palette.getPixel(new RGB(rowRGBSums[col].red / numRows, rowRGBSums[col].green / numRows, rowRGBSums[col].blue / numRows));
                    ++col;
                }
                newImageData.setPixels(0, targetRow, newImageData.width, rowRGBAverages, 0);
                ++targetRow;
            }
            return newImageData;
        }

        private static RGB[] blurRow(ImageData originalImageData, int row, int radius) {
            RGB[] rowRGBAverages = new RGB[originalImageData.width];
            int[] lineData = new int[originalImageData.width];
            originalImageData.getPixels(0, row, originalImageData.width, lineData, 0);
            int r = 0;
            int g = 0;
            int b = 0;
            int leftSumBoundary = 0;
            int targetColumn = 0;
            int rightSumBoundary = 0;
            int numCols = 0;
            while (targetColumn < lineData.length) {
                RGB rgb;
                if (rightSumBoundary < lineData.length) {
                    do {
                        rgb = originalImageData.palette.getRGB(lineData[rightSumBoundary]);
                        r += rgb.red;
                        g += rgb.green;
                        b += rgb.blue;
                        ++numCols;
                    } while (++rightSumBoundary <= radius);
                }
                if (targetColumn - leftSumBoundary > radius) {
                    rgb = originalImageData.palette.getRGB(lineData[leftSumBoundary]);
                    r -= rgb.red;
                    g -= rgb.green;
                    b -= rgb.blue;
                    --numCols;
                    ++leftSumBoundary;
                }
                rowRGBAverages[targetColumn] = new RGB(r / numCols, g / numCols, b / numCols);
                ++targetColumn;
            }
            return rowRGBAverages;
        }
    }

    public static class DropShadow {
        public static ImageData dropShadow(ImageData originalImageData, Color color, int radius, int highlightRadius, int opacity) {
            double highlightRadiusIncrease;
            if (originalImageData == null) {
                return null;
            }
            if (color == null) {
                return null;
            }
            if (radius == 0) {
                return originalImageData;
            }
            int shift = (int)((double)radius * 1.5);
            double d = radius < highlightRadius * 2 ? 0.15 : (highlightRadiusIncrease = radius < highlightRadius * 3 ? 0.09 : 0.02);
            opacity = opacity > 255 ? 255 : (opacity < 0 ? 0 : opacity);
            ImageData newImageData = new ImageData(originalImageData.width + radius * 2, originalImageData.height + radius * 2, 24, new PaletteData(255, 65280, 0xFF0000));
            int[] pixels = new int[originalImageData.width];
            int row = radius;
            while (row < radius + originalImageData.height) {
                originalImageData.getPixels(0, row - radius, originalImageData.width, pixels, 0);
                int col = 0;
                while (col < pixels.length) {
                    pixels[col] = newImageData.palette.getPixel(originalImageData.palette.getRGB(pixels[col]));
                    ++col;
                }
                newImageData.setPixels(radius, row, originalImageData.width, pixels, 0);
                ++row;
            }
            int colorInt = newImageData.palette.getPixel(color.getRGB());
            pixels = new int[newImageData.width];
            int i = 0;
            while (i < newImageData.width) {
                pixels[i] = colorInt;
                ++i;
            }
            byte[] alphas = new byte[newImageData.width];
            int row2 = 0;
            while (row2 < newImageData.height) {
                if (row2 < radius) {
                    byte intensity = (byte)((double)opacity * ((double)(row2 + 1) / (double)radius));
                    int col = 0;
                    while (col < alphas.length / 2 + alphas.length % 2) {
                        if (col < radius) {
                            double hypotenuse = Math.sqrt(Math.pow(radius - col - 1, 2.0) + Math.pow(radius - 1 - row2, 2.0));
                            byte by = (byte)((double)opacity * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0));
                            alphas[alphas.length - col - 1] = by;
                            alphas[col + shift] = by;
                            if (hypotenuse < Math.min((double)highlightRadius, (double)radius * 0.5)) {
                                byte by2 = (byte)Math.min(255.0, (double)(alphas[col + shift] & 0xFF) * (1.0 + highlightRadiusIncrease * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0)));
                                alphas[alphas.length - col - 1] = by2;
                                alphas[col + shift] = by2;
                            }
                        } else {
                            byte by = (byte)((double)row2 > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5) ? Math.min(255.0, (double)(intensity & 0xFF) * (1.0 + highlightRadiusIncrease * (double)row2 / (double)radius)) : (double)intensity);
                            alphas[alphas.length - col - 1] = by;
                            alphas[col + shift] = by;
                        }
                        ++col;
                    }
                    if (row2 + shift < newImageData.height) {
                        newImageData.setAlphas(newImageData.width - radius, row2 + shift, radius, alphas, alphas.length - radius);
                        newImageData.setPixels(newImageData.width - radius, row2 + shift, radius, pixels, alphas.length - radius);
                    }
                    newImageData.setAlphas(0, newImageData.height - 1 - row2, newImageData.width, alphas, 0);
                    newImageData.setPixels(0, newImageData.height - 1 - row2, newImageData.width, pixels, 0);
                } else if (row2 <= newImageData.height / 2) {
                    double intensity = 0.0;
                    int col = 0;
                    while (col < alphas.length) {
                        if (col < radius) {
                            intensity = (double)opacity * ((double)(col + 1) / (double)radius);
                            if ((double)col > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5)) {
                                intensity = Math.min(255.0, intensity * (1.0 + highlightRadiusIncrease * (double)col / (double)radius));
                            }
                            alphas[newImageData.width - col - 1] = (byte)intensity;
                            alphas[col] = 0;
                        } else if (col <= newImageData.width / 2 + newImageData.width % 2) {
                            alphas[newImageData.width - col - 1] = -1;
                            alphas[col] = -1;
                        }
                        ++col;
                    }
                    newImageData.setPixels(0, newImageData.height - 1 - row2, radius, pixels, 0);
                    newImageData.setPixels(originalImageData.width + radius, newImageData.height - 1 - row2, radius, pixels, 0);
                    newImageData.setAlphas(0, newImageData.height - 1 - row2, newImageData.width, alphas, 0);
                    if (row2 >= shift + radius) {
                        newImageData.setPixels(0, row2, radius, pixels, 0);
                        newImageData.setPixels(originalImageData.width + radius, row2, radius, pixels, 0);
                        newImageData.setAlphas(0, row2, newImageData.width, alphas, 0);
                    } else {
                        newImageData.setPixels(0, row2, radius, pixels, 0);
                        newImageData.setAlphas(0, row2, newImageData.width - radius, alphas, 0);
                    }
                }
                ++row2;
            }
            return newImageData;
        }
    }

    public static class Emboss {
        public static ImageData emboss(ImageData originalImageData, int grayLevel) {
            ImageData newImageData = new ImageData(originalImageData.width, originalImageData.height, 24, new PaletteData(255, 65280, 0xFF0000));
            grayLevel = grayLevel < 0 ? 0 : (grayLevel > 255 ? 255 : grayLevel);
            int rDiff = 0;
            int gDiff = 0;
            int bDiff = 0;
            int gray = 0;
            int[] rowResult = new int[newImageData.width];
            RGB[] rowRGBData1 = new RGB[newImageData.width];
            RGB[] rowRGBData2 = new RGB[newImageData.width];
            Emboss.getRGBRowData(originalImageData, rowRGBData2, 0);
            int row = 0;
            while (row < newImageData.height) {
                RGB[] tempRow = rowRGBData1;
                if (row < newImageData.height - 1) {
                    rowRGBData1 = rowRGBData2;
                    rowRGBData2 = tempRow;
                    Emboss.getRGBRowData(originalImageData, rowRGBData2, row + 1);
                }
                int col = 0;
                while (col < newImageData.width) {
                    if (col < 2) {
                        rDiff = Math.abs(rowRGBData2[col].red - rowRGBData1[col].red);
                        gDiff = Math.abs(rowRGBData2[col].green - rowRGBData1[col].green);
                        bDiff = Math.abs(rowRGBData2[col].blue - rowRGBData1[col].blue);
                    } else {
                        rDiff = Math.abs(rowRGBData2[col].red - rowRGBData1[col - 2].red);
                        gDiff = Math.abs(rowRGBData2[col].green - rowRGBData1[col - 2].green);
                        bDiff = Math.abs(rowRGBData2[col].blue - rowRGBData1[col - 2].blue);
                    }
                    gray = Math.min(grayLevel + Math.max(rDiff, Math.max(gDiff, bDiff)), 255);
                    rowResult[col] = newImageData.palette.getPixel(new RGB(gray, gray, gray));
                    ++col;
                }
                newImageData.setPixels(0, row, newImageData.width, rowResult, 0);
                ++row;
            }
            return newImageData;
        }

        private static void getRGBRowData(ImageData originalImageData, RGB[] resultData, int row) {
            int[] pixels = new int[originalImageData.width];
            originalImageData.getPixels(0, row, originalImageData.width, pixels, 0);
            int col = 0;
            while (col < originalImageData.width) {
                resultData[col] = originalImageData.palette.getRGB(pixels[col]);
                ++col;
            }
        }
    }

    public static class Glow {
        public static ImageData glow(ImageData originalImageData, Color color, int radius, int highlightRadius, int opacity) {
            double highlightRadiusIncrease;
            if (originalImageData == null) {
                return null;
            }
            if (color == null) {
                return null;
            }
            if (radius == 0) {
                return originalImageData;
            }
            double d = radius < highlightRadius * 2 ? 0.15 : (highlightRadiusIncrease = radius < highlightRadius * 3 ? 0.09 : 0.02);
            opacity = opacity > 255 ? 255 : (opacity < 0 ? 0 : opacity);
            ImageData newImageData = new ImageData(originalImageData.width + radius * 2, originalImageData.height + radius * 2, 24, new PaletteData(255, 65280, 0xFF0000));
            int[] pixels = new int[originalImageData.width];
            int row = radius;
            while (row < radius + originalImageData.height) {
                originalImageData.getPixels(0, row - radius, originalImageData.width, pixels, 0);
                int col = 0;
                while (col < pixels.length) {
                    pixels[col] = newImageData.palette.getPixel(originalImageData.palette.getRGB(pixels[col]));
                    ++col;
                }
                newImageData.setPixels(radius, row, originalImageData.width, pixels, 0);
                ++row;
            }
            int colorInt = newImageData.palette.getPixel(color.getRGB());
            pixels = new int[newImageData.width];
            int i = 0;
            while (i < newImageData.width) {
                pixels[i] = colorInt;
                ++i;
            }
            byte[] alphas = new byte[newImageData.width];
            int row2 = 0;
            while (row2 < newImageData.height) {
                if (row2 < radius) {
                    byte intensity = (byte)((double)opacity * ((double)(row2 + 1) / (double)radius));
                    int col = 0;
                    while (col < alphas.length / 2 + alphas.length % 2) {
                        if (col < radius) {
                            double hypotenuse = Math.sqrt(Math.pow(radius - col - 1, 2.0) + Math.pow(radius - 1 - row2, 2.0));
                            byte by = (byte)((double)opacity * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0));
                            alphas[alphas.length - col - 1] = by;
                            alphas[col] = by;
                            if (hypotenuse < Math.min((double)highlightRadius, (double)radius * 0.5)) {
                                byte by2 = (byte)Math.min(255.0, (double)(alphas[col] & 0xFF) * (1.0 + highlightRadiusIncrease * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0)));
                                alphas[alphas.length - col - 1] = by2;
                                alphas[col] = by2;
                            }
                        } else {
                            byte by = (byte)((double)row2 > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5) ? Math.min(255.0, (double)(intensity & 0xFF) * (1.0 + highlightRadiusIncrease * (double)row2 / (double)radius)) : (double)intensity);
                            alphas[alphas.length - 1 - col] = by;
                            alphas[col] = by;
                        }
                        ++col;
                    }
                    newImageData.setAlphas(0, row2, newImageData.width, alphas, 0);
                    newImageData.setAlphas(0, newImageData.height - 1 - row2, newImageData.width, alphas, 0);
                    newImageData.setPixels(0, row2, newImageData.width, pixels, 0);
                    newImageData.setPixels(0, newImageData.height - 1 - row2, newImageData.width, pixels, 0);
                } else if (row2 <= newImageData.height / 2) {
                    double intensity = 0.0;
                    int col = 0;
                    while (col < alphas.length) {
                        if (col < radius) {
                            intensity = (double)opacity * ((double)(col + 1) / (double)radius);
                            if ((double)col > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5)) {
                                intensity = Math.min(255.0, intensity * (1.0 + highlightRadiusIncrease * (double)col / (double)radius));
                            }
                            byte by = (byte)intensity;
                            alphas[newImageData.width - col - 1] = by;
                            alphas[col] = by;
                        } else if (col <= newImageData.width / 2 + newImageData.width % 2) {
                            alphas[newImageData.width - col - 1] = -1;
                            alphas[col] = -1;
                        }
                        ++col;
                    }
                    newImageData.setPixels(0, row2, radius, pixels, 0);
                    newImageData.setPixels(originalImageData.width + radius, row2, radius, pixels, 0);
                    newImageData.setAlphas(0, row2, newImageData.width, alphas, 0);
                    newImageData.setPixels(0, newImageData.height - 1 - row2, radius, pixels, 0);
                    newImageData.setPixels(originalImageData.width + radius, newImageData.height - 1 - row2, radius, pixels, 0);
                    newImageData.setAlphas(0, newImageData.height - 1 - row2, newImageData.width, alphas, 0);
                }
                ++row2;
            }
            return newImageData;
        }
    }
}

