/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.command.IQueryLanguageChanged;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetParameter;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class SyncDatasetRunParameters {
    private static Map<String, Object[]> bipMap = new HashMap<String, Object[]>();
    public static List<IQueryLanguageChanged> changed = new ArrayList<IQueryLanguageChanged>();

    public static void addMoreParameters(String lang, Object[] params) {
        bipMap.put(lang, params);
    }

    public static void add(IQueryLanguageChanged executer) {
        if (!changed.contains(executer)) {
            changed.add(executer);
        }
    }

    public static Object[] getBuiltInParameters(JasperReportsConfiguration jConf, String mLang) throws JRException {
        JRQueryExecuterUtils qeUtils = JRQueryExecuterUtils.getInstance((JasperReportsContext)jConf);
        QueryExecuterFactory qef = qeUtils.getExecuterFactory(mLang);
        if (qef != null) {
            Object[] prms = qef.getBuiltinParameters();
            if (mLang.equalsIgnoreCase("plsql")) {
                return new Object[0];
            }
            if (bipMap.containsKey(mLang)) {
                Object[] params = bipMap.get(mLang);
                if (prms == null || prms.length == 0) {
                    return params;
                }
                Object[] tmp = new Object[prms.length + params.length];
                System.arraycopy(prms, 0, tmp, 0, prms.length);
                System.arraycopy(params, 0, tmp, prms.length, params.length);
                return tmp;
            }
            return prms;
        }
        return null;
    }

    public static void syncDatasetRun(MDatasetRun mDsRun, String oldName, String newName) throws JRException {
        JasperDesign jd = mDsRun.getJasperDesign();
        if (jd.getMainDataset().getQuery() != null) {
            Object[] bprms;
            String mLang = jd.getMainDataset().getQuery().getLanguage();
            JasperReportsConfiguration jConf = mDsRun.getJasperConfiguration();
            if (jConf == null) {
                return;
            }
            String mDsName = jd.getMainDataset().getName();
            JRDesignDatasetRun dsRun = mDsRun.getValue();
            if (dsRun.getDataSourceExpression() != null) {
                return;
            }
            if (oldName != null && !mDsName.equals(newName)) {
                for (JRDataset ds : jd.getDatasetsList()) {
                    if (SyncDatasetRunParameters.isNeedParameters(ds) || !ds.getName().equals(oldName) || mLang != null && (ds.getQuery() == null || !mLang.equals(ds.getQuery().getLanguage()))) continue;
                    bprms = SyncDatasetRunParameters.getBuiltInParameters(jConf, ds.getQuery().getLanguage());
                    if (bprms == null) break;
                    SyncDatasetRunParameters.cleanDatasetRun(bprms, dsRun);
                    break;
                }
            }
            if (newName != null && !mDsName.equals(newName)) {
                for (JRDataset ds : jd.getDatasetsList()) {
                    if (SyncDatasetRunParameters.isNeedParameters(ds) || !ds.getName().equals(newName) || mLang != null && (ds.getQuery() == null || !mLang.equals(ds.getQuery().getLanguage()))) continue;
                    bprms = SyncDatasetRunParameters.getBuiltInParameters(jConf, ds.getQuery().getLanguage());
                    if (bprms == null) break;
                    SyncDatasetRunParameters.setupDatasetRun(bprms, dsRun);
                    break;
                }
            }
        }
    }

    public static void syncDataset(MDataset mDsRun, String oldLang, String newLang, boolean forceAddOnDatasetRuns) throws JRException {
        block12: {
            Object[] bprms;
            JasperReportsConfiguration jConf;
            String mLang;
            JRDesignDataset subDS;
            MReport mrep;
            block13: {
                mrep = mDsRun.getMreport();
                if (mrep == null) {
                    return;
                }
                JasperDesign jd = mDsRun.getJasperDesign();
                if (jd.getMainDataset().getQuery() == null) break block12;
                subDS = mDsRun.getValue();
                String mDsName = jd.getMainDataset().getName();
                mLang = jd.getMainDataset().getQuery().getLanguage();
                jConf = mDsRun.getJasperConfiguration();
                if (jConf == null) {
                    return;
                }
                if (SyncDatasetRunParameters.isNeedParameters((JRDataset)subDS)) {
                    return;
                }
                if (subDS != jd.getMainDesignDataset() && !mDsName.equals(subDS.getName())) break block13;
                Object[] bprms2 = SyncDatasetRunParameters.getBuiltInParameters(jConf, oldLang);
                if (bprms2 != null) {
                    for (JRDataset ds : jd.getDatasetsList()) {
                        if (ds.getQuery() == null || !ds.getQuery().getLanguage().equals(oldLang)) continue;
                        for (JRDesignDatasetRun dr : SyncDatasetRunParameters.getDatasetRun(mrep, ds)) {
                            SyncDatasetRunParameters.cleanDatasetRun(bprms2, dr);
                        }
                    }
                }
                if ((bprms2 = SyncDatasetRunParameters.getBuiltInParameters(jConf, newLang)) == null) break block12;
                for (JRDataset ds : jd.getDatasetsList()) {
                    if (ds.getQuery() == null || !ds.getQuery().getLanguage().equals(newLang)) continue;
                    for (JRDesignDatasetRun dr : SyncDatasetRunParameters.getDatasetRun(mrep, ds)) {
                        SyncDatasetRunParameters.setupDatasetRun(bprms2, dr);
                    }
                }
                break block12;
            }
            if (mLang == null || oldLang != null && oldLang.equals(mLang)) {
                for (JRDesignDatasetRun dr : SyncDatasetRunParameters.getDatasetRun(mrep, (JRDataset)subDS)) {
                    bprms = SyncDatasetRunParameters.getBuiltInParameters(jConf, oldLang);
                    if (bprms == null) continue;
                    SyncDatasetRunParameters.cleanDatasetRun(bprms, dr);
                }
            }
            if (forceAddOnDatasetRuns || mLang == null || newLang != null && newLang.equals(mLang)) {
                for (JRDesignDatasetRun dr : SyncDatasetRunParameters.getDatasetRun(mrep, (JRDataset)subDS)) {
                    bprms = SyncDatasetRunParameters.getBuiltInParameters(jConf, newLang);
                    if (bprms == null) continue;
                    SyncDatasetRunParameters.setupDatasetRun(bprms, dr);
                }
            }
        }
    }

    private static boolean isNeedParameters(JRDataset subDS) {
        if (subDS.getQuery() != null && subDS.getQuery().getLanguage() != null && subDS.getQuery().getLanguage().equalsIgnoreCase("plsql")) {
            return false;
        }
        return subDS.getPropertiesMap().containsProperty("net.sf.jasperreports.data.adapter");
    }

    private static void prepareDatasets(JasperDesign jd) {
        for (IQueryLanguageChanged qlc : changed) {
            SyncDatasetRunParameters.prepareDataSet(jd, jd.getMainDesignDataset(), qlc);
            for (JRDataset ds : jd.getDatasetsList()) {
                if (SyncDatasetRunParameters.isNeedParameters(ds)) continue;
                SyncDatasetRunParameters.prepareDataSet(jd, (JRDesignDataset)ds, qlc);
            }
        }
    }

    private static void prepareDataSet(JasperDesign jd, JRDesignDataset ds, IQueryLanguageChanged qlc) {
        try {
            if (ds.getQuery() != null) {
                qlc.syncDataset(jd, ds, null, ds.getQuery().getLanguage());
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public static void sync(MReport mrep) {
        try {
            JRQuery query;
            JasperReportsConfiguration jConf = mrep.getJasperConfiguration();
            JasperDesign jd = mrep.getValue();
            SyncDatasetRunParameters.prepareDatasets(jd);
            if (jd != null && jd.getMainDataset() != null && (query = jd.getMainDataset().getQuery()) != null) {
                String mlang = query.getLanguage();
                if (mlang.equals("sql") && Misc.isNullOrEmpty((String)query.getText())) {
                    mlang = null;
                }
                for (JRDataset subds : jd.getDatasetsList()) {
                    if (SyncDatasetRunParameters.isNeedParameters(subds) || subds.getQuery() == null || mlang != null && !mlang.equals(subds.getQuery().getLanguage())) continue;
                    try {
                        Object[] bprms = SyncDatasetRunParameters.getBuiltInParameters(jConf, subds.getQuery().getLanguage());
                        if (bprms == null) continue;
                        for (JRDesignDatasetRun dr : SyncDatasetRunParameters.getDatasetRun(mrep, subds)) {
                            SyncDatasetRunParameters.setupDatasetRun(bprms, dr);
                        }
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setupDatasetRun(Object[] bprms, JRDesignDatasetRun dr) throws JRException {
        if (dr.getDataSourceExpression() != null || dr.getParametersMapExpression() != null) {
            return;
        }
        int i = 0;
        while (i < bprms.length) {
            String pname = (String)bprms[i];
            if (SyncDatasetRunParameters.getParameter(dr, pname) == null) {
                JRDesignDatasetParameter prm = new JRDesignDatasetParameter();
                prm.setName(pname);
                prm.setExpression((JRExpression)new JRDesignExpression("$P{" + pname + "}"));
                dr.addParameter((JRDatasetParameter)prm);
            }
            i += 2;
        }
    }

    public static void cleanDatasetRun(Object[] bprms, JRDesignDatasetRun dr) {
        if (dr.getDataSourceExpression() != null) {
            return;
        }
        int i = 0;
        while (i < bprms.length) {
            String pname = (String)bprms[i];
            JRDatasetParameter p = SyncDatasetRunParameters.getParameter(dr, pname);
            if (p != null && p.getExpression() != null && p.getExpression().getText() != null && p.getExpression().getText().equals("$P{" + pname + "}")) {
                dr.removeParameter(p);
            }
            i += 2;
        }
    }

    private static JRDatasetParameter getParameter(JRDesignDatasetRun dr, String name) {
        JRDatasetParameter[] jRDatasetParameterArray = dr.getParameters();
        int n = jRDatasetParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRDatasetParameter p = jRDatasetParameterArray[n2];
            if (p.getName().equals(name)) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    public static List<JRDesignDatasetRun> getDatasetRun(MReport mrep, JRDataset jDataset) {
        final String dsName = jDataset.getName();
        final ArrayList<JRDesignDatasetRun> dsRuns = new ArrayList<JRDesignDatasetRun>();
        new ModelVisitor<Object>((INode)mrep){

            @Override
            public boolean visit(INode n) {
                List<MDatasetRun> dsRunList;
                if (n instanceof IDatasetContainer && (dsRunList = ((IDatasetContainer)((Object)n)).getDatasetRunList()) != null) {
                    for (MDatasetRun mdsrun : dsRunList) {
                        JRDesignDatasetRun dsrun = mdsrun.getValue();
                        if (dsrun == null || dsrun.getDataSourceExpression() != null || dsrun.getDatasetName() == null || !dsrun.getDatasetName().equals(dsName)) continue;
                        dsRuns.add(dsrun);
                    }
                }
                return true;
            }
        };
        return dsRuns;
    }
}

