/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import com.jaspersoft.studio.swt.widgets.NullableSpinner;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import com.jaspersoft.studio.utils.Messages;
import com.jaspersoft.studio.utils.SWTImageEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class UIUtil {
    public static final String PROPERTIES_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    public static final String COLOR_OUTLINE_DISABLED = "org.eclipse.ui.workbench.ACTIVE_TAB_UNSELECTED_TEXT_COLOR";
    public static final String COLOR_TEXT = "org.eclipse.ui.editors.foregroundColor";
    public static final String FORMDIALOG_CONTAINER_BACKGROUND = "org.eclipse.ui.workbench.INFORMATION_BACKGROUND";

    private UIUtil() {
    }

    public static void setSpinnerSelection(Spinner spinner, Object obj) {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof Integer)) {
            return;
        }
        int num = (Integer)obj;
        if (spinner.getSelection() != num) {
            spinner.setSelection(num);
        }
    }

    public static void setSpinnerSelection(Spinner spinner, Object obj, int defValue) {
        int num = defValue;
        if (obj != null && obj instanceof Integer) {
            num = (Integer)obj;
        }
        if (!spinner.isDisposed() && spinner.getSelection() != num) {
            spinner.setSelection(num);
        }
    }

    public static void setSpinnerSelection(NullableSpinner spinner, Object obj, Number defValue) {
        Number num = defValue;
        if (obj != null && obj instanceof Number) {
            num = (Number)obj;
        }
        if (!spinner.isDisposed() && spinner.getValue() != num) {
            spinner.setValue(num);
        }
    }

    public static Label createLabel(Composite parent, String txt) {
        return UIUtil.createLabel(parent, txt, -1);
    }

    public static Label createLabel(Composite parent, String txt, int span) {
        Label lbl = new Label(parent, 131072);
        lbl.setText(txt);
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            lbl.setLayoutData((Object)rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(130);
            gd.verticalIndent = 5;
            if (span > 0) {
                gd.horizontalSpan = span;
            }
            lbl.setLayoutData((Object)gd);
        }
        return lbl;
    }

    public static Label createSeparator(Composite parent, int span) {
        Label lbl = new Label(parent, 322);
        if (parent.getLayout() instanceof RowLayout) {
            RowData rd = new RowData();
            lbl.setLayoutData((Object)rd);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = span;
            lbl.setLayoutData((Object)gd);
        }
        return lbl;
    }

    public static Composite createSection(Composite parent, String text, boolean expanded, int cols) {
        Section ec = new Section(parent, 4);
        ec.setText(Misc.nvl((String)text));
        ec.setExpanded(expanded);
        ec.setFont(ResourceManager.getBoldFont((Font)ec.getFont()));
        Label lbl = new Label((Composite)ec, 258);
        ec.setSeparatorControl((Control)lbl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        ec.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        ec.setLayoutData((Object)gd);
        Composite c = new Composite((Composite)ec, 64);
        c.setLayout((Layout)new GridLayout(cols, false));
        ec.setClient((Control)c);
        return c;
    }

    public static void setBold(Control control) {
        control.setFont(SWTResourceManager.getBoldFont((Font)control.getFont()));
    }

    public static int getCharWidth(Drawable control) {
        GC gc = new GC(control);
        FontMetrics fm = gc.getFontMetrics();
        int w = fm.getAverageCharWidth();
        gc.dispose();
        return w;
    }

    public static int getCharHeight(Drawable control) {
        GC gc = new GC(control);
        FontMetrics fm = gc.getFontMetrics();
        int h = fm.getHeight();
        gc.dispose();
        return h;
    }

    public static void setFontHeight(Control control, int height) {
        String name = "";
        FontData[] fontData = control.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            name = fontData[i].getName();
            ++i;
        }
        control.setFont(SWTResourceManager.getFont((String)name, (int)height, (int)1));
    }

    public static void addSelectOnFocusToText(Text text) {
        Listener listener = new Listener(){
            private boolean hasFocus = false;
            private boolean hadFocusOnMousedown = false;

            public void handleEvent(Event e) {
                Text t = (Text)e.widget;
                switch (e.type) {
                    case 15: {
                        t.selectAll();
                        t.getDisplay().asyncExec(() -> {
                            boolean bl = this.hasFocus = true;
                        });
                        break;
                    }
                    case 16: {
                        this.hasFocus = false;
                        ((Text)e.widget).clearSelection();
                        break;
                    }
                    case 3: {
                        this.hadFocusOnMousedown = this.hasFocus;
                        break;
                    }
                    case 4: {
                        if (t.getSelectionCount() != 0 || this.hadFocusOnMousedown) break;
                        ((Text)e.widget).selectAll();
                        break;
                    }
                }
            }
        };
        text.addListener(15, listener);
        text.addListener(16, listener);
        text.addListener(3, listener);
        text.addListener(4, listener);
    }

    public static void setViewerCellEditingOnDblClick(TableViewer tviewer) {
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tviewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 3;
            }
        };
        TableViewerEditor.create((TableViewer)tviewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)1);
    }

    public static void setViewerCellEditingOnDblClick(TreeViewer tviewer) {
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tviewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 3;
            }
        };
        TreeViewerEditor.create((TreeViewer)tviewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)1);
    }

    public static void createErrorDecorationForEmptyText(Text widget, int marginWidth, String description) {
        ControlDecoration textDecoration = UIUtil.createErrorDecoration((Control)widget, marginWidth, description);
        widget.addModifyListener(e -> {
            if (widget.getText() == null || widget.getText().trim().isEmpty()) {
                textDecoration.show();
            } else {
                textDecoration.hide();
            }
        });
    }

    public static void createErrorDecorationForBlankExpression(WTextExpression widget, int marginWidth, String description) {
        ControlDecoration textDecoration = UIUtil.createErrorDecoration((Control)widget, marginWidth, description);
        widget.addModifyListener(event -> {
            if (widget.getText() == null || widget.getText().trim().isEmpty()) {
                textDecoration.show();
            } else {
                textDecoration.hide();
            }
        });
    }

    private static ControlDecoration createErrorDecoration(Control control, int marginWidth, String description) {
        ControlDecoration textDecoration = new ControlDecoration(control, 16512);
        textDecoration.setDescriptionText(description);
        textDecoration.setMarginWidth(marginWidth);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        textDecoration.setImage(fieldDecoration.getImage());
        return textDecoration;
    }

    public static boolean isPropertiesViewFocused() {
        try {
            String activePartViewID = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getId();
            return PROPERTIES_VIEW_ID.equals(activePartViewID);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setGallyeryItemImageInfo(GalleryItem item, String pluginID, String imagePath, Map<String, Image> selectedImagesCache, Map<String, Image> standardImagesCache) {
        Image selectedImg = selectedImagesCache.get(imagePath);
        Image standardImg = standardImagesCache.get(imagePath);
        if (selectedImg == null || standardImg == null) {
            Image itemImage = ResourceManager.getPluginImage((String)pluginID, (String)imagePath);
            selectedImg = new Image(itemImage.getDevice(), SWTImageEffects.extendArea(itemImage.getImageData(), 20, null));
            standardImg = new Image(itemImage.getDevice(), SWTImageEffects.Glow.glow(itemImage.getImageData(), ResourceManager.getColor((int)15), 20, 0, 255));
            standardImagesCache.put(imagePath, standardImg);
            selectedImagesCache.put(imagePath, selectedImg);
        }
        item.setSelectedImage(selectedImg);
        item.setStandardImage(standardImg);
        item.setImage(standardImg);
    }

    public static boolean isArrowKey(int keyCode) {
        return keyCode == 0x1000002 || keyCode == 0x1000003 || keyCode == 0x1000004 || keyCode == 0x1000001;
    }

    public static boolean isMacAndEclipse4() {
        return Util.isMac() && UIUtil.isEclipse4();
    }

    public static boolean isEclipse4() {
        return Platform.getBundle((String)"org.eclipse.e4.ui.workbench") != null;
    }

    public static String getEclipseVersion() {
        Bundle platformBundle = Platform.getBundle((String)"org.eclipse.platform");
        Bundle rcpBundle = Platform.getBundle((String)"org.eclipse.rcp");
        Version version = null;
        if (platformBundle != null) {
            version = platformBundle.getVersion();
        }
        if (version == null && rcpBundle != null) {
            version = rcpBundle.getVersion();
        }
        if (version != null) {
            return String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro();
        }
        return "0.0.0";
    }

    public static boolean shouldTrickToolbar() {
        return UIUtil.isEclipse4();
    }

    public static void updateFocus(Control toFocus) {
        Control focusedControl = toFocus.getDisplay().getFocusControl();
        if (focusedControl != toFocus) {
            boolean isFocusedEnabled;
            boolean bl = isFocusedEnabled = focusedControl != null && focusedControl.isEnabled();
            if (isFocusedEnabled) {
                focusedControl.setEnabled(false);
                focusedControl.setEnabled(true);
            }
            toFocus.setFocus();
        }
    }

    public static void enableCopyPasteCutContextMenu(final StyledText widget) {
        Menu menu = new Menu((Decorations)widget.getShell(), 8);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        final MenuItem cutItem = new MenuItem(menu, 8);
        cutItem.setText(Messages.UIUtil_CutMenuItemText);
        UIUtil.safeApplyMenuItemTooltip(cutItem, Messages.UIUtil_CutMenuItemTooltip);
        cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                widget.invokeAction(131199);
            }
        });
        cutItem.setImage(ResourceManager.getImage((ImageDescriptor)sharedImages.getImageDescriptor("IMG_TOOL_CUT")));
        final MenuItem copyItem = new MenuItem(menu, 8);
        copyItem.setText(Messages.UIUtil_CopyMenuItemText);
        UIUtil.safeApplyMenuItemTooltip(copyItem, Messages.UIUtil_CopyMenuItemTooltip);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                widget.invokeAction(17039369);
            }
        });
        copyItem.setImage(ResourceManager.getImage((ImageDescriptor)sharedImages.getImageDescriptor("IMG_TOOL_COPY")));
        final MenuItem pasteItem = new MenuItem(menu, 8);
        pasteItem.setText(Messages.UIUtil_PasteMenuItemText);
        UIUtil.safeApplyMenuItemTooltip(pasteItem, Messages.UIUtil_PasteMenuItemTooltip);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                widget.invokeAction(16908297);
            }
        });
        pasteItem.setImage(ResourceManager.getImage((ImageDescriptor)sharedImages.getImageDescriptor("IMG_TOOL_PASTE")));
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                cutItem.setEnabled(!widget.getSelectionText().isEmpty());
                copyItem.setEnabled(!widget.getSelectionText().isEmpty());
                Clipboard cb = new Clipboard(widget.getDisplay());
                Object contents = cb.getContents((Transfer)TextTransfer.getInstance());
                if (contents instanceof String && !((String)contents).isEmpty()) {
                    pasteItem.setEnabled(true);
                } else {
                    pasteItem.setEnabled(false);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        widget.setMenu(menu);
    }

    public static void safeApplyMenuItemTooltip(MenuItem menuItem, String tooltipTxt) {
        String minSWTVersion = "3.104";
        String currentSWTVersion = BundleCommonUtils.getBundleVersion((String)"org.eclipse.swt");
        if (currentSWTVersion != null && currentSWTVersion.compareTo(minSWTVersion) >= 0) {
            menuItem.setToolTipText(tooltipTxt);
        }
    }

    public static void safeRequestLayout(Composite control) {
        String minSWTVersion = "3.105";
        String currentSWTVersion = BundleCommonUtils.getBundleVersion((String)"org.eclipse.swt");
        if (currentSWTVersion != null && currentSWTVersion.compareTo(minSWTVersion) >= 0) {
            control.requestLayout();
        } else {
            control.layout(true, true);
        }
    }

    public static Color getColor(String key) {
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        return currentTheme.getColorRegistry().get(key);
    }

    public static void printThemeColors() {
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ArrayList keys = new ArrayList(currentTheme.getColorRegistry().getKeySet());
        System.out.println("-------------------------------");
        keys.stream().sorted().forEach(c -> System.out.println((String)c));
        System.out.println("-------------------------------");
    }

    public static enum EditorExtension {
        JRXML(".jrxml"),
        JRCTX(".jrctx"),
        JRTX(".jrtx"),
        JASPER(".jasper"),
        JRPRINT(".jrprint"),
        JRPXML(".jrpxml"),
        JSSCE(".jssce");

        private String extension;

        private EditorExtension(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }

        public static boolean isKnowExtension(String extension) {
            EditorExtension[] editorExtensionArray = EditorExtension.values();
            int n = editorExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorExtension ex = editorExtensionArray[n2];
                if (ex.getExtension().equals(extension)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static List<String> getKnowExtensions() {
            ArrayList<String> result = new ArrayList<String>();
            EditorExtension[] editorExtensionArray = EditorExtension.values();
            int n = editorExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorExtension ex = editorExtensionArray[n2];
                result.add(ex.getExtension());
                ++n2;
            }
            return result;
        }

        public static boolean hasValidExtension(String filepath) {
            for (String ext : EditorExtension.getKnowExtensions()) {
                if (!filepath.endsWith(ext)) continue;
                return true;
            }
            return false;
        }
    }
}

