/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public class ValidatedDecimalFormat
extends DecimalFormat {
    public static final DecimalFormatSymbols SYMBOLS;
    public static final char DECIMAL_SEPARATOR;
    public static final String PATTERN_DECIMAL_SEPARATOR;
    private static final long serialVersionUID = -8953035800738294624L;
    private Pattern patternToMatch;

    static {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        SYMBOLS = format.getDecimalFormatSymbols();
        DECIMAL_SEPARATOR = ValidatedDecimalFormat.getDecimalSeparator();
        PATTERN_DECIMAL_SEPARATOR = ValidatedDecimalFormat.getPatternDecimalSeparator();
    }

    public ValidatedDecimalFormat(int minAcceptedDigits, int maxAcceptedDigits) {
        Assert.isTrue((minAcceptedDigits >= 0 ? 1 : 0) != 0, (String)"Digits number can't be negative");
        Assert.isTrue((maxAcceptedDigits >= minAcceptedDigits ? 1 : 0) != 0, (String)"The max accepted digits must be less or equal of the number of digits");
        this.setParseBigDecimal(maxAcceptedDigits > 10);
        String pattern = null;
        if (maxAcceptedDigits > 0) {
            pattern = "#####0.";
            int i = 0;
            while (i < maxAcceptedDigits) {
                pattern = i < minAcceptedDigits ? String.valueOf(pattern) + "0" : String.valueOf(pattern) + "#";
                ++i;
            }
        } else {
            pattern = "######";
        }
        this.patternToMatch = maxAcceptedDigits == 0 ? Pattern.compile("[0-9]+") : Pattern.compile("[0-9]+([" + DECIMAL_SEPARATOR + "]{0,1}[0-9]{0," + maxAcceptedDigits + "})?");
        this.applyPattern(pattern);
    }

    @Override
    public Number parse(String source) throws ParseException {
        Matcher matcher;
        ParsePosition pp = new ParsePosition(0);
        String valueToParse = source;
        boolean isNegative = false;
        if (valueToParse.startsWith("-")) {
            isNegative = true;
            valueToParse = "0" + valueToParse.substring(1);
        }
        if (!(matcher = this.patternToMatch.matcher(valueToParse)).matches()) {
            throw new ParseException(valueToParse, pp.getIndex());
        }
        Number result = super.parse(valueToParse, pp);
        if (pp.getIndex() == valueToParse.length()) {
            return isNegative ? (Number)(result.doubleValue() * -1.0) : (Number)result;
        }
        throw new ParseException(valueToParse, pp.getIndex());
    }

    protected static char getDecimalSeparator() {
        return SYMBOLS.getDecimalSeparator();
    }

    protected static String getPatternDecimalSeparator() {
        if (".".equals(String.valueOf(DECIMAL_SEPARATOR))) {
            return "\\.";
        }
        return String.valueOf(DECIMAL_SEPARATOR);
    }
}

