/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static DocumentBuilder db;

    private XMLUtils() {
    }

    public static Document parseNoValidation(InputStream io) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.getDocumentBuilder().parse(io);
    }

    public static Document parseNoValidation(String xml) throws ParserConfigurationException, SAXException, IOException {
        Document doc = null;
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            doc = XMLUtils.getDocumentBuilder().parse(is);
            return doc;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (db == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setIgnoringComments(true);
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            db = dbf.newDocumentBuilder();
        }
        return db;
    }

    public static boolean isNamespaceAware(XmlDataAdapter xmlDataAdapter, JasperDesign jdesign) {
        if (xmlDataAdapter != null) {
            return xmlDataAdapter.isNamespaceAware();
        }
        if (jdesign != null) {
            String detectNamespaces = jdesign.getProperty("net.sf.jasperreports.xml.detect.namespaces");
            return detectNamespaces != null && "true".equals(detectNamespaces);
        }
        return false;
    }

    public static String getChildText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
            } else if (type == 4) {
                str.append(XMLUtils.getChildText(child));
            }
            child = child.getNextSibling();
        }
        return str.toString();
    }
}

