/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.jasper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ExtensionLoader {
    private static HashMap<Class<?>, Object> sharedExtensionCache = new HashMap();
    private static Class<?>[] commonExensionKeys = new Class[0];
    private static HashSet<Class<?>> missingExtensions = new HashSet(Arrays.asList(commonExensionKeys));
    private static HashSet<Class<?>> loadingExtensions = new HashSet();
    private static int EXTENSION_LOADING_WAITING_MS = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLoadingStart(Class<?> extensionKey) {
        HashSet<Class<?>> hashSet = loadingExtensions;
        synchronized (hashSet) {
            loadingExtensions.add(extensionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLoadingEnd(Class<?> extensionKey, Object loadedObject) {
        HashSet<Class<?>> hashSet = loadingExtensions;
        synchronized (hashSet) {
            sharedExtensionCache.put(extensionKey, loadedObject);
            loadingExtensions.remove(extensionKey);
            missingExtensions.remove(extensionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCurrentlyLoading(Class<?> extensionKey) {
        HashSet<Class<?>> hashSet = loadingExtensions;
        synchronized (hashSet) {
            return loadingExtensions.contains(extensionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCurrentlyLoading() {
        HashSet<Class<?>> hashSet = loadingExtensions;
        synchronized (hashSet) {
            return !missingExtensions.isEmpty();
        }
    }

    public static void initializeJRExtensions(IProgressMonitor monitor) {
        DefaultJasperReportsContext context = DefaultJasperReportsContext.getInstance();
        monitor.beginTask("Loading JR extensions", commonExensionKeys.length);
        Class<?>[] classArray = commonExensionKeys;
        int n = commonExensionKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> extensionKey = classArray[n2];
            monitor.subTask(NLS.bind((String)"Loading JR extension: {0}", (Object)extensionKey.getCanonicalName()));
            ExtensionLoader.setLoadingStart(extensionKey);
            List obj = context.getExtensions(extensionKey);
            ExtensionLoader.setLoadingEnd(extensionKey, obj);
            monitor.worked(1);
            ++n2;
        }
    }

    public static void waitIfLoading(Class<?> extensionKey) {
        while (ExtensionLoader.isCurrentlyLoading(extensionKey)) {
            try {
                Thread.sleep(EXTENSION_LOADING_WAITING_MS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void waitIfLoading() {
        while (ExtensionLoader.isCurrentlyLoading()) {
            try {
                Thread.sleep(EXTENSION_LOADING_WAITING_MS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

