/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.jasper;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.customadapters.JSSCastorUtil;
import com.jaspersoft.studio.editor.context.AEditorContext;
import com.jaspersoft.studio.editor.context.EditorContextUtil;
import com.jaspersoft.studio.jasper.JSSReportConverter;
import com.jaspersoft.studio.jasper.LazyImageConverter;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.prm.ParameterSetProvider;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.ExtensionCache;
import com.jaspersoft.studio.utils.jasper.JSSFileRepositoryService;
import com.jaspersoft.studio.utils.jasper.ResourceChangeEvent;
import com.jaspersoft.studio.widgets.framework.manager.WidgetsDefinitionManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.data.BuiltinDataFileServiceFactory;
import net.sf.jasperreports.data.DataAdapterParameterContributorFactory;
import net.sf.jasperreports.eclipse.IDisposeListener;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.query.EmptyQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.DefaultChartTheme;
import net.sf.jasperreports.engine.fonts.FontExtensionsCollector;
import net.sf.jasperreports.engine.fonts.FontExtensionsReceiver;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontSet;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.util.MessageProviderFactory;
import net.sf.jasperreports.engine.util.ResourceBundleMessageProviderFactory;
import net.sf.jasperreports.functions.FunctionsBundle;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.util.CastorMapping;
import net.sf.jasperreports.utils.JRExtensionsUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.osgi.service.prefs.Preferences;

public class JasperReportsConfiguration
extends SimpleJasperReportsContext {
    public static final String KEY_JASPERDESIGN = "JasperDesign";
    public static final String PROPERTY_JRPROPERTY_PREFIX = "ireport.jrproperty.";
    public static final String KEY_JRPARAMETERS = "KEY_PARAMETERS";
    public static final String KEY_DRAWER = "REPORT_DRAWER";
    public static final String KEY_CONVERTER = "REPORT_CONVERTER";
    public static final String REPORT_FILE = "REPORTFILEWIZARD";
    public static final String REPORT_DESIGN = "REPORTDESIGNWIZARD";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private PreferenceListener preferenceListener;
    private ResourceLoadedListener resourceLoadedListener;
    private String[] fontList;
    private boolean refreshFonts = true;
    private FontExtensionsCollector lst;
    private ExtensionCache<ComponentsBundle> componentBundles = new ExtensionCache();
    private ExtensionCache<FunctionsBundle> functionsBundles = new ExtensionCache();
    private ExtensionCache<CastorMapping> castorBundles = new ExtensionCache();
    private ExtensionCache<ChartThemeBundle> chartThemesBundles = new ExtensionCache();
    private ExtensionCache<MessageProviderFactory> messageProviderFactory = new ExtensionCache();
    private static JasperReportsConfiguration instance;
    private List<JRQueryExecuterFactoryBundle> qExecutors;
    private Map<Object, Object> map;
    private MScopedPreferenceStore pstore;
    private List<IDisposeListener> toDispose;
    private boolean isPropsCached = false;
    private ParameterSetProvider prmProvider;
    protected JSSStyleResolver resolver;
    protected AEditorContext cntx;

    public JasperReportsConfiguration(JasperReportsContext parent, IFile file) {
        super(parent);
        this.init(file);
        this.resolver = new JSSStyleResolver(this);
    }

    public MScopedPreferenceStore getPrefStore() {
        return this.pstore;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public AEditorContext getEditorContext() {
        return this.cntx;
    }

    public void changeContext(String c, boolean reset) {
        IFile oldFile = (IFile)this.get("ifile");
        try {
            if (oldFile.exists()) {
                oldFile.setPersistentProperty(new QualifiedName(JaspersoftStudioPlugin.getUniqueIdentifier(), "editor.context"), reset ? null : c);
            }
        }
        catch (CoreException e) {
            UIUtils.showError((Throwable)e);
        }
        this.remove("ifile");
        this.isPropsCached = false;
        this.init(oldFile);
        this.resetCaches(null);
        this.getProperties();
    }

    public void init(IFile file) {
        IFile oldFile = (IFile)this.get("ifile");
        if (oldFile != null && oldFile == file) {
            return;
        }
        String qualifier = JaspersoftStudioPlugin.getUniqueIdentifier();
        this.pstore = (MScopedPreferenceStore)JaspersoftStudioPlugin.getInstance().getPreferenceStore((IResource)file, qualifier);
        this.cntx = EditorContextUtil.getEditorContext(file, this);
        this.cntx.initClassloader();
        IProject project = null;
        if (file != null) {
            this.put("ifile", file);
            project = file.getProject();
            this.put("iproject", project);
            this.cntx.configureRepositoryService();
        }
        this.isPropsCached = false;
        this.getProperties();
        if (this.preferenceListener == null) {
            this.preferenceListener = new PreferenceListener();
            JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, (IResource)file);
        }
        if (this.resourceLoadedListener == null) {
            this.resourceLoadedListener = new ResourceLoadedListener();
            this.getPropertyChangeSupport().addPropertyChangeListener(this.resourceLoadedListener);
        }
    }

    public void resetCaches(java.beans.PropertyChangeEvent arg0) {
        this.refreshFonts = true;
        this.fontList = null;
        this.messageProviderFactory.invalidate();
        this.functionsBundles.invalidate();
        this.componentBundles.invalidate();
        this.chartThemesBundles.invalidate();
        ExpressionUtil.removeAllReportInterpreters(this);
        if (arg0 != null) {
            this.propertyChangeSupport.firePropertyChange(new java.beans.PropertyChangeEvent((Object)this, "classpath", null, arg0));
        }
        this.castorBundles.invalidate();
    }

    public JSSFileRepositoryService getFileRepositoryService() {
        if (this.cntx.getRepositoryServices() != null) {
            for (RepositoryService rs : this.cntx.getRepositoryServices()) {
                if (!(rs instanceof JSSFileRepositoryService)) continue;
                return (JSSFileRepositoryService)rs;
            }
        }
        return null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.cntx.setClassLoader(classLoader);
    }

    public void dispose() {
        ExpressionUtil.removeAllReportInterpreters(this);
        ExternalStylesManager.removeCachedStyles(this);
        LazyImageConverter.getInstance().removeCachedImages(this);
        WidgetsDefinitionManager.disposedConfiguration(this);
        JaspersoftStudioPlugin.getInstance().removePreferenceListener(this.preferenceListener);
        this.getPropertyChangeSupport().removePropertyChangeListener(this.resourceLoadedListener);
        this.cntx.dispose();
        for (PropertyChangeListener l : Arrays.asList(this.propertyChangeSupport.getPropertyChangeListeners())) {
            this.propertyChangeSupport.removePropertyChangeListener(l);
        }
        if (this.toDispose != null) {
            for (IDisposeListener d : this.toDispose) {
                d.dispose();
            }
        }
    }

    public void addDisposeListener(IDisposeListener listener) {
        if (this.toDispose == null) {
            this.toDispose = new ArrayList<IDisposeListener>();
        }
        this.toDispose.add(listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        if (this.toDispose == null) {
            return;
        }
        this.toDispose.remove(listener);
    }

    public void put(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.removeValue(key);
        } else {
            this.setValue(key, value);
        }
    }

    public Object get(String key) {
        return this.getValue(key);
    }

    public void remove(String key) {
        this.removeValue(key);
    }

    public ClassLoader getClassLoader() {
        return this.cntx.getClassLoader();
    }

    public JasperDesign getJasperDesign() {
        return (JasperDesign)this.get(KEY_JASPERDESIGN);
    }

    public void setJasperDesign(JasperDesign jd) {
        if (jd == null) {
            this.remove(KEY_JASPERDESIGN);
        } else {
            this.put(KEY_JASPERDESIGN, jd);
        }
    }

    public void setJRParameters(Map<String, Object> value) {
        this.put(KEY_JRPARAMETERS, value);
        if (value != null) {
            if (this.prmProvider == null) {
                this.prmProvider = new ParameterSetProvider(this);
            }
            this.prmProvider.initParameterValues(value);
        }
    }

    public Map<String, Object> getJRParameters() {
        return (Map)this.get(KEY_JRPARAMETERS);
    }

    public <T> T get(String key, T def) {
        Object value = this.get(key);
        if (value != null && def != null && value.getClass().isAssignableFrom(def.getClass())) {
            return (T)value;
        }
        return def;
    }

    public void refreshProperties() {
        this.isPropsCached = false;
        this.getProperties();
    }

    public Map<String, String> getProperties() {
        String val;
        if (this.isPropsCached) {
            return this.getPropertiesMap();
        }
        this.setPropertiesMap(null);
        Map smap = super.getProperties();
        HashMap<String, String> propmap = new HashMap<String, String>();
        if (smap != null && !smap.isEmpty()) {
            propmap.putAll(smap);
        }
        this.setPropertiesMap(propmap);
        Properties props = this.cntx.getJrProperties();
        for (Object key : props.keySet()) {
            if (!(key instanceof String) || (val = props.getProperty((String)key)) == null) continue;
            propmap.put((String)key, val);
        }
        this.isPropsCached = true;
        this.pstore.setWithDefault(false);
        for (Object key : propmap.keySet()) {
            val = Misc.nullIfEmpty((String)this.pstore.getString((String)key));
            if (val == null) continue;
            propmap.put((String)key, val);
        }
        this.pstore.setWithDefault(true);
        return propmap;
    }

    public String getProperty(String key) {
        this.pstore.setWithDefault(false);
        String val = Platform.getPreferencesService().get(key, null, (Preferences[])this.pstore.getPreferenceNodes(true));
        this.pstore.setWithDefault(true);
        if (val != null) {
            return val;
        }
        return super.getProperty(key);
    }

    public String getPropertyDef(String key, String def) {
        String p = this.getProperty(key);
        if (p == null) {
            p = this.pstore.getDefaultString(key);
        }
        if (p == null) {
            p = def;
        }
        return p;
    }

    public String getProperty(String key, String def) {
        String p = this.getProperty(key);
        if (p == null) {
            return def;
        }
        return p;
    }

    public Character getPropertyCharacterDef(String key, Character def) {
        String v;
        Character p = this.getPropertyCharacter(key);
        if (p == null && (v = this.pstore.getDefaultString(key)) != null && !v.isEmpty()) {
            return Character.valueOf(v.charAt(0));
        }
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Character getPropertyCharacter(String key, Character def) {
        Character p = this.getPropertyCharacter(key);
        if (p == null) {
            p = def;
        }
        return p;
    }

    public Character getPropertyCharacter(String key) {
        String p = this.getProperty(key);
        if (p != null && !p.isEmpty()) {
            return Character.valueOf(p.charAt(0));
        }
        return null;
    }

    public Boolean getPropertyBoolean(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Boolean.parseBoolean(p);
        }
        return null;
    }

    public Boolean getPropertyBoolean(String key, boolean def) {
        Boolean p = this.getPropertyBoolean(key);
        if (p == null) {
            return def;
        }
        return p;
    }

    public Boolean getPropertyBooleanDef(String key, boolean def) {
        Boolean p = this.getPropertyBoolean(key);
        if (p == null) {
            p = this.pstore.getDefaultBoolean(key);
        }
        if (p == null) {
            return def;
        }
        return p;
    }

    public Integer getPropertyInteger(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Integer.valueOf(p);
        }
        return null;
    }

    public Integer getPropertyInteger(String key, int def) {
        Integer p = this.getPropertyInteger(key);
        if (p == null) {
            return def;
        }
        return p;
    }

    public Integer getPropertyIntegerDef(String key, int def) {
        Integer p = this.getPropertyInteger(key);
        if (p == null) {
            p = this.pstore.getDefaultInt(key);
        }
        if (p == null) {
            return def;
        }
        return p;
    }

    public Long getPropertyLong(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Long.valueOf(p);
        }
        return null;
    }

    public Long getPropertyIntegerDef(String key, long def) {
        Long p = this.getPropertyLong(key);
        if (p == null) {
            p = this.pstore.getDefaultLong(key);
        }
        if (p == null) {
            return def;
        }
        return p;
    }

    public Float getPropertyFloat(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Float.valueOf(p);
        }
        return null;
    }

    public Double getPropertyDouble(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return Double.valueOf(p);
        }
        return null;
    }

    public Double getPropertyDoubleDef(String key, double def) {
        Double p = this.getPropertyDouble(key);
        if (p == null) {
            p = this.pstore.getDefaultDouble(key);
        }
        if (p == null) {
            return def;
        }
        return p;
    }

    public Float getPropertyFloat(String key, float def) {
        Float p = this.getPropertyFloat(key);
        if (p == null) {
            return Float.valueOf(def);
        }
        return p;
    }

    public Float getPropertyFloatDef(String key, float def) {
        Float p = this.getPropertyFloat(key);
        if (p == null) {
            p = Float.valueOf(this.pstore.getDefaultFloat(key));
        }
        if (p == null) {
            return Float.valueOf(def);
        }
        return p;
    }

    private List<FontFamily> getExtensionFonts() {
        this.readFonts();
        return this.lst != null ? this.lst.getFontFamilies() : null;
    }

    private List<FontSet> getExtensionFontSets() {
        this.readFonts();
        return this.lst != null ? this.lst.getFontSets() : null;
    }

    protected void readFonts() {
        if (this.refreshFonts) {
            String strprop;
            List sets;
            this.lst = new FontExtensionsCollector();
            List superlist = super.getExtensions(FontFamily.class);
            if (superlist != null) {
                for (FontFamily f : superlist) {
                    if (f == null) continue;
                    this.lst.getFontFamilies().add(f);
                }
            }
            if ((sets = super.getExtensions(FontSet.class)) != null) {
                for (FontSet f : sets) {
                    if (f == null) continue;
                    this.lst.getFontSets().add(f);
                }
            }
            if ((strprop = this.getProperty("FONT_LIST")) != null) {
                SimpleFontExtensionHelper.getInstance().loadFontExtensions((JasperReportsContext)this, (InputStream)new ByteArrayInputStream(strprop.getBytes()), (FontExtensionsReceiver)this.lst, true);
            }
            this.refreshFonts = false;
        }
    }

    public void refreshFonts() {
        this.refreshFonts = true;
        this.fontList = null;
        this.getFontList();
    }

    public synchronized String[] getFontList() {
        if (this.refreshFonts || this.fontList == null) {
            this.refreshFonts = true;
            this.fontList = FontUtils.stringToItems(ModelUtils.getFontNames(this));
        }
        return this.fontList;
    }

    private List<ComponentsBundle> getExtensionComponents() {
        if (!this.componentBundles.isValid()) {
            ArrayList componentBundlesList = super.getExtensions(ComponentsBundle.class);
            LinkedHashSet components = new LinkedHashSet(componentBundlesList);
            componentBundlesList = new ArrayList(components);
            for (ComponentsBundle cb : componentBundlesList) {
                JaspersoftStudioPlugin.getComponentConverterManager().setupComponentConvertor(cb);
            }
            this.componentBundles.setValue(componentBundlesList);
        }
        return this.componentBundles.getValue();
    }

    private List<FunctionsBundle> getExtensionFunctions() {
        if (!this.functionsBundles.isValid()) {
            LinkedHashSet fBundlesSet = new LinkedHashSet(JRExtensionsUtils.getReloadedExtensions(FunctionsBundle.class, (String)"functions"));
            this.functionsBundles.setValue(new ArrayList(fBundlesSet));
        }
        return this.functionsBundles.getValue();
    }

    private List<CastorMapping> getExtensionCastors() {
        if (!this.castorBundles.isValid()) {
            JSSCastorUtil.clearCache(this);
            LinkedHashSet fBundlesSet = new LinkedHashSet(JRExtensionsUtils.getReloadedExtensions(CastorMapping.class, (String)"castor.mapping"));
            this.castorBundles.setValue(new ArrayList(fBundlesSet));
        }
        return this.castorBundles.getValue();
    }

    private List<ChartThemeBundle> getExtensionChartThemes() {
        if (!this.chartThemesBundles.isValid()) {
            LinkedHashSet fBundlesSet = new LinkedHashSet(JRExtensionsUtils.getReloadedExtensions(ChartThemeBundle.class, (String)"chart.theme"));
            ArrayList bundlesList = new ArrayList(fBundlesSet);
            fBundlesSet = new LinkedHashSet(JRExtensionsUtils.getReloadedExtensions(ChartThemeBundle.class, (String)"xml.chart.themes"));
            bundlesList.addAll(fBundlesSet);
            bundlesList.add(0, DefaultChartTheme.BUNDLE);
            this.chartThemesBundles.setValue(bundlesList);
        }
        return this.chartThemesBundles.getValue();
    }

    public List<MessageProviderFactory> getExtensionMessageProviderFactories() {
        if (!this.messageProviderFactory.isValid()) {
            ArrayList<ResourceBundleMessageProviderFactory> factories = new ArrayList<ResourceBundleMessageProviderFactory>();
            factories.add(new ResourceBundleMessageProviderFactory(this.getClassLoader()));
            this.messageProviderFactory.setValue(factories);
        }
        return this.messageProviderFactory.getValue();
    }

    public <T> void setExtensions(Class<T> extensionType, List<? extends T> extensions) {
        if (extensionType == ChartThemeBundle.class) {
            this.chartThemesBundles.setValue(extensions);
            this.chartThemesBundles.setAvoidInvalidation(true);
        } else {
            super.setExtensions(extensionType, extensions);
        }
    }

    public <T> List<T> getExtensions(Class<T> extensionType) {
        List<RepositoryService> result;
        block23: {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            result = null;
            try {
                if (this.cntx.getClassLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.cntx.getClassLoader());
                }
                if (extensionType == FontFamily.class) {
                    result = this.getExtensionFonts();
                    break block23;
                }
                if (extensionType == FontSet.class) {
                    result = this.getExtensionFontSets();
                    break block23;
                }
                if (extensionType == CastorMapping.class) {
                    result = this.getExtensionCastors();
                    break block23;
                }
                if (extensionType == ChartThemeBundle.class) {
                    result = this.getExtensionChartThemes();
                    break block23;
                }
                if (extensionType == ComponentsBundle.class) {
                    result = this.getExtensionComponents();
                    break block23;
                }
                if (extensionType == FunctionsBundle.class) {
                    result = this.getExtensionFunctions();
                    break block23;
                }
                if (extensionType == MessageProviderFactory.class) {
                    result = this.getExtensionMessageProviderFactories();
                    break block23;
                }
                if (extensionType == JRQueryExecuterFactoryBundle.class) {
                    try {
                        if (this.qExecutors == null) {
                            this.qExecutors = new ArrayList<JRQueryExecuterFactoryBundle>();
                            this.qExecutors.add((JRQueryExecuterFactoryBundle)EmptyQueryExecuterFactoryBundle.getInstance((JasperReportsContext)this));
                        }
                        result = this.qExecutors;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break block23;
                }
                if (this.cntx.getRepositoryServices() != null && extensionType == RepositoryService.class) {
                    result = this.cntx.getRepositoryServices();
                    break block23;
                }
                try {
                    result = super.getExtensions(extensionType);
                    if (result != null) {
                        ArrayList<Object> toDel = new ArrayList<Object>();
                        for (Object object : result) {
                            if (object == null || !object.getClass().getName().equals(BuiltinDataFileServiceFactory.class.getName()) && !(object instanceof DataAdapterParameterContributorFactory)) continue;
                            toDel.add(object);
                        }
                        result.removeAll(toDel);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        if (result != null && result.indexOf(null) >= 0) {
            try {
                result.removeAll(Collections.singleton(null));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                result = new ArrayList<FontFamily>(result);
                result.removeAll(Collections.singleton(null));
            }
        }
        return result;
    }

    public Map<Object, Object> getMap() {
        if (this.map == null) {
            this.map = new HashMap<Object, Object>();
        }
        return this.map;
    }

    public static JasperReportsConfiguration getDefaultJRConfig() {
        return new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), null);
    }

    public static JasperReportsConfiguration getDefaultJRConfig(IFile f) {
        return new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), f);
    }

    public static JasperReportsConfiguration getDefaultInstance() {
        if (instance == null) {
            instance = new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), null);
        }
        return instance;
    }

    public void refreshClasspath() {
        this.cntx.refreshClasspath();
    }

    public IFile getAssociatedReportFile() {
        return (IFile)this.get("ifile");
    }

    public void refreshCachedStyles() {
        JSSReportConverter reportConverter = this.getReportConverter();
        if (reportConverter != null) {
            reportConverter.refreshCachedStyles();
            JasperDesign design = this.getJasperDesign();
            JRStyle[] jRStyleArray = design.getStyles();
            int n = jRStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRStyle style = jRStyleArray[n2];
                if (style.getStyleNameReference() != null) {
                    ((JRDesignStyle)style).setParentStyle(ExternalStylesManager.getExternalStyle(style.getStyleNameReference(), this));
                }
                ++n2;
            }
            java.beans.PropertyChangeEvent changeEvent = new java.beans.PropertyChangeEvent(design, MGraphicElement.FORCE_GRAPHICAL_REFRESH, false, true);
            for (JRDesignElement element : ModelUtils.getAllElements(design)) {
                element.getEventSupport().firePropertyChange(changeEvent);
            }
        }
    }

    public JSSReportConverter getReportConverter() {
        Object converter = this.get(KEY_CONVERTER);
        if (converter instanceof JSSReportConverter) {
            return (JSSReportConverter)((Object)converter);
        }
        return null;
    }

    public JSSStyleResolver getStyleResolver() {
        return this.resolver;
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("FONT_LIST")) {
                JasperReportsConfiguration.this.refreshFonts();
                JasperReportsConfiguration.this.componentBundles.invalidate();
            } else if (property.equals("net.sf.jasperreports.JRPROPERTIES")) {
                JasperReportsConfiguration.this.componentBundles.invalidate();
                JasperReportsConfiguration.this.isPropsCached = false;
                JasperReportsConfiguration.this.getProperties();
                JasperReportsConfiguration.this.qExecutors = null;
            } else if (JasperReportsConfiguration.this.prmProvider != null && property.startsWith("com.jaspersoft.studio.parameterset")) {
                JasperReportsConfiguration.this.prmProvider.reset();
            } else if (property.startsWith("com.jaspersoft.studio.")) {
                JasperReportsConfiguration.this.isPropsCached = false;
                JasperReportsConfiguration.this.getProperties();
            }
            JasperReportsConfiguration.this.propertyChangeSupport.firePropertyChange(new java.beans.PropertyChangeEvent(this, "preferences", null, event));
        }
    }

    private final class ResourceLoadedListener
    implements PropertyChangeListener {
        private ResourceLoadedListener() {
        }

        private void refreshImages() {
            LazyImageConverter.getInstance().removeCachedImages(JasperReportsConfiguration.this);
        }

        private void refreshStyles() {
            ExternalStylesManager.removeCachedStyles(JasperReportsConfiguration.this);
            JasperReportsConfiguration.this.refreshCachedStyles();
            JRReportTemplate[] templates = JasperReportsConfiguration.this.getJasperDesign().getTemplates();
            if (templates != null) {
                int i = 0;
                while (i < templates.length) {
                    ((JRDesignReportTemplate)templates[i]).getEventSupport().firePropertyChange("forceUpdateChildren", null, null);
                    ++i;
                }
            }
        }

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("RESOURCE_LOADED")) {
                if (evt instanceof ResourceChangeEvent) {
                    ResourceChangeEvent rEvt = (ResourceChangeEvent)evt;
                    switch (rEvt.getResourceType()) {
                        case IMAGE: {
                            this.refreshImages();
                            break;
                        }
                        case TEMPLATE_STYLE: {
                            this.refreshStyles();
                            break;
                        }
                        default: {
                            this.refreshImages();
                            this.refreshStyles();
                            break;
                        }
                    }
                } else {
                    this.refreshImages();
                    this.refreshStyles();
                }
            }
        }
    }
}

