/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.jobs;

import com.jaspersoft.studio.messages.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class CheckedRunnableWithProgress
implements IRunnableWithProgress {
    public static final int DEFAULT_CHECK_INTERVAL = 500;
    private Thread runnerThread = null;
    private int sleepTimeout;
    private IProgressMonitor progressMonitor;
    private volatile boolean executionCompleted;

    public CheckedRunnableWithProgress() {
        this(500);
    }

    public CheckedRunnableWithProgress(int sleepTimeout) {
        this.sleepTimeout = sleepTimeout;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.progressMonitor = monitor;
        try {
            this.runnerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    CheckedRunnableWithProgress.this.runOperations(CheckedRunnableWithProgress.this.progressMonitor);
                    CheckedRunnableWithProgress.this.executionCompleted = true;
                }
            });
            this.runnerThread.start();
            while (!this.executionCompleted) {
                TimeUnit.MILLISECONDS.sleep(this.sleepTimeout);
                if (!monitor.isCanceled()) continue;
                this.abortOperationInvoked();
                throw new InterruptedException(Messages.CheckedRunnableWithProgress_GenericAbortMessage);
            }
        }
        finally {
            this.runnerThread.interrupt();
            this.disposeResources();
        }
    }

    protected abstract void runOperations(IProgressMonitor var1);

    protected void abortOperationInvoked() throws InterruptedException {
    }

    protected void disposeResources() {
    }
}

