/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.utils.jobs;

import com.jaspersoft.studio.utils.jobs.AbortOperationListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitorCheckerThread
extends Thread {
    public static final int DEFAULT_CHECK_INTERVAL = 500;
    private int sleepTimeout;
    private volatile boolean execute;
    private IProgressMonitor monitor;
    private List<AbortOperationListener> listeners;

    public ProgressMonitorCheckerThread(IProgressMonitor monitor) {
        this(monitor, 500);
    }

    public ProgressMonitorCheckerThread(IProgressMonitor monitor, int sleepTimeout) {
        this.sleepTimeout = sleepTimeout;
        this.monitor = monitor;
        this.listeners = new ArrayList<AbortOperationListener>();
    }

    public void addListener(AbortOperationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AbortOperationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void run() {
        this.execute = true;
        while (this.execute) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.sleepTimeout);
                if (!this.monitor.isCanceled()) continue;
                this.execute = false;
                this.abortOperationInvoked();
            }
            catch (InterruptedException interruptedException) {
                this.execute = false;
            }
        }
    }

    private void abortOperationInvoked() {
        for (AbortOperationListener l : this.listeners) {
            l.abortOperationOccured();
        }
    }
}

