/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework;

import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.widgets.Composite;

public class WBooleanItemProperty
extends WItemProperty {
    public WBooleanItemProperty(Composite parent, int style, ItemPropertyDescription<?> widgetDescriptor, IPropertyEditor editor) {
        super(parent, style, widgetDescriptor, editor);
    }

    public WBooleanItemProperty(Composite parent, int style, WidgetPropertyDescriptor descriptor, ItemPropertyDescription<?> widgetDescriptor, IPropertyEditor editor) {
        super(parent, style, descriptor, widgetDescriptor, editor);
    }

    @Override
    public boolean isExpressionMode() {
        if (this.isCustomSimpleMode()) {
            return false;
        }
        return this.getPropertyEditor().getPropertyValueExpression(this.getPropertyName()) != null;
    }

    @Override
    public String getStaticValue() {
        if (this.isCustomSimpleMode()) {
            JRExpression expressionValue = this.getExpressionValue();
            if (expressionValue != null && "false".equals(expressionValue.getText())) {
                return "false";
            }
            if (expressionValue != null && "true".equals(expressionValue.getText())) {
                return "true";
            }
        }
        return super.getStaticValue();
    }

    private boolean isCustomSimpleMode() {
        String customSimpleMode = this.getPropertyEditor().getPropertyValue(String.valueOf(this.getPropertyName()) + "_customSimpleMode");
        return "true".equals(customSimpleMode);
    }

    @Override
    public void setValue(String staticValue, JRExpression expressionValue) {
        this.setRefresh(true);
        try {
            if (staticValue != null) {
                String simpleMode = String.valueOf(this.getPropertyName()) + "_customSimpleMode";
                this.getPropertyEditor().createUpdateProperty(simpleMode, "true", null);
                expressionValue = new JRDesignExpression(staticValue);
                staticValue = null;
            } else {
                this.getPropertyEditor().removeProperty(String.valueOf(this.getPropertyName()) + "_customSimpleMode");
            }
            this.getPropertyEditor().createUpdateProperty(this.getPropertyName(), staticValue, expressionValue);
            this.updateWidget();
            this.fireModifyEvent(staticValue, expressionValue);
        }
        finally {
            this.setRefresh(false);
        }
    }
}

