/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework;

import com.jaspersoft.studio.utils.Colors;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.widgets.Composite;

public class WColorsItemProperty
extends WItemProperty {
    public WColorsItemProperty(Composite parent, int style, ItemPropertyDescription<?> widgetDescriptor, IPropertyEditor editor) {
        super(parent, style, widgetDescriptor, editor);
    }

    public WColorsItemProperty(Composite parent, int style, WidgetPropertyDescriptor descriptor, ItemPropertyDescription<?> widgetDescriptor, IPropertyEditor editor) {
        super(parent, style, descriptor, widgetDescriptor, editor);
    }

    @Override
    public boolean isExpressionMode() {
        if (this.isCustomSimpleMode()) {
            return false;
        }
        return this.getPropertyEditor().getPropertyValueExpression(this.getPropertyName()) != null;
    }

    @Override
    public String getStaticValue() {
        if (this.isCustomSimpleMode()) {
            JRExpression expressionValue = this.getExpressionValue();
            if (expressionValue != null) {
                String[] colors = Colors.decodeHexColorsArray(expressionValue.getText());
                return Colors.encodeHexColorsAsArray(colors);
            }
            return "";
        }
        return super.getStaticValue();
    }

    public void setCustomSimpleModeUsage() {
        String simpleMode = String.valueOf(this.getPropertyName()) + "_customSimpleMode";
        this.getPropertyEditor().createUpdateProperty(simpleMode, "true", null);
    }

    public void removeCustomSimpleModeUsage() {
        this.getPropertyEditor().removeProperty(String.valueOf(this.getPropertyName()) + "_customSimpleMode");
    }

    public boolean isCustomSimpleMode() {
        String customSimpleMode = this.getPropertyEditor().getPropertyValue(String.valueOf(this.getPropertyName()) + "_customSimpleMode");
        return "true".equals(customSimpleMode);
    }

    @Override
    public void setValue(String staticValue, JRExpression expressionValue) {
        this.setRefresh(true);
        try {
            if (staticValue != null) {
                this.setCustomSimpleModeUsage();
                String[] colors = Colors.decodeHexColorsArray(staticValue);
                StringBuffer colorsSB = new StringBuffer("Arrays.asList(");
                int i = 0;
                while (i < colors.length) {
                    colorsSB.append("\"");
                    colorsSB.append(colors[i]);
                    colorsSB.append("\"");
                    if (i != colors.length - 1) {
                        colorsSB.append(",");
                    }
                    ++i;
                }
                colorsSB.append(")");
                staticValue = null;
                expressionValue = new JRDesignExpression(colorsSB.toString());
            } else {
                this.removeCustomSimpleModeUsage();
            }
            this.getPropertyEditor().createUpdateProperty(this.getPropertyName(), staticValue, expressionValue);
            this.updateWidget();
            this.fireModifyEvent(staticValue, expressionValue);
        }
        finally {
            this.setRefresh(false);
        }
    }
}

