/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.manager;

import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.ItemPropertyLayoutData;
import com.jaspersoft.studio.widgets.framework.manager.LazyExpressionLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ItemPropertyLayout
extends Layout {
    private Label titleLabel;
    private LazyExpressionLabel expressionLabel;
    private Control mainControl;
    private Button dialogButton;
    private WItemProperty wItemProperty;
    public int bottomMargin = 3;
    public int horizontalSpacing = 5;

    public ItemPropertyLayout(WItemProperty wItemProperty, Label titleLabel, LazyExpressionLabel expressionLabel, Control mainControl, Button dialogButton) {
        this.wItemProperty = wItemProperty;
        this.mainControl = mainControl;
        this.expressionLabel = expressionLabel;
        this.dialogButton = dialogButton;
        this.titleLabel = titleLabel;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (!this.wItemProperty.isVisible()) {
            return new Point(0, 0);
        }
        boolean isExpressionMode = this.wItemProperty.isExpressionMode();
        ItemPropertyLayoutData data = this.wItemProperty.getContentLayoutData();
        int leftMargin = data.leftMargin;
        Point labelSize = data.labelSize;
        Point buttonSize = this.getButtonSize(hHint, data, isExpressionMode);
        int width = leftMargin;
        int height = Math.max(labelSize.y, buttonSize.y);
        if (this.titleLabel != null) {
            width += this.titleLabel.computeSize((int)wHint, (int)height).x + this.horizontalSpacing;
        }
        if (isExpressionMode) {
            width += labelSize.x + this.horizontalSpacing;
        }
        width += buttonSize.x + this.horizontalSpacing;
        boolean isControlFillingVertical = isExpressionMode ? data.expressionFillVertical : data.widgetFillVertical;
        int heightHint = 0;
        heightHint = isControlFillingVertical ? hHint : (isExpressionMode ? data.expressionHeightHint : data.widgetHeightHint);
        Point controlSize = this.mainControl.computeSize(wHint, heightHint, flushCache);
        height = Math.max(controlSize.y, height);
        return new Point(width += controlSize.x, height + this.bottomMargin);
    }

    protected Point getButtonSize(int availableheight, ItemPropertyLayoutData data, boolean isExpressionMode) {
        boolean isVisible;
        boolean bl = isVisible = isExpressionMode ? data.buttonVisibleExpressionMode : data.buttonVisibleSimpleMode;
        if (isVisible) {
            if (data.buttonSize.y <= availableheight || availableheight == -1) {
                return data.buttonSize;
            }
            return new Point(data.buttonSize.x, availableheight);
        }
        return new Point(0, 0);
    }

    protected int getButtonStart(int availableheight, ItemPropertyLayoutData data, boolean isExpressionMode) {
        boolean isVisible;
        boolean bl = isVisible = isExpressionMode ? data.buttonVisibleExpressionMode : data.buttonVisibleSimpleMode;
        if (isVisible) {
            if (data.buttonAlignment == 0x1000008) {
                return availableheight - this.getButtonSize((int)availableheight, (ItemPropertyLayoutData)data, (boolean)isExpressionMode).y;
            }
            if (data.buttonAlignment == 0x1000000) {
                int buttonHeight = this.getButtonSize((int)availableheight, (ItemPropertyLayoutData)data, (boolean)isExpressionMode).y;
                return Math.round((float)(availableheight - buttonHeight) / 2.0f);
            }
        }
        return 0;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (!this.wItemProperty.isVisible()) {
            if (this.titleLabel != null) {
                this.titleLabel.setBounds(0, 0, 0, 0);
            }
            if (this.expressionLabel.isInitialized()) {
                this.expressionLabel.setBounds(0, 0, 0, 0);
            }
            this.mainControl.setBounds(0, 0, 0, 0);
            this.dialogButton.setBounds(0, 0, 0, 0);
        } else {
            Rectangle compositeSize = composite.getClientArea();
            compositeSize.height -= this.bottomMargin;
            boolean isExpressionMode = this.wItemProperty.isExpressionMode();
            ItemPropertyLayoutData data = this.wItemProperty.getContentLayoutData();
            Point labelSize = data.labelSize;
            Point buttonSize = this.getButtonSize(compositeSize.height, data, isExpressionMode);
            boolean isControlFillingVertical = false;
            isControlFillingVertical = isExpressionMode ? data.expressionFillVertical : data.widgetFillVertical;
            int heightHint = 0;
            heightHint = isControlFillingVertical ? compositeSize.height : (isExpressionMode ? data.expressionHeightHint : data.widgetHeightHint);
            int availableWidth = compositeSize.width - data.leftMargin;
            int startEditorX = data.leftMargin;
            if (this.titleLabel != null) {
                Point titleSize = this.titleLabel.computeSize(-1, heightHint, flushCache);
                titleSize.x = Math.min(titleSize.x, availableWidth / 2);
                int titleStartY = Math.abs(compositeSize.height / 2 - titleSize.y / 2);
                this.titleLabel.setBounds(new Rectangle(startEditorX, titleStartY, titleSize.x, titleSize.y));
                startEditorX += titleSize.x + this.horizontalSpacing;
                availableWidth -= titleSize.x + this.horizontalSpacing;
            }
            if (isExpressionMode) {
                this.expressionLabel.setVisible(true);
                this.expressionLabel.setBounds(new Rectangle(startEditorX, 0, labelSize.x, labelSize.y));
                availableWidth -= labelSize.x + this.horizontalSpacing;
                startEditorX += labelSize.x + this.horizontalSpacing;
            } else if (this.expressionLabel.isInitialized()) {
                this.expressionLabel.setVisible(false);
                this.expressionLabel.setBounds(new Rectangle(0, 0, 0, 0));
            }
            int buttonStart = this.getButtonStart(compositeSize.height, data, isExpressionMode);
            this.dialogButton.setBounds(new Rectangle(compositeSize.width - buttonSize.x, buttonStart, buttonSize.x, buttonSize.y));
            this.dialogButton.setVisible(isExpressionMode ? data.buttonVisibleExpressionMode : data.buttonVisibleSimpleMode);
            Point controlSize = this.mainControl.computeSize(availableWidth -= buttonSize.x + this.horizontalSpacing, heightHint, flushCache);
            if (controlSize.y > compositeSize.height) {
                controlSize.y = compositeSize.height;
            }
            if (controlSize.y < buttonSize.y) {
                int startY = Math.round((float)(buttonSize.y - controlSize.y) / 2.0f);
                this.mainControl.setBounds(startEditorX, startY, availableWidth, controlSize.y);
            } else {
                this.mainControl.setBounds(startEditorX, 0, availableWidth, controlSize.y);
            }
        }
    }
}

