/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.manager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class LazyExpressionLabel {
    private Label label = null;
    private Composite parent;
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private String toolTipText = null;
    private Image image = null;

    public LazyExpressionLabel(Composite parent) {
        this.parent = parent;
    }

    protected void initializeLabel() {
        if (this.label == null) {
            this.label = new Label(this.parent, 0);
            for (MouseListener listener : this.mouseListeners) {
                this.label.addMouseListener(listener);
            }
            this.label.setToolTipText(this.toolTipText);
            this.label.setImage(this.image);
        }
    }

    public void setVisible(boolean visible) {
        this.initializeLabel();
        this.label.setVisible(visible);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.initializeLabel();
        this.label.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.initializeLabel();
        this.label.setBounds(rect);
    }

    public void addMouseListener(MouseListener listener) {
        if (!this.mouseListeners.contains(listener)) {
            this.mouseListeners.add(listener);
            if (this.label != null) {
                this.label.addMouseListener(listener);
            }
        }
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
        if (this.label != null) {
            this.label.setToolTipText(text);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.label != null) {
            this.label.setImage(image);
        }
    }

    public boolean isInitialized() {
        return this.label != null;
    }
}

