/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.manager;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.manager.IWidgetsDescriptorResolver;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import java.io.Closeable;
import java.io.InputStream;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.eclipse.core.resources.IFile;

public class StandardJSONWidgetsDescriptorResolver
implements IWidgetsDescriptorResolver {
    private Class<?> classToResolve;

    public StandardJSONWidgetsDescriptorResolver(Class<?> classToResolve) {
        this.classToResolve = classToResolve;
    }

    @Override
    public WidgetsDescriptor loadDescriptor(JasperReportsConfiguration jConfig, String URL2) {
        WidgetsDescriptor result;
        block7: {
            ObjectMapper mapper = new ObjectMapper();
            InputStream in = null;
            result = null;
            try {
                try {
                    IFile file = (IFile)jConfig.get("ifile");
                    if (file != null) {
                        String parentPath = file.getParent().getLocation().toFile().getAbsolutePath();
                        SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)parentPath);
                        SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)jConfig, (RepositoryResourceContext)context);
                        in = RepositoryUtil.getInstance((RepositoryContext)repoContext).getInputStreamFromLocation(URL2);
                    } else {
                        in = RepositoryUtil.getInstance((JasperReportsContext)jConfig).getInputStreamFromLocation(URL2);
                    }
                    mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
                    result = (WidgetsDescriptor)mapper.readValue(in, this.classToResolve);
                }
                catch (Exception e) {
                    JaspersoftStudioPlugin.getInstance().logError(e);
                    FileUtils.closeStream(in);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(in);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)in);
        }
        return result;
    }

    @Override
    public String getKey(JasperReportsConfiguration jConfig, String URL2) {
        IFile project = (IFile)jConfig.get("ifile");
        String projectPath = project.getLocation().toPortableString();
        String key = String.valueOf(projectPath) + URL2;
        return key;
    }

    @Override
    public boolean unloadOnConfigurationDispose() {
        return true;
    }
}

