/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.manager;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.model.SectionPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ArrayPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.BigDecimalPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.BooleanComboPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.CheckboxItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ClassItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ColorPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.DoublePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FilePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FixedMeasurePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FixedNumberMesurePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FloatPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FontFamilyComboPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FontStylePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.IntegerPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.LocaleComboPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.LongPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.MeasureUnitPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.MultiCheckBoxPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.MultiLineTextPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.NotNullableTextPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.PasswordTextPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.SelectableComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TextPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TimezoneComboPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TransparentColorPropertyDescription;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.SWTResourceManager;

public class WidgetFactory {
    private static Map<String, ItemPropertyDescription<?>> contributedWidgets = null;
    private static Map<String, ItemPropertyDescription<?>> hardcodedWidgets = null;

    protected static Map<String, ItemPropertyDescription<?>> getContributedWidgets() {
        if (contributedWidgets == null) {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio", "dynamicWidgetDefinitions");
            contributedWidgets = new HashMap();
            ArrayList<IConfigurationElement> configList = new ArrayList<IConfigurationElement>(Arrays.asList(config));
            for (IConfigurationElement el : configList) {
                try {
                    String widgetName = el.getAttribute("widgetName").toLowerCase();
                    Object defaultSupportClazz = el.createExecutableExtension("widgetClass");
                    if (!(defaultSupportClazz instanceof ItemPropertyDescription)) continue;
                    ItemPropertyDescription widgetClass = (ItemPropertyDescription)defaultSupportClazz;
                    contributedWidgets.put(widgetName, widgetClass);
                }
                catch (CoreException e) {
                    JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.jaspersoft.studio", "An error occurred while trying to create the new class.", (Throwable)e));
                }
            }
        }
        return contributedWidgets;
    }

    protected static Map<String, ItemPropertyDescription<?>> getHardcodedWidgets() {
        if (hardcodedWidgets == null) {
            hardcodedWidgets = new HashMap();
            hardcodedWidgets.put("path", new FilePropertyDescription());
            hardcodedWidgets.put("combo", new ComboItemPropertyDescription());
            hardcodedWidgets.put("color", new ColorPropertyDescription());
            hardcodedWidgets.put("transparent_color", new TransparentColorPropertyDescription());
            hardcodedWidgets.put("float", new FloatPropertyDescription());
            hardcodedWidgets.put("integer", new IntegerPropertyDescription());
            hardcodedWidgets.put("double", new DoublePropertyDescription());
            hardcodedWidgets.put("number", new DoublePropertyDescription());
            hardcodedWidgets.put("long", new LongPropertyDescription());
            hardcodedWidgets.put("bigdecimal", new BigDecimalPropertyDescription());
            hardcodedWidgets.put("text", new TextPropertyDescription());
            hardcodedWidgets.put("multiline_text", new MultiLineTextPropertyDescription());
            hardcodedWidgets.put("not_nullable_text", new NotNullableTextPropertyDescription());
            hardcodedWidgets.put("selectable_combo", new SelectableComboItemPropertyDescription());
            hardcodedWidgets.put("class_combo", new ClassItemPropertyDescription());
            hardcodedWidgets.put("fontfamily_combo", new FontFamilyComboPropertyDescription());
            hardcodedWidgets.put("fontstyle_selector", new FontStylePropertyDescription());
            hardcodedWidgets.put("checkbox_selector", new CheckboxItemPropertyDescription());
            hardcodedWidgets.put("checkbox_multi", new MultiCheckBoxPropertyDescription());
            hardcodedWidgets.put("measureunit", new MeasureUnitPropertyDescription());
            hardcodedWidgets.put("fixedmeasureunit", new FixedMeasurePropertyDescription());
            hardcodedWidgets.put("fixednumbermeasureunit", new FixedNumberMesurePropertyDescription());
            hardcodedWidgets.put("timezone_combo", new TimezoneComboPropertyDescription());
            hardcodedWidgets.put("locale_combo", new LocaleComboPropertyDescription());
            hardcodedWidgets.put("password_text", new PasswordTextPropertyDescription());
            hardcodedWidgets.put("boolean", new BooleanComboPropertyDescription());
        }
        return hardcodedWidgets;
    }

    protected static String getValidTypes() {
        StringBuilder result = new StringBuilder();
        for (String hardcodedType : WidgetFactory.getHardcodedWidgets().keySet()) {
            result.append(hardcodedType);
            result.append(", ");
        }
        for (String contributedType : WidgetFactory.getContributedWidgets().keySet()) {
            result.append(contributedType);
            result.append(", ");
        }
        return result.substring(0, result.length() - 2);
    }

    public static ItemPropertyDescription<?> createItemPropertyDescriptor(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        String type = cpd.getType().toLowerCase().trim();
        return WidgetFactory.createItemPropertyDescriptor(cd, cpd, jConfig, type);
    }

    protected static ItemPropertyDescription<?> createItemPropertyDescriptor(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig, String type) {
        ItemPropertyDescription<?> hardcodedType = WidgetFactory.getHardcodedWidgets().get(type);
        ItemPropertyDescription<?> desc = null;
        if (hardcodedType != null) {
            desc = hardcodedType.getInstance(cd, cpd, jConfig);
        } else {
            ItemPropertyDescription<?> contribuitedType = WidgetFactory.getContributedWidgets().get(type);
            if (contribuitedType == null) {
                if (type.startsWith("[") && type.endsWith("]")) {
                    desc = new ArrayPropertyDescription().getInstance(cd, cpd, jConfig);
                    String newType = type.substring(1, type.length() - 1);
                    ((ArrayPropertyDescription)desc).setInnterType(WidgetFactory.createItemPropertyDescriptor(cd, cpd, jConfig, newType));
                } else {
                    String errorString = "Invalid widget type {0}, valid types are: {1}";
                    String errorMessage = MessageFormat.format(errorString, type, WidgetFactory.getValidTypes());
                    JaspersoftStudioPlugin.getInstance().logError(errorMessage, new Exception(errorMessage));
                }
            } else {
                desc = contribuitedType.getInstance(cd, cpd, jConfig);
            }
        }
        return desc;
    }

    public static Label createLabelForProperty(Composite parent, WidgetPropertyDescriptor pDescriptor) {
        Label lbl = new Label(parent, 0);
        lbl.setText(pDescriptor.getLabel());
        lbl.setToolTipText(pDescriptor.getDescription());
        return lbl;
    }

    public static Label createLabelForProperty(Composite parent, WidgetPropertyDescriptor pDescriptor, WidgetsDescriptor descriptor) {
        Label lbl = new Label(parent, 0);
        lbl.setText(descriptor.getLocalizedString(pDescriptor.getLabel()));
        lbl.setToolTipText(descriptor.getLocalizedString(pDescriptor.getDescription()));
        return lbl;
    }

    public static Composite createSection(Composite parent, WidgetsDescriptor widgetsDesc, SectionPropertyDescriptor sectionDesc, int columns) {
        int style = 64;
        if (sectionDesc.isExpandable()) {
            style |= 4;
        }
        Section section = new Section(parent, style);
        section.titleBarTextMarginWidth = 0;
        section.setFont(SWTResourceManager.getBoldFont((Font)section.getFont()));
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
            section.setLayoutData((Object)gd);
        }
        section.setText(widgetsDesc.getLocalizedString(Misc.nvl((String)sectionDesc.getName())));
        section.setSeparatorControl((Control)new Label((Composite)section, 258));
        Composite cmp = new Composite((Composite)section, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginHeight = 4;
        layout.marginWidth = 2;
        cmp.setLayout((Layout)layout);
        section.setClient((Control)cmp);
        return cmp;
    }

    public static GridLayout getNoPadLayout(int colNumber) {
        GridLayout result = new GridLayout(colNumber, false);
        result.verticalSpacing = 0;
        result.marginWidth = 0;
        result.marginHeight = 0;
        return result;
    }
}

