/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.menu.IMenuProvider;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public abstract class AbstractExpressionPropertyDescription<T>
implements ItemPropertyDescription<T> {
    protected String name;
    protected String label;
    protected String description;
    protected boolean mandatory;
    protected T defaultValue;
    protected T fallbackValue;
    protected boolean readOnly;
    protected JasperReportsConfiguration jConfig;

    public AbstractExpressionPropertyDescription() {
    }

    public AbstractExpressionPropertyDescription(String name, String description, boolean mandatory) {
        this(name, name, description, mandatory, null);
    }

    public AbstractExpressionPropertyDescription(String name, String label, String description, boolean mandatory) {
        this(name, label, description, mandatory, null);
    }

    public AbstractExpressionPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue) {
        this.name = name;
        this.label = label;
        this.description = description;
        this.mandatory = mandatory;
        this.defaultValue = defaultValue;
    }

    public void setjConfig(JasperReportsConfiguration jConfig) {
        this.jConfig = jConfig;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValue != null ? this.defaultValue.toString() : "";
    }

    @Override
    public String getFallbackValueString() {
        return this.fallbackValue != null ? this.fallbackValue.toString() : "";
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public T getFallbackValue() {
        return this.fallbackValue;
    }

    public void setFallbackValue(T fallbackValue) {
        this.fallbackValue = fallbackValue;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (wiProp.isExpressionMode() && txt instanceof Text) {
            String tvalue = ((Text)txt).getText();
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wiProp.setValue(null, (JRExpression)new JRDesignExpression(Misc.nvl((String)tvalue)));
        }
    }

    protected void lazyCreateExpressionControl(IWItemProperty wiProp, DoubleControlComposite cmp) {
        if (wiProp.isExpressionMode() && cmp.getFirstContainer().getChildren().length == 0) {
            Control expressionControl = this.createExpressionControl(wiProp, cmp.getFirstContainer());
            cmp.getFirstContainer().setData((Object)expressionControl);
            cmp.setExpressionControlToHighlight(expressionControl);
        }
    }

    protected Control createExpressionControl(final IWItemProperty wiProp, Composite parent) {
        Text textExpression = new Text(parent, 2112);
        GridData textData = new GridData(4, 4, true, true);
        textData.widthHint = 150;
        textExpression.setLayoutData((Object)textData);
        textExpression.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UIUtil.isMacAndEclipse4()) {
                    if (((Text)e.getSource()).isDisposed()) {
                        return;
                    }
                    wiProp.updateWidget();
                }
            }
        });
        textExpression.addModifyListener(e -> {
            if (wiProp.isRefresh()) {
                return;
            }
            Point p = ((Text)e.getSource()).getSelection();
            this.handleEdit((Control)((Text)e.getSource()), wiProp);
            ((Text)e.getSource()).setSelection(p);
        });
        if (this.isReadOnly()) {
            textExpression.setEnabled(false);
        }
        textExpression.setBackground(SWTResourceManager.getColor((int)24));
        textExpression.setBackground(SWTResourceManager.getColor((int)25));
        return textExpression;
    }

    @Override
    public Control createControl(IWItemProperty wiProp, Composite parent) {
        return this.createExpressionControl(wiProp, parent);
    }

    protected void setupContextMenu(Control c, IWItemProperty wiProp) {
        IMenuProvider provider = wiProp.getContextualMenuProvider();
        if (provider != null) {
            provider.setupMenu(wiProp, this, c);
        }
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        if (c instanceof Text) {
            Text txtExpr = (Text)c;
            if (wip.isExpressionMode()) {
                JRExpression expression = wip.getExpressionValue();
                String txt = Misc.nvl((String)(expression != null ? expression.getText() : null));
                Point oldSelection = txtExpr.getSelection();
                txtExpr.setText(txt);
                oldSelection.x = Math.min(txt.length(), oldSelection.x);
                oldSelection.y = Math.min(txt.length(), oldSelection.y);
                txtExpr.setSelection(oldSelection);
                String tooltip = "";
                if (!Misc.isNullOrEmpty((String)txt)) {
                    tooltip = String.valueOf(tooltip) + "\n\n" + txt;
                }
                tooltip = String.valueOf(tooltip) + this.getToolTip(wip, txt);
                txtExpr.setToolTipText(tooltip.trim());
            }
        }
    }

    protected void changeFallbackForeground(boolean isUsingFallback, Control control) {
        Color dcolor = UIUtils.INHERITED_COLOR;
        Color ecolor = SWTResourceManager.getColor((int)21);
        Color fg = control.getForeground();
        if (isUsingFallback && !ModelUtils.safeEquals(fg, dcolor)) {
            control.setForeground(dcolor);
        } else if (!isUsingFallback && !ModelUtils.safeEquals(fg.getRGB(), ecolor.getRGB())) {
            control.setForeground(null);
        }
    }

    public String getToolTip(IWItemProperty wip, String value) {
        String tooltip = "";
        String wipTt = wip.getToolTip();
        if (wipTt != null) {
            tooltip = wipTt;
        } else {
            if (!Misc.isNullOrEmpty((String)value)) {
                tooltip = String.valueOf(tooltip) + "\n\n" + value;
            }
            tooltip = String.valueOf(tooltip) + "\n" + this.getToolTip();
        }
        return tooltip.trim();
    }

    @Override
    public String getToolTip() {
        String tt = String.valueOf(this.getName()) + "\n\n";
        tt = String.valueOf(tt) + Misc.nvl((String)this.getDescription());
        tt = String.valueOf(tt) + "\n\n" + (this.isMandatory() ? "Mandatory" : "Optional");
        if (!Misc.isNullOrEmpty((String)this.getDefaultValueString())) {
            tt = String.valueOf(tt) + "\n\nDefault: " + this.getDefaultValueString();
        }
        if (!Misc.isNullOrEmpty((String)this.getFallbackValueString())) {
            tt = String.valueOf(tt) + "\n\nFallback: " + this.getFallbackValueString();
        }
        return tt;
    }

    @Override
    public abstract ItemPropertyDescription<T> clone();
}

