/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.widgets.NumericText;
import com.jaspersoft.studio.utils.ValidatedDecimalFormat;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.NumberPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.widget.FallbackNumericText;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BigDecimalPropertyDescription
extends NumberPropertyDescription<BigDecimal> {
    public BigDecimalPropertyDescription() {
    }

    public BigDecimalPropertyDescription(String name, String label, String description, boolean mandatory, BigDecimal defaultValue, BigDecimal min, BigDecimal max) {
        super(name, label, description, mandatory, defaultValue, min, max);
    }

    public BigDecimalPropertyDescription(String name, String label, String description, boolean mandatory, BigDecimal min, BigDecimal max) {
        super(name, label, description, mandatory, min, max);
    }

    @Override
    public Class<? extends Number> getType() {
        if (this.defaultValue != null) {
            return ((BigDecimal)this.defaultValue).getClass();
        }
        return BigDecimal.class;
    }

    @Override
    public BigDecimalPropertyDescription clone() {
        BigDecimalPropertyDescription result = new BigDecimalPropertyDescription();
        result.defaultValue = (BigDecimal)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.min = (BigDecimal)this.min;
        result.max = (BigDecimal)this.max;
        result.fallbackValue = (BigDecimal)this.fallbackValue;
        return result;
    }

    public BigDecimalPropertyDescription getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        BigDecimal min = null;
        BigDecimal max = null;
        BigDecimal def = null;
        BigDecimal fallBack = null;
        if (cpd.getMin() != null) {
            min = new BigDecimal(cpd.getMin());
        }
        if (cpd.getMax() != null) {
            max = new BigDecimal(cpd.getMax());
        }
        if (cpd.getDefaultValue() != null && !cpd.getDefaultValue().isEmpty()) {
            def = new BigDecimal(cpd.getDefaultValue());
        }
        if (cpd.getFallbackValue() != null && !cpd.getFallbackValue().isEmpty()) {
            fallBack = new BigDecimal(cpd.getFallbackValue());
        }
        BigDecimalPropertyDescription intDesc = new BigDecimalPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), def, min, max);
        intDesc.setReadOnly(cpd.isReadOnly());
        intDesc.setFallbackValue(fallBack);
        return intDesc;
    }

    @Override
    protected FallbackNumericText createSimpleEditor(Composite parent) {
        FallbackNumericText text = new FallbackNumericText(parent, 2048, 0, 20);
        text.setRemoveTrailZeroes(true);
        BigDecimal max = (BigDecimal)this.getMax();
        BigDecimal min = (BigDecimal)this.getMin();
        text.setMaximum(max != null ? Double.valueOf(max.doubleValue()) : null);
        text.setMinimum(min != null ? Double.valueOf(min.doubleValue()) : null);
        return text;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (txt instanceof NumericText) {
            String tvalue;
            NumericText widget = (NumericText)txt;
            BigDecimal bigValue = widget.getValueAsBigDecimal();
            String string = tvalue = bigValue != null ? bigValue.toString() : null;
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wiProp.setValue(tvalue, null);
            widget.setToolTipText(this.getToolTip(wiProp, ((NumericText)txt).getText()));
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    @Override
    protected BigDecimal convertValue(String v) throws NumberFormatException {
        if (v == null || v.isEmpty()) {
            return null;
        }
        try {
            BigDecimal parsedBigDecimal = new BigDecimal(v);
            return parsedBigDecimal;
        }
        catch (Exception exception) {
            throw new NumberFormatException();
        }
    }

    @Override
    public String getToolTip() {
        String tt = Misc.nvl((String)this.getDescription());
        tt = String.valueOf(tt) + "\n" + (this.isMandatory() ? "Mandatory" : "Optional");
        DecimalFormat formatter = new DecimalFormat("0.#######", ValidatedDecimalFormat.SYMBOLS);
        if (!Misc.isNullOrEmpty((String)this.getDefaultValueString())) {
            tt = String.valueOf(tt) + "\nDefault: " + formatter.format(this.getDefaultValue());
        }
        if (this.getMin() != null || this.getMax() != null) {
            if (this.getMin() != null) {
                tt = String.valueOf(tt) + "\nmin: " + formatter.format(this.getMin());
            }
            if (this.getMax() != null) {
                tt = String.valueOf(tt) + "\nmax: " + formatter.format(this.getMax());
            }
        }
        return tt;
    }
}

