/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.property.descriptor.classname.ClassTypeCellEditor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ClassItemPropertyDescription
extends ComboItemPropertyDescription<String> {
    public ClassItemPropertyDescription() {
    }

    public ClassItemPropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue, String[] values) {
        super(name, label, description, mandatory, defaultValue, values);
    }

    public ClassItemPropertyDescription(String name, String label, String description, boolean mandatory, String[] values) {
        super(name, label, description, mandatory, values);
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wProp) {
        if (txt instanceof Combo) {
            wProp.setValue(((Combo)txt).getText(), null);
        } else {
            super.handleEdit(txt, wProp);
        }
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        cmp.getSecondContainer().setLayout((Layout)WidgetFactory.getNoPadLayout(2));
        final Combo simpleControl = this.createComboControl(cmp.getSecondContainer());
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData comboData = new GridData(768);
        comboData.verticalAlignment = 0x1000000;
        comboData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)comboData);
        simpleControl.setItems(ClassItemPropertyDescription.convert2Value(this.keyValues));
        simpleControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                Point p = simpleControl.getSelection();
                ClassItemPropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
                simpleControl.setSelection(p);
            }
        });
        final Button classDialogButton = new Button(cmp.getSecondContainer(), 8);
        classDialogButton.setText("...");
        classDialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String classname = ClassTypeCellEditor.getJavaClassDialog(classDialogButton.getShell(), null);
                if (classname != null) {
                    simpleControl.setText(classname);
                }
            }
        });
        classDialogButton.setLayoutData((Object)new GridData(1040));
        if (this.isReadOnly()) {
            simpleControl.setEnabled(false);
            classDialogButton.setEnabled(false);
        } else {
            this.setupContextMenu((Control)simpleControl, wiProp);
        }
        cmp.switchToSecondContainer();
        return cmp;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        if (cpd.getComboOptions() != null) {
            String[][] opts = cpd.getComboOptions();
            String[] classes = new String[opts.length];
            int i = 0;
            while (i < opts.length) {
                classes[i] = opts[i][0];
                ++i;
            }
            ClassItemPropertyDescription result = new ClassItemPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), classes);
            result.setReadOnly(cpd.isReadOnly());
            result.setFallbackValue(cpd.getFallbackValue());
            return result;
        }
        return null;
    }
}

