/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.widgets.CustomReadOnlyCombo;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class ComboItemPropertyDescription<T>
extends AbstractExpressionPropertyDescription<T> {
    protected static MouseAdapter macComboMenuOpener = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            Menu menu;
            if (e.button == 3 && ((Control)e.widget).getMenu() != null && (menu = ((Control)e.widget).getMenu()) != null && !menu.isDisposed() && !menu.isVisible()) {
                Point location = e.widget.getDisplay().getCursorLocation();
                menu.setLocation(location.x, location.y);
                menu.setVisible(true);
            }
        }
    };
    protected String[][] keyValues;

    public ComboItemPropertyDescription() {
    }

    public ComboItemPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue, String[] values) {
        super(name, label, description, mandatory, defaultValue);
        this.keyValues = ComboItemPropertyDescription.convert2KeyValue(values);
    }

    public ComboItemPropertyDescription(String name, String label, String description, boolean mandatory, String[] values) {
        super(name, label, description, mandatory);
        this.keyValues = ComboItemPropertyDescription.convert2KeyValue(values);
    }

    public ComboItemPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue, String[][] keyValues) {
        super(name, label, description, mandatory, defaultValue);
        this.keyValues = keyValues;
    }

    public String[][] getKeyValues() {
        return this.keyValues;
    }

    public static String[][] convert2KeyValue(String[] values) {
        String[][] kv = new String[values.length][2];
        int i = 0;
        while (i < values.length) {
            kv[i][0] = values[i];
            kv[i][1] = values[i];
            ++i;
        }
        return kv;
    }

    public static String getKeyFromValue(String[][] keyValues, String key) {
        String keyFound = null;
        int i = 0;
        while (i < keyValues.length) {
            if (key.equals(keyValues[i][1])) {
                return keyValues[i][0];
            }
            ++i;
        }
        return keyFound;
    }

    public static String getValueFromKey(String[][] keyValues, String value) {
        String valueFound = null;
        int i = 0;
        while (i < keyValues.length) {
            if (value.equals(keyValues[i][0])) {
                return keyValues[i][1];
            }
            ++i;
        }
        return valueFound;
    }

    public static String[] convert2Value(String[][] keyValues) {
        String[] v = new String[keyValues.length];
        int i = 0;
        while (i < keyValues.length) {
            v[i] = keyValues[i][1];
            ++i;
        }
        return v;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wProp) {
        super.handleEdit(txt, wProp);
        if (txt instanceof Combo) {
            Combo combo = (Combo)txt;
            int indx = combo.getSelectionIndex();
            String text = combo.getText();
            if (indx == -1 && text != null && !text.trim().isEmpty()) {
                wProp.setValue(text, null);
            } else {
                String tvalue;
                String string = tvalue = indx >= 0 && indx < this.keyValues.length ? this.keyValues[indx][0] : null;
                if (tvalue != null && tvalue.isEmpty()) {
                    tvalue = null;
                }
                wProp.setValue(tvalue, null);
            }
        }
    }

    protected Combo createComboControl(Composite parent, int customStyle) {
        CustomReadOnlyCombo result = new CustomReadOnlyCombo(parent, customStyle);
        boolean handleComboListener = Util.isMac();
        if (handleComboListener) {
            result.addMouseListener((MouseListener)macComboMenuOpener);
        }
        return result;
    }

    protected Combo createComboControl(Composite parent) {
        return this.createComboControl(parent, 0);
    }

    @Override
    public Control createControl(IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        Combo simpleControl = this.createComboControl(cmp.getSecondContainer());
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData comboData = new GridData(768);
        comboData.verticalAlignment = 0x1000000;
        comboData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)comboData);
        simpleControl.setItems(ComboItemPropertyDescription.convert2Value(this.keyValues));
        simpleControl.addModifyListener(e -> {
            if (wiProp.isRefresh()) {
                return;
            }
            Point p = simpleControl.getSelection();
            this.handleEdit((Control)simpleControl, wiProp);
            simpleControl.setSelection(p);
        });
        if (this.isReadOnly()) {
            simpleControl.setEnabled(false);
        } else {
            this.setupContextMenu((Control)simpleControl, wiProp);
        }
        cmp.switchToSecondContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        boolean isFallback = false;
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text txt = (Text)cmp.getFirstContainer().getData();
            super.update((Control)txt, wip);
            cmp.switchToFirstContainer();
            txt.setToolTipText(this.getToolTip(wip, txt.getText()));
        } else {
            Combo combo = (Combo)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            String textualValue = Misc.nvl((String)v);
            String[][] stringArray = this.keyValues;
            int n = this.keyValues.length;
            int n2 = 0;
            while (n2 < n) {
                String[] keyValuePairs = stringArray[n2];
                String key = keyValuePairs[0];
                String value = keyValuePairs[1];
                if (ModelUtils.safeEquals(key, v)) {
                    textualValue = value;
                    break;
                }
                ++n2;
            }
            combo.setText(textualValue);
            combo.setToolTipText(this.getToolTip(wip, combo.getText()));
            this.changeFallbackForeground(isFallback, (Control)combo);
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public ItemPropertyDescription<T> clone() {
        ComboItemPropertyDescription<T> result = new ComboItemPropertyDescription<T>();
        result.defaultValue = this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.keyValues = this.keyValues;
        result.fallbackValue = this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        if (cpd.getComboOptions() != null) {
            String[][] opts = cpd.getComboOptions();
            String[][] i18nOpts = new String[opts.length][2];
            int i = 0;
            while (i < opts.length) {
                i18nOpts[i][0] = opts[i][0];
                i18nOpts[i][1] = cd.getLocalizedString(opts[i][1]);
                ++i;
            }
            ComboItemPropertyDescription<String> result = new ComboItemPropertyDescription<String>(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), i18nOpts);
            result.setReadOnly(cpd.isReadOnly());
            result.setFallbackValue(cpd.getFallbackValue());
            return result;
        }
        return null;
    }
}

