/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.widgets.NumericText;
import com.jaspersoft.studio.utils.ValidatedDecimalFormat;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.NumberPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.widget.FallbackNumericText;
import java.text.DecimalFormat;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DoublePropertyDescription
extends NumberPropertyDescription<Double> {
    public DoublePropertyDescription() {
    }

    public DoublePropertyDescription(String name, String label, String description, boolean mandatory, Double defaultValue, double min, double max) {
        super(name, label, description, mandatory, defaultValue, min, max);
    }

    public DoublePropertyDescription(String name, String label, String description, boolean mandatory, double min, double max) {
        super(name, label, description, mandatory, min, max);
    }

    @Override
    public Class<? extends Number> getType() {
        if (this.defaultValue != null) {
            return ((Double)this.defaultValue).getClass();
        }
        return Double.class;
    }

    @Override
    public DoublePropertyDescription clone() {
        DoublePropertyDescription result = new DoublePropertyDescription();
        result.defaultValue = (Double)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.min = (Double)this.min;
        result.max = (Double)this.max;
        result.fallbackValue = (Double)this.fallbackValue;
        return result;
    }

    public DoublePropertyDescription getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        Double min = null;
        Double max = null;
        Double def = null;
        Double fallBack = null;
        min = cpd.getMin() != null ? new Double(cpd.getMin()) : Double.valueOf(-1.7976931348623157E308);
        max = cpd.getMax() != null ? new Double(cpd.getMax()) : Double.valueOf(Double.MAX_VALUE);
        if (cpd.getDefaultValue() != null && !cpd.getDefaultValue().isEmpty()) {
            def = new Double(cpd.getDefaultValue());
        }
        if (cpd.getFallbackValue() != null && !cpd.getFallbackValue().isEmpty()) {
            fallBack = new Double(cpd.getFallbackValue());
        }
        DoublePropertyDescription doubleDesc = new DoublePropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), def, min, max);
        doubleDesc.setReadOnly(cpd.isReadOnly());
        doubleDesc.setFallbackValue(fallBack);
        return doubleDesc;
    }

    @Override
    protected FallbackNumericText createSimpleEditor(Composite parent) {
        FallbackNumericText text = new FallbackNumericText(parent, 2048, 6, 10);
        text.setRemoveTrailZeroes(true);
        Double max = this.getMax() != null ? (Double)this.getMax() : Double.MAX_VALUE;
        Double min = this.getMin() != null ? (Double)this.getMin() : Double.MIN_VALUE;
        text.setMaximum((double)max);
        text.setMinimum((double)min);
        return text;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (txt instanceof NumericText) {
            String tvalue;
            NumericText widget = (NumericText)txt;
            Double floatValue = widget.getValueAsDouble();
            String string = tvalue = floatValue != null ? floatValue.toString() : null;
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            if (tvalue != null && widget.getText() != null) {
                int decimalPosition = tvalue.indexOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR);
                if (decimalPosition != -1) {
                    int unconvertedDecimal = widget.getText().indexOf(ValidatedDecimalFormat.DECIMAL_SEPARATOR);
                    if (unconvertedDecimal == -1) {
                        tvalue = tvalue.substring(0, decimalPosition);
                    }
                } else if (widget.getText().endsWith("0")) {
                    tvalue = widget.getText();
                }
            }
            wiProp.setValue(tvalue, null);
            widget.setToolTipText(this.getToolTip(wiProp, widget.getText()));
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    @Override
    protected Number convertValue(String v) throws NumberFormatException {
        if (v == null || v.isEmpty()) {
            return null;
        }
        char separator = ValidatedDecimalFormat.DECIMAL_SEPARATOR;
        if (separator != '.') {
            v = v.replace(separator, '.');
        }
        return Double.valueOf(v);
    }

    @Override
    public String getToolTip() {
        String tt = Misc.nvl((String)this.getDescription());
        tt = String.valueOf(tt) + "\n" + (this.isMandatory() ? "Mandatory" : "Optional");
        DecimalFormat formatter = new DecimalFormat("0.#######", ValidatedDecimalFormat.SYMBOLS);
        if (!Misc.isNullOrEmpty((String)this.getDefaultValueString())) {
            tt = String.valueOf(tt) + "\nDefault: " + formatter.format(this.getDefaultValue());
        }
        if (this.getMin() != null || this.getMax() != null) {
            if (this.getMin() != null && (Double)this.getMin() != -1.7976931348623157E308) {
                tt = String.valueOf(tt) + "\nmin: " + formatter.format(this.getMin());
            }
            if (this.getMax() != null && (Double)this.getMax() != Double.MAX_VALUE) {
                tt = String.valueOf(tt) + "\nmax: " + formatter.format(this.getMax());
            }
        }
        return tt;
    }
}

