/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.jface.dialogs.FileSelectionDialog;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FilePropertyDescription
extends AbstractExpressionPropertyDescription<String> {
    public FilePropertyDescription() {
    }

    public FilePropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue) {
        super(name, label, description, mandatory, defaultValue);
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        cmp.getSecondContainer().setLayout((Layout)WidgetFactory.getNoPadLayout(2));
        final Text simpleControl = new Text(cmp.getSecondContainer(), 2048);
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        GridData textData = new GridData(768);
        textData.verticalAlignment = 0x1000000;
        textData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)textData);
        simpleControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                FilePropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
            }
        });
        simpleControl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UIUtil.isMacAndEclipse4()) {
                    if (((Text)e.getSource()).isDisposed()) {
                        return;
                    }
                    wiProp.updateWidget();
                }
            }
        });
        this.createToolbarButton(cmp.getSecondContainer(), wiProp);
        if (this.isReadOnly()) {
            simpleControl.setEnabled(false);
        }
        this.setupContextMenu((Control)simpleControl, wiProp);
        cmp.switchToFirstContainer();
        return cmp;
    }

    @Override
    protected void lazyCreateExpressionControl(IWItemProperty wiProp, DoubleControlComposite cmp) {
        if (wiProp.isExpressionMode() && cmp.getFirstContainer().getChildren().length == 0) {
            cmp.getFirstContainer().setLayout((Layout)WidgetFactory.getNoPadLayout(2));
            Control expressionControl = this.createExpressionControl(wiProp, cmp.getFirstContainer());
            cmp.getFirstContainer().setData((Object)expressionControl);
            cmp.setExpressionControlToHighlight(expressionControl);
            this.createToolbarButton(cmp.getFirstContainer(), wiProp);
            this.setupContextMenu(expressionControl, wiProp);
        }
    }

    protected void createToolbarButton(Composite parent, final IWItemProperty wiProp) {
        ToolBar toolBar = new ToolBar(parent, 0);
        ToolItem b = new ToolItem(toolBar, 0x800000);
        b.setImage(this.getButtonImage());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                wiProp.setRefresh(true);
                JRDesignExpression exp = null;
                try {
                    exp = FilePropertyDescription.this.openSelectionDialog();
                }
                finally {
                    if (exp != null) {
                        wiProp.setValue(null, (JRExpression)exp);
                    }
                    wiProp.setRefresh(false);
                }
            }
        });
        GridData data = new GridData();
        data.verticalAlignment = 128;
        toolBar.setLayoutData((Object)data);
        if (this.isReadOnly()) {
            toolBar.setEnabled(false);
        }
    }

    protected Image getButtonImage() {
        return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/fldr_obj.gif");
    }

    protected JRDesignExpression openSelectionDialog() {
        FileSelectionDialog fsd = new FileSelectionDialog(UIUtils.getShell());
        fsd.configureDialog(this.jConfig);
        if (fsd.open() == 0) {
            JRDesignExpression exp = fsd.getFileExpression();
            return exp;
        }
        return null;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (!wiProp.isExpressionMode() && txt instanceof Text) {
            String tvalue = ((Text)txt).getText();
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wiProp.setValue(tvalue, null);
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text expressionControl = (Text)cmp.getFirstContainer().getData();
            super.update((Control)expressionControl, wip);
            cmp.switchToFirstContainer();
            expressionControl.setToolTipText(this.getToolTip(wip, expressionControl.getText()));
        } else {
            String txt;
            Text txtValue = (Text)cmp.getSecondContainer().getData();
            boolean isFallback = false;
            if (wip.getStaticValue() != null) {
                txt = wip.getStaticValue();
            } else if (wip.getFallbackValue() != null) {
                txt = Misc.nvl((String)wip.getFallbackValue().toString());
                isFallback = true;
            } else {
                txt = "";
            }
            Point oldSelection = txtValue.getSelection();
            txtValue.setText(txt);
            this.changeFallbackForeground(isFallback, (Control)txtValue);
            oldSelection.x = Math.min(txt.length(), oldSelection.x);
            oldSelection.y = Math.min(txt.length(), oldSelection.y);
            txtValue.setSelection(oldSelection);
            txtValue.setToolTipText(this.getToolTip(wip, txtValue.getText()));
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public ItemPropertyDescription<String> clone() {
        FilePropertyDescription result = new FilePropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        FilePropertyDescription fileDesc = new FilePropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue());
        fileDesc.setjConfig(jConfig);
        fileDesc.setReadOnly(cpd.isReadOnly());
        fileDesc.setFallbackValue(cpd.getFallbackValue());
        return fileDesc;
    }
}

