/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FontStylePropertyDescription
extends AbstractExpressionPropertyDescription<String> {
    public FontStylePropertyDescription() {
    }

    public FontStylePropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue) {
        super(name, label, description, mandatory, defaultValue);
    }

    @Override
    public Control createControl(IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        Composite toolbarsContainer = new Composite(cmp.getSecondContainer(), 0);
        GridLayout containerLayout = new GridLayout(4, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.verticalSpacing = 0;
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        toolbarsContainer.setLayout((Layout)containerLayout);
        ArrayList<Pair> toolItems = new ArrayList<Pair>();
        ToolBar boldToolbar = new ToolBar(toolbarsContainer, 0x804040);
        ToolItem boldButton = this.createItem(boldToolbar, wiProp, "isBold", "icons/resources/edit-bold.png");
        toolItems.add(new Pair((Object)boldButton, (Object)"isBold"));
        ToolBar italicToolbar = new ToolBar(toolbarsContainer, 0x804040);
        ToolItem italicButton = this.createItem(italicToolbar, wiProp, "isItalic", "icons/resources/edit-italic.png");
        toolItems.add(new Pair((Object)italicButton, (Object)"isItalic"));
        ToolBar underlineToolbar = new ToolBar(toolbarsContainer, 0x804040);
        ToolItem underlineButton = this.createItem(underlineToolbar, wiProp, "isUnderline", "icons/resources/edit-underline.png");
        toolItems.add(new Pair((Object)underlineButton, (Object)"isUnderline"));
        ToolBar strikeTroughtToolbar = new ToolBar(toolbarsContainer, 0x804040);
        ToolItem strikeTroughtButton = this.createItem(strikeTroughtToolbar, wiProp, "isStrikeThrough", "icons/resources/edit-strike.png");
        toolItems.add(new Pair((Object)strikeTroughtButton, (Object)"isStrikeThrough"));
        cmp.getSecondContainer().setData(toolItems);
        cmp.setSimpleControlToHighlight((Control)toolbarsContainer);
        cmp.switchToSecondContainer();
        return cmp;
    }

    private ToolItem createItem(ToolBar toolBar, final IWItemProperty wiProp, final String propertyName, String image) {
        ToolItem item = new ToolItem(toolBar, 32);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem item = (ToolItem)e.widget;
                wiProp.getPropertyEditor().createUpdateProperty(propertyName, String.valueOf(item.getSelection()), null);
            }
        });
        item.setImage(JaspersoftStudioPlugin.getInstance().getImage(image));
        this.setupContextMenu((Control)toolBar, wiProp);
        return item;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text txt = (Text)cmp.getFirstContainer().getData();
            super.update((Control)txt, wip);
            cmp.switchToFirstContainer();
            txt.setToolTipText(this.getToolTip(wip, txt.getText()));
        } else {
            List toolItems = (List)cmp.getSecondContainer().getData();
            IPropertyEditor editor = wip.getPropertyEditor();
            for (Pair toolItem : toolItems) {
                String value = editor.getPropertyValue((String)toolItem.getValue());
                if (value == null) continue;
                boolean selected = Boolean.parseBoolean(value);
                ((ToolItem)toolItem.getKey()).setSelection(selected);
            }
        }
    }

    @Override
    public ItemPropertyDescription<String> clone() {
        FontStylePropertyDescription result = new FontStylePropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        FontStylePropertyDescription fileDesc = new FontStylePropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue());
        fileDesc.setReadOnly(cpd.isReadOnly());
        fileDesc.setFallbackValue(cpd.getFallbackValue());
        return fileDesc;
    }
}

