/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.PreferencesDataAdapterStorage;
import com.jaspersoft.studio.model.dataset.SelectDefaultDatasetWizard;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboItemSeparator;
import com.jaspersoft.studio.property.combomenu.WritableComboMenuViewer;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.WritableComboButton;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JRDataAdapterPropertyDescription
extends AbstractExpressionPropertyDescription<String> {
    private ADataAdapterStorage[] daStorage = new ADataAdapterStorage[0];

    public JRDataAdapterPropertyDescription() {
    }

    public JRDataAdapterPropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue, JasperReportsConfiguration jConfig) {
        super(name, label, description, mandatory, defaultValue);
        this.jConfig = jConfig;
        IFile file = (IFile)jConfig.get("ifile");
        this.daStorage = DataAdapterManager.getDataAdapter(file, jConfig);
    }

    public JRDataAdapterPropertyDescription(String name, String label, String description, boolean mandatory, JasperReportsConfiguration jConfig) {
        super(name, label, description, mandatory);
        this.jConfig = jConfig;
        IFile file = (IFile)jConfig.get("ifile");
        this.daStorage = DataAdapterManager.getDataAdapter(file, jConfig);
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(768));
        this.lazyCreateExpressionControl(wiProp, cmp);
        Composite simpleContainer = new Composite(cmp.getSecondContainer(), 0);
        GridLayout simpleLayout = new GridLayout(2, false);
        simpleLayout.verticalSpacing = 0;
        simpleLayout.marginHeight = 0;
        simpleLayout.marginWidth = 0;
        simpleContainer.setLayout((Layout)simpleLayout);
        simpleContainer.setLayoutData((Object)new GridData(768));
        final WritableComboMenuViewer viewer = new WritableComboMenuViewer(simpleContainer, 2);
        Button browseButton = new Button(simpleContainer, 8);
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentPropertyValue = wiProp.getPropertyEditor().getPropertyValue(wiProp.getPropertyName());
                IFile file = (IFile)JRDataAdapterPropertyDescription.this.jConfig.get("ifile");
                SelectDefaultDatasetWizard defaultDAwizard = new SelectDefaultDatasetWizard(currentPropertyValue, file);
                WizardDialog defaultDAdialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)defaultDAwizard);
                if (defaultDAdialog.open() == 0) {
                    if (wiProp.isRefresh()) {
                        return;
                    }
                    wiProp.setValue(defaultDAwizard.getValue(), null);
                }
            }
        });
        WritableComboButton simpleControl = viewer.getControl();
        cmp.getSecondContainer().setData((Object)viewer);
        cmp.setSimpleControlToHighlight((Control)simpleContainer);
        GridData comboData = new GridData(768);
        comboData.verticalAlignment = 0x1000000;
        comboData.grabExcessVerticalSpace = true;
        simpleControl.setLayoutData((Object)comboData);
        JRDesignDataset currentDataset = this.jConfig.getJasperDesign().getMainDesignDataset();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (currentDataset != null) {
            int i = 0;
            while (i < this.daStorage.length) {
                ADataAdapterStorage s = this.daStorage[i];
                if (!(s instanceof PreferencesDataAdapterStorage)) {
                    for (DataAdapterDescriptor d : s.getDataAdapterDescriptors(currentDataset)) {
                        Pair value = new Pair((Object)d, (Object)s);
                        ComboItem m1 = new ComboItem(s.getLabel(d), true, d.getIcon(16), i, d, value);
                        items.add(m1);
                    }
                }
                if (!s.getDataAdapterDescriptors(currentDataset).isEmpty() && i < this.daStorage.length - 1 && !this.daStorage[i + 1].getDataAdapterDescriptors(currentDataset).isEmpty()) {
                    items.add(new ComboItemSeparator(i));
                }
                ++i;
            }
        }
        viewer.addSelectionListener(new ComboItemAction(){

            @Override
            public void exec() {
                if (wiProp.isRefresh()) {
                    return;
                }
                ComboItem selectedElement = viewer.getSelectedItem();
                if (selectedElement.getValue() instanceof Pair) {
                    Pair value = (Pair)selectedElement.getValue();
                    String daURL = ((ADataAdapterStorage)value.getValue()).getUrl((DataAdapterDescriptor)value.getKey());
                    if (daURL != null) {
                        wiProp.setValue(daURL, null);
                    }
                } else {
                    String tValue = viewer.getText();
                    wiProp.setValue(tValue, null);
                }
            }
        });
        viewer.setItems(items);
        if (this.isReadOnly()) {
            simpleControl.setEnabled(false);
            browseButton.setEnabled(false);
        } else {
            this.setupContextMenu((Control)simpleControl, wiProp);
        }
        cmp.switchToSecondContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        boolean isFallback = false;
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text txt = (Text)cmp.getFirstContainer().getData();
            super.update((Control)txt, wip);
            cmp.switchToFirstContainer();
            txt.setToolTipText(this.getToolTip(wip, txt.getText()));
        } else {
            WritableComboMenuViewer combo = (WritableComboMenuViewer)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            combo.setText(Misc.nvl((String)v));
            combo.setToolTipText(this.getToolTip(wip, v));
            this.changeFallbackForeground(isFallback, (Control)combo.getControl());
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public ItemPropertyDescription<String> clone() {
        JRDataAdapterPropertyDescription result = new JRDataAdapterPropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        JRDataAdapterPropertyDescription result = new JRDataAdapterPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), jConfig);
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(cpd.getFallbackValue());
        return result;
    }
}

