/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.SelectableComboItemPropertyDescription;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class LocaleComboPropertyDescription
extends SelectableComboItemPropertyDescription<String> {
    private static String[][] locs = null;

    public LocaleComboPropertyDescription() {
    }

    public LocaleComboPropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue) {
        super(name, label, description, mandatory, defaultValue, LocaleComboPropertyDescription.getLocales());
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            super.update(c, wip);
        } else {
            boolean isFallback = false;
            Combo localeCombo = (Combo)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v != null) {
                localeCombo.setText(LocaleComboPropertyDescription.getValueFromKey(locs, v));
            } else if (wip.getFallbackValue() != null) {
                localeCombo.setText(String.valueOf(wip.getFallbackValue()));
                isFallback = true;
            } else {
                localeCombo.removeAll();
                localeCombo.setItems(LocaleComboPropertyDescription.convert2Value(locs));
            }
            this.changeFallbackForeground(isFallback, (Control)localeCombo);
            cmp.switchToSecondContainer();
            localeCombo.setToolTipText(this.getToolTip(wip, localeCombo.getText()));
        }
    }

    @Override
    public LocaleComboPropertyDescription clone() {
        LocaleComboPropertyDescription result = new LocaleComboPropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.keyValues = this.keyValues;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    protected static String[][] getLocales() {
        if (locs == null) {
            Object[] locales = Locale.getAvailableLocales();
            LocaleComboPropertyDescription.sortLocalesOnToString((Locale[])locales);
            locales = (Locale[])ArrayUtils.removeElement((Object[])locales, (Object)Locale.ROOT);
            locs = new String[locales.length][2];
            int i = 0;
            while (i < locs.length) {
                LocaleComboPropertyDescription.locs[i][0] = ((Locale)locales[i]).toString();
                LocaleComboPropertyDescription.locs[i][1] = ((Locale)locales[i]).getDisplayName();
                ++i;
            }
        }
        return locs;
    }

    protected static void sortLocalesOnToString(Locale[] locales) {
        Comparator<Locale> localeComparator = new Comparator<Locale>(){

            @Override
            public int compare(Locale locale1, Locale locale2) {
                return locale1.getDisplayName().compareTo(locale2.getDisplayName());
            }
        };
        Arrays.sort(locales, localeComparator);
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        LocaleComboPropertyDescription result = new LocaleComboPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), (String)this.defaultValue);
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue((String)this.fallbackValue);
        return result;
    }
}

