/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.swt.widgets.CustomReadOnlyCombo;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectableComboItemPropertyDescription<T>
extends ComboItemPropertyDescription<T> {
    public SelectableComboItemPropertyDescription() {
    }

    public SelectableComboItemPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue, String[] values) {
        super(name, label, description, mandatory, defaultValue, values);
    }

    public SelectableComboItemPropertyDescription(String name, String label, String description, boolean mandatory, String[] values) {
        super(name, label, description, mandatory, values);
    }

    public SelectableComboItemPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue, String[][] keyValues) {
        super(name, label, description, mandatory, defaultValue, keyValues);
    }

    @Override
    protected Combo createComboControl(Composite parent) {
        CustomReadOnlyCombo result = (CustomReadOnlyCombo)super.createComboControl(parent, 8);
        result.setReadOnly(true);
        return result;
    }

    @Override
    public ItemPropertyDescription<T> clone() {
        SelectableComboItemPropertyDescription<T> result = new SelectableComboItemPropertyDescription<T>();
        result.defaultValue = this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.keyValues = this.keyValues;
        result.fallbackValue = this.fallbackValue;
        return result;
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wProp) {
        if (txt instanceof Combo) {
            String tvalue;
            int indx = ((Combo)txt).getSelectionIndex();
            String string = tvalue = indx >= 0 && indx < this.keyValues.length ? this.keyValues[indx][0] : null;
            if (tvalue != null && tvalue.isEmpty()) {
                tvalue = null;
            }
            wProp.setValue(tvalue, null);
        } else {
            super.handleEdit(txt, wProp);
        }
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            super.update(c, wip);
        } else {
            boolean isFallback = false;
            CustomReadOnlyCombo combo = (CustomReadOnlyCombo)((Object)cmp.getSecondContainer().getData());
            String v = wip.getStaticValue();
            if (v == null && wip.getFallbackValue() != null) {
                v = wip.getFallbackValue().toString();
                isFallback = true;
            }
            boolean found = false;
            int i = 0;
            while (i < this.keyValues.length) {
                if (this.keyValues[i][0].equals(v)) {
                    combo.select(i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                combo.setText(v);
                if (!this.isMandatory() && v == null) {
                    found = true;
                }
            }
            combo.setError(!found);
            combo.setToolTipText(this.getToolTip(wip, v));
            this.changeFallbackForeground(isFallback, (Control)combo);
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        if (cpd.getComboOptions() != null) {
            String[][] opts = cpd.getComboOptions();
            String[][] i18nOpts = new String[opts.length][2];
            int i = 0;
            while (i < opts.length) {
                i18nOpts[i][0] = opts[i][0];
                i18nOpts[i][1] = cd.getLocalizedString(opts[i][1]);
                ++i;
            }
            SelectableComboItemPropertyDescription<String> result = new SelectableComboItemPropertyDescription<String>(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue(), i18nOpts);
            result.setReadOnly(cpd.isReadOnly());
            result.setFallbackValue(cpd.getFallbackValue());
            return result;
        }
        return null;
    }
}

