/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextPropertyDescription<T>
extends AbstractExpressionPropertyDescription<T> {
    public TextPropertyDescription() {
    }

    public TextPropertyDescription(String name, String description, boolean mandatory) {
        this(name, name, description, mandatory, null);
    }

    public TextPropertyDescription(String name, String label, String description, boolean mandatory) {
        this(name, label, description, mandatory, null);
    }

    public TextPropertyDescription(String name, String label, String description, boolean mandatory, T defaultValue) {
        super(name, label, description, mandatory, defaultValue);
    }

    @Override
    public void handleEdit(Control txt, IWItemProperty wiProp) {
        if (wiProp == null) {
            return;
        }
        if (!wiProp.isExpressionMode() && txt instanceof Text) {
            String tvalue = ((Text)txt).getText();
            wiProp.setValue(this.parseText(tvalue), null);
        } else {
            super.handleEdit(txt, wiProp);
        }
    }

    protected String parseText(String widgetText) {
        if (widgetText != null && widgetText.isEmpty()) {
            return null;
        }
        return widgetText;
    }

    protected int getTextControlStyle() {
        return 2048;
    }

    protected GridData getTextControlGridData() {
        GridData textData = new GridData(768);
        textData.verticalAlignment = 0x1000000;
        return textData;
    }

    @Override
    public Control createControl(final IWItemProperty wiProp, Composite parent) {
        DoubleControlComposite cmp = new DoubleControlComposite(parent, 0);
        cmp.setLayoutData(new GridData(4, 4, true, false));
        this.lazyCreateExpressionControl(wiProp, cmp);
        final Text simpleControl = new Text(cmp.getSecondContainer(), this.getTextControlStyle());
        cmp.getSecondContainer().setData((Object)simpleControl);
        cmp.setSimpleControlToHighlight((Control)simpleControl);
        simpleControl.setLayoutData((Object)this.getTextControlGridData());
        simpleControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                TextPropertyDescription.this.handleEdit((Control)simpleControl, wiProp);
            }
        });
        simpleControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if ((e.stateMask & SWT.MODIFIER_MASK) == 262144 && e.keyCode == 9 && (simpleControl.getStyle() & 2) == 0) {
                    e.doit = false;
                    String currentText = simpleControl.getText();
                    Point selection = simpleControl.getSelection();
                    String newText = String.valueOf(currentText.substring(0, selection.x)) + '\t';
                    int newSelection = newText.length();
                    if (selection.y < currentText.length()) {
                        newText = String.valueOf(newText) + currentText.substring(selection.y, currentText.length());
                    }
                    simpleControl.setText(newText);
                    simpleControl.setSelection(newSelection);
                }
            }
        });
        simpleControl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UIUtil.isMacAndEclipse4()) {
                    if (((Text)e.getSource()).isDisposed()) {
                        return;
                    }
                    wiProp.updateWidget(false);
                }
            }
        });
        if (this.isReadOnly()) {
            simpleControl.setEnabled(false);
        } else {
            this.setupContextMenu((Control)simpleControl, wiProp);
        }
        cmp.switchToFirstContainer();
        return cmp;
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            this.lazyCreateExpressionControl(wip, cmp);
            Text expressionControl = (Text)cmp.getFirstContainer().getData();
            super.update((Control)expressionControl, wip);
            cmp.switchToFirstContainer();
        } else {
            String txt;
            Text txtValue = (Text)cmp.getSecondContainer().getData();
            boolean isFallback = false;
            String sv = wip.getStaticValue();
            if (sv != null) {
                txt = sv;
            } else if (wip.getFallbackValue() != null) {
                txt = Misc.nvl((String)wip.getFallbackValue().toString());
                isFallback = true;
            } else {
                txt = "";
            }
            Point oldSelection = txtValue.getSelection();
            txtValue.setText(txt);
            this.changeFallbackForeground(isFallback, (Control)txtValue);
            oldSelection.x = Math.min(txt.length(), oldSelection.x);
            oldSelection.y = Math.min(txt.length(), oldSelection.y);
            txtValue.setSelection(oldSelection);
            txtValue.setToolTipText(this.getToolTip(wip, txt));
            cmp.switchToSecondContainer();
        }
    }

    @Override
    public ItemPropertyDescription<T> clone() {
        TextPropertyDescription<T> result = new TextPropertyDescription<T>();
        result.defaultValue = this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.fallbackValue = this.fallbackValue;
        return result;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        TextPropertyDescription<String> result = new TextPropertyDescription<String>(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue());
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue(cpd.getFallbackValue());
        return result;
    }
}

