/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.SelectableComboItemPropertyDescription;
import java.util.Arrays;
import java.util.TimeZone;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class TimezoneComboPropertyDescription
extends SelectableComboItemPropertyDescription<String> {
    private static String[][] tzs = null;

    public TimezoneComboPropertyDescription() {
    }

    public TimezoneComboPropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue) {
        super(name, label, description, mandatory, defaultValue, TimezoneComboPropertyDescription.getTimeZones());
    }

    @Override
    public void update(Control c, IWItemProperty wip) {
        DoubleControlComposite cmp = (DoubleControlComposite)wip.getControl();
        if (wip.isExpressionMode()) {
            super.update(c, wip);
        } else {
            boolean isFallback = false;
            Combo timezoneCombo = (Combo)cmp.getSecondContainer().getData();
            String v = wip.getStaticValue();
            if (v != null) {
                timezoneCombo.setText(v);
            } else if (wip.getFallbackValue() != null) {
                timezoneCombo.setText(String.valueOf(wip.getFallbackValue()));
                isFallback = true;
            } else {
                timezoneCombo.removeAll();
                timezoneCombo.setItems(TimezoneComboPropertyDescription.convert2Value(tzs));
            }
            this.changeFallbackForeground(isFallback, (Control)timezoneCombo);
            cmp.switchToSecondContainer();
            timezoneCombo.setToolTipText(this.getToolTip(wip, timezoneCombo.getText()));
        }
    }

    @Override
    public TimezoneComboPropertyDescription clone() {
        TimezoneComboPropertyDescription result = new TimezoneComboPropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.keyValues = this.keyValues;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    protected static String[][] getTimeZones() {
        if (tzs == null) {
            Object[] tzones = TimeZone.getAvailableIDs();
            Arrays.sort(tzones);
            tzs = new String[tzones.length][2];
            int i = 0;
            while (i < tzs.length) {
                TimezoneComboPropertyDescription.tzs[i][0] = tzones[i];
                TimezoneComboPropertyDescription.tzs[i][1] = tzones[i];
                ++i;
            }
        }
        return tzs;
    }

    @Override
    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        TimezoneComboPropertyDescription result = new TimezoneComboPropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), (String)this.defaultValue);
        result.setReadOnly(cpd.isReadOnly());
        result.setFallbackValue((String)this.fallbackValue);
        return result;
    }
}

