/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.framework.ui.dialog;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.PropertyEditorAdapter;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.ItemPropertyLayoutData;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.util.HashMap;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationTitleAreaDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ItemPropertyElementDialog
extends PersistentLocationTitleAreaDialog {
    protected ItemPropertyDescription<?> ipDesc;
    private String staticValue;
    private JRExpression expressionValue;
    private WItemProperty itemProperty;
    protected ExpressionContext context;
    private boolean isExpressionMode = false;
    private boolean forceExpressionMode = false;
    protected HashMap<String, String> customPropertiesMap = new HashMap();
    private IPropertyEditor dialogPropertyEditor = new PropertyEditorAdapter(){

        @Override
        public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
            if (propertyName.equals(ItemPropertyElementDialog.this.itemProperty.getPropertyName())) {
                if (ItemPropertyElementDialog.this.isExpressionMode()) {
                    ItemPropertyElementDialog.this.expressionValue = valueExpression;
                } else {
                    ItemPropertyElementDialog.this.staticValue = value;
                }
            } else {
                ItemPropertyElementDialog.this.customPropertiesMap.put(propertyName, value);
            }
        }

        @Override
        public JRExpression getPropertyValueExpression(String propertyName) {
            return ItemPropertyElementDialog.this.getExpressionValue();
        }

        @Override
        public String getPropertyValue(String propertyName) {
            if (!propertyName.equals(ItemPropertyElementDialog.this.itemProperty.getPropertyName())) {
                return ItemPropertyElementDialog.this.customPropertiesMap.get(propertyName);
            }
            return ItemPropertyElementDialog.this.getStaticValue();
        }
    };

    public ItemPropertyElementDialog(Shell parentShell, ItemPropertyDescription<?> ipDesc, WItemProperty itemProperty) {
        super(parentShell);
        this.staticValue = itemProperty.getStaticValue();
        JRExpression expressionValue = itemProperty.getExpressionValue();
        this.expressionValue = expressionValue != null ? (JRExpression)expressionValue.clone() : null;
        this.context = itemProperty.getExpressionContext();
        this.ipDesc = ipDesc.clone();
        this.isExpressionMode = itemProperty.isExpressionMode();
        this.setSaveSettings(false);
    }

    public ItemPropertyElementDialog(Shell parentShell, ItemPropertyDescription<?> ipDesc, String staticValue, JRExpression expressionValue, ExpressionContext context) {
        super(parentShell);
        this.staticValue = staticValue;
        this.expressionValue = expressionValue != null ? (JRExpression)expressionValue.clone() : null;
        this.context = context;
        this.ipDesc = ipDesc.clone();
        this.isExpressionMode = expressionValue != null;
        this.setSaveSettings(false);
    }

    public void setForceExpressionMode(boolean value) {
        if (this.dialogArea == null) {
            this.forceExpressionMode = value;
        } else {
            JaspersoftStudioPlugin.getInstance().logWarning("The enforce expression method must be called before the dialog is opened");
        }
    }

    public boolean isExpressionMode() {
        return this.forceExpressionMode ? true : this.isExpressionMode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ItemPropertyElementDialog_shellTitle);
    }

    protected WItemProperty createProperty(Composite parent, ItemPropertyDescription<?> idDesc, IPropertyEditor editor) {
        return new WItemProperty(parent, 0, this.ipDesc, editor){

            @Override
            public boolean isExpressionMode() {
                return ItemPropertyElementDialog.this.isExpressionMode();
            }

            @Override
            protected void handleEditButton() {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue((JRDesignExpression)this.getExpressionValue());
                    wizard.setExpressionContext(this.getExpressionContext());
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(this.getShell(), wizard);
                    if (dialog.open() == 0) {
                        JRDesignExpression value = wizard.getValue();
                        this.setValue(null, (JRExpression)value);
                    }
                }
            }
        };
    }

    protected void createExpressionCheckbox(Composite dialogArea) {
        Button useExpressionCheckbox = new Button(dialogArea, 32);
        useExpressionCheckbox.setText(Messages.ItemPropertyElementDialog_2);
        useExpressionCheckbox.setLayoutData((Object)new GridData(4, 4, true, false));
        useExpressionCheckbox.setSelection(this.isExpressionMode());
        useExpressionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemPropertyElementDialog.this.isExpressionMode = ((Button)e.widget).getSelection();
                ItemPropertyElementDialog.this.itemProperty.updateWidget();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.bind((String)Messages.ItemPropertyElementDialog_0, (Object)(this.ipDesc.getName() != null ? this.ipDesc.getName() : "")));
        this.setMessage(this.ipDesc.getDescription());
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayoutData((Object)new GridData(1808));
        dialogArea.setLayout((Layout)new GridLayout(1, false));
        this.createMessageArea(dialogArea);
        if (!this.forceExpressionMode) {
            this.createExpressionCheckbox(dialogArea);
        }
        this.itemProperty = this.createProperty(dialogArea, this.ipDesc, this.dialogPropertyEditor);
        this.itemProperty.setLayoutData(new GridData(1808));
        ItemPropertyLayoutData contentLayout = new ItemPropertyLayoutData();
        contentLayout.expressionFillVertical = true;
        contentLayout.buttonVisibleSimpleMode = false;
        this.itemProperty.setContentLayoutData(contentLayout);
        this.itemProperty.setExpressionContext(this.context);
        Point controlSize = this.itemProperty.computeSize(450, -1);
        Point defaultSize = UIUtils.getScaledSize((Point)new Point(450, Math.max(controlSize.y + 250, 300)));
        this.setDefaultSize(defaultSize.x, defaultSize.y);
        this.itemProperty.updateWidget();
        return dialogArea;
    }

    protected void createMessageArea(Composite parent) {
    }

    public JRExpression getExpressionValue() {
        return this.expressionValue;
    }

    public String getStaticValue() {
        return this.staticValue;
    }

    public boolean close() {
        if (this.isExpressionMode()) {
            this.staticValue = null;
            if (this.expressionValue == null) {
                this.expressionValue = new JRDesignExpression();
            }
        } else {
            this.expressionValue = null;
        }
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }
}

