/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import com.jaspersoft.studio.wizards.JSSWizardPageChangeEvent;
import com.jaspersoft.studio.wizards.JSSWizardPageChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;

public abstract class JSSWizard
extends Wizard
implements JSSWizardPageChangeListener {
    public static final String JASPERREPORTS_CONFIGURATION = "jasperreports_configuration";
    public static final String FILE_PATH = "file_path";
    public static final String FILE_NAME = "file_name";
    private IWizard parentWizard;
    protected IWizardPage fallbackPage;
    private List<IWizard> childWizards = new ArrayList<IWizard>();
    private Map<String, Object> settings = new HashMap<String, Object>();
    private List<Command> commands;
    private boolean disposeConfig = true;
    private List<IWizardPage> wizardPages = new ArrayList<IWizardPage>();

    public JSSWizard() {
        this.setForcePreviousAndNextButtons(true);
    }

    public JSSWizard(IWizard parentWizard, IWizardPage fallbackPage) {
        this();
        this.parentWizard = parentWizard;
        this.fallbackPage = fallbackPage;
    }

    public Map<String, Object> getSettings() {
        if (this.parentWizard != null && this.parentWizard instanceof JSSWizard) {
            return ((JSSWizard)this.parentWizard).getSettings();
        }
        return this.settings;
    }

    public void setSettings(Map<String, Object> map) {
        this.settings = map;
    }

    public IWizardPage hasNextPage(IWizardPage page) {
        IWizardPage wpage = this.getNextPage(page);
        if (wpage == null && this.parentWizard != null && this.fallbackPage != null) {
            return this.fallbackPage;
        }
        return wpage;
    }

    public IWizard getParentWizard() {
        return this.parentWizard;
    }

    protected void addChild(IWizard w) {
        if (!this.childWizards.contains(w)) {
            this.childWizards.add(w);
        }
    }

    protected List<IWizard> getChildWizards() {
        return this.childWizards;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = null;
        int index = this.wizardPages.indexOf(page);
        if (index >= 0 && index < this.wizardPages.size() - 1) {
            nextPage = this.wizardPages.get(index + 1);
        }
        if (nextPage == null && this.parentWizard != null && this.fallbackPage != null) {
            if (this.parentWizard instanceof JSSWizard) {
                ((JSSWizard)this.parentWizard).addChild((IWizard)this);
            }
            nextPage = this.fallbackPage;
        }
        return nextPage;
    }

    public boolean performFinish() {
        for (IWizard w : this.childWizards) {
            w.performFinish();
        }
        return true;
    }

    public void setConfig(JasperReportsConfiguration config, boolean disposeConfig) {
        this.disposeConfig = disposeConfig;
        if (config == null) {
            this.getSettings().remove(JASPERREPORTS_CONFIGURATION);
        } else {
            this.getSettings().put(JASPERREPORTS_CONFIGURATION, (Object)config);
        }
    }

    public JasperReportsConfiguration getConfig() {
        return (JasperReportsConfiguration)((Object)this.getSettings().get(JASPERREPORTS_CONFIGURATION));
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) {
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
    }

    public void removeCommand(Command command) {
        if (this.parentWizard != null && this.parentWizard instanceof JSSWizard) {
            ((JSSWizard)this.parentWizard).removeCommand(command);
        }
        if (this.commands != null) {
            this.commands.remove(command);
        }
    }

    public void addCommand(Command command) {
        if (this.parentWizard != null && this.parentWizard instanceof JSSWizard) {
            ((JSSWizard)this.parentWizard).addCommand(command);
        }
        if (this.commands == null) {
            this.commands = new ArrayList<Command>();
        }
        this.commands.add(command);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void addPage(IWizardPage page) {
        this.wizardPages.add(page);
        page.setWizard((IWizard)this);
        if (page instanceof JSSWizardPage) {
            ((JSSWizardPage)page).addChangeListener(this);
            IWizard wiz = this.getParentWizard();
            while (wiz != null && wiz instanceof JSSWizard) {
                JSSWizard parentw = (JSSWizard)wiz;
                ((JSSWizardPage)page).addChangeListener(parentw);
                wiz = parentw.getParentWizard();
            }
        }
    }

    public void addPage(int index, IWizardPage page) {
        this.wizardPages.add(index, page);
        page.setWizard((IWizard)this);
        if (page instanceof JSSWizardPage) {
            ((JSSWizardPage)page).addChangeListener(this);
        }
        if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public void removePage(IWizardPage page) {
        if (this.getContainer() != null && this.getContainer().getCurrentPage() == page) {
            return;
        }
        if (page instanceof JSSWizardPage) {
            ((JSSWizardPage)page).removeChangeListener(this);
        }
        this.wizardPages.remove(page);
        if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public void addPages() {
    }

    public boolean canFinish() {
        int i = 0;
        while (i < this.wizardPages.size()) {
            if (!this.wizardPages.get(i).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.wizardPages.size()) {
            IWizardPage page = this.wizardPages.get(i);
            page.createControl(pageContainer);
            Assert.isNotNull((Object)page.getControl());
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.wizardPages.size()) {
            try {
                this.wizardPages.get(i).dispose();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.jface", 4, e.getMessage(), (Throwable)e);
                Policy.getLog().log((IStatus)status);
            }
            ++i;
        }
        super.dispose();
        JasperReportsConfiguration jrConfig = this.getConfig();
        if (jrConfig != null && jrConfig != JasperReportsConfiguration.getDefaultInstance() && this.disposeConfig) {
            jrConfig.dispose();
        }
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.wizardPages.size()) {
            IWizardPage page = this.wizardPages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.wizardPages.size();
    }

    public IWizardPage[] getPages() {
        return this.wizardPages.toArray(new IWizardPage[this.wizardPages.size()]);
    }

    public List<IWizardPage> getPageList() {
        return this.wizardPages;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.wizardPages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return this.wizardPages.get(index - 1);
    }

    public IWizardPage getStartingPage() {
        if (this.wizardPages.size() == 0) {
            return null;
        }
        return this.wizardPages.get(0);
    }

    public boolean needsPreviousAndNextButtons() {
        return super.needsPreviousAndNextButtons() || this.wizardPages.size() > 1;
    }

    public void rearrangeSteps() {
        if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    @Override
    public void pageChanged(JSSWizardPageChangeEvent event) {
    }
}

