/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public abstract class JSSWizardHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String wizardId = this.getWizardIdParameterId();
        IWorkbenchWindow activeWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        if (wizardId == null) {
            IAction wizardAction = this.createWizardChooserDialogAction(activeWindow);
            wizardAction.run();
        } else {
            IWorkbenchWizard wizard;
            block6: {
                IWizardRegistry wizardRegistry = this.getWizardRegistry();
                IWizardDescriptor wizardDescriptor = wizardRegistry.findWizard(wizardId);
                if (wizardDescriptor == null) {
                    throw new ExecutionException("unknown wizard: " + wizardId);
                }
                try {
                    wizard = wizardDescriptor.createWizard();
                    ISelection selection = activeWindow.getSelectionService().getSelection();
                    StructuredSelection ss = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
                    wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)ss);
                    if (!wizardDescriptor.canFinishEarly() || wizardDescriptor.hasPages()) break block6;
                    wizard.performFinish();
                    return null;
                }
                catch (CoreException ex) {
                    throw new ExecutionException("error creating wizard", (Throwable)ex);
                }
            }
            Shell parent = activeWindow.getShell();
            this.createAndOpenWizardDialog(parent, (IWizard)wizard);
        }
        return null;
    }

    protected void createAndOpenWizardDialog(Shell parent, IWizard wizard) {
        WizardDialog dialog = new WizardDialog(parent, wizard);
        dialog.create();
        dialog.open();
    }

    protected abstract IAction createWizardChooserDialogAction(IWorkbenchWindow var1);

    protected abstract String getWizardIdParameterId();

    protected abstract IWizardRegistry getWizardRegistry();
}

