/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards;

import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class JSSWizardSelectionPage
extends JSSWizardPage {
    private IWizardNode selectedNode = null;
    private List<IWizardNode> selectedWizardNodes = new ArrayList<IWizardNode>();

    protected JSSWizardSelectionPage(String pageName) {
        super(pageName);
    }

    private void addSelectedNode(IWizardNode node) {
        if (node == null) {
            return;
        }
        if (this.selectedWizardNodes.contains(node)) {
            return;
        }
        this.selectedWizardNodes.add(node);
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.selectedNode != null) {
            return true;
        }
        return super.canFlipToNextPage();
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.selectedWizardNodes.size()) {
            this.selectedWizardNodes.get(i).dispose();
            ++i;
        }
    }

    public IWizardPage getNextPage() {
        if (this.selectedNode == null) {
            return super.getNextPage();
        }
        boolean isCreated = this.selectedNode.isContentCreated();
        IWizard wizard = this.selectedNode.getWizard();
        if (wizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (!isCreated) {
            wizard.addPages();
        }
        IWizardPage nextPage = wizard.getStartingPage();
        return nextPage;
    }

    public IWizardNode getSelectedNode() {
        return this.selectedNode;
    }

    protected void setSelectedNode(IWizardNode node) {
        this.addSelectedNode(node);
        this.selectedNode = node;
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }
}

