/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextData;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.templates.TemplateBundle;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewFileCreationWizardPage
extends WizardNewFileCreationPage
implements ContextData {
    protected IStructuredSelection currentSelection = null;
    private String baseName = "report.jrxml";

    public NewFileCreationWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.currentSelection = selection;
        this.setTitle(Messages.ReportNewWizard_0);
        this.setDescription(Messages.ReportNewWizardPage_description);
        this.setFileExtension("jrxml");
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(ContextHelpIDs.WIZARD_NEW_FILE);
    }

    @Override
    public void setHelpData() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), ContextHelpIDs.WIZARD_NEW_FILE);
    }

    protected void setControl(Control newControl) {
        super.setControl(newControl);
        newControl.addListener(28, new Listener(){

            public void handleEvent(Event event) {
                NewFileCreationWizardPage.this.performHelp();
            }
        });
        this.setHelpData();
    }

    public boolean validatePage() {
        boolean valid = super.validatePage();
        if (valid) {
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath());
            if (r == null || !r.exists() || (r.getType() & 1) != 0) {
                this.setMessage("The directory specified does not exist or is not a valid folder", 3);
                valid = false;
            }
            IContainer folder = (IContainer)r;
            try {
                String fileName = this.getFileName().toLowerCase().trim();
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    if (child.getName().toLowerCase().trim().equals(fileName)) {
                        this.setMessage("Filename in different case already used inside the folder", 3);
                        valid = false;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return valid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadSettings();
        }
        this.validatePage();
    }

    public void setBaseName(String newBaseName) {
        this.baseName = newBaseName;
    }

    public void loadSettings() {
        String filename;
        JSSWizard jssw;
        if (this.getWizard() != null && this.getWizard() instanceof JSSWizard && (jssw = (JSSWizard)this.getWizard()).getSettings() != null && jssw.getSettings().get("template") != null) {
            try {
                TemplateBundle tb = (TemplateBundle)jssw.getSettings().get("template");
                this.baseName = tb.getLabel();
                this.baseName = this.baseName.replace(File.separator, "_");
                this.baseName = this.baseName.replace(" ", "_");
            }
            catch (Exception exception) {}
        }
        if (!(filename = this.baseName).endsWith(".jrxml")) {
            filename = String.valueOf(filename) + ".jrxml";
        }
        if (this.currentSelection != null) {
            if (this.currentSelection instanceof TreeSelection) {
                TreeSelection s = (TreeSelection)this.currentSelection;
                if (s.getFirstElement() instanceof IFile) {
                    IFile file = (IFile)s.getFirstElement();
                    filename = this.getValidFileName(file.getProject(), file.getProjectRelativePath().removeLastSegments(1).toOSString(), this.baseName);
                } else if (s.getFirstElement() instanceof IProject) {
                    IProject prj = (IProject)s.getFirstElement();
                    filename = this.getValidFileName(prj, Messages.ReportNewWizard_11, this.baseName);
                }
            }
            this.setFileName(filename);
        }
    }

    private String getValidFileName(IProject prj, String prjPath, String basename) {
        if (!basename.endsWith(".jrxml")) {
            basename = basename.replaceAll(".jrxml$", "");
        }
        String filename = String.valueOf(basename) + ".jrxml";
        String pattern = String.valueOf(basename) + "_{0}" + ".jrxml";
        String f = String.valueOf(prjPath) + File.separator + filename;
        int i = 1;
        while (prj.getFile(f).exists()) {
            filename = MessageFormat.format(pattern, i);
            f = String.valueOf(prjPath) + File.separator + filename;
            ++i;
        }
        return filename;
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        this.storeSettings();
    }

    public void storeSettings() {
        if (this.getWizard() instanceof JSSWizard && this.getWizard() != null) {
            Map<String, Object> settings = ((JSSWizard)this.getWizard()).getSettings();
            if (settings == null) {
                return;
            }
            if (this.isPageComplete()) {
                IPath path = this.getContainerFullPath();
                String fname = this.getFileName();
                settings.put("file_path", path);
                settings.put("file_name", fname);
            } else {
                settings.remove("file_path");
                settings.remove("file_name");
            }
        }
    }

    public IFile createNewFile() {
        Map<String, Object> settings;
        if (this.getWizard() instanceof JSSWizard && this.getWizard() != null && (settings = ((JSSWizard)this.getWizard()).getSettings()) != null) {
            IFile createdFile = super.createNewFile();
            JasperReportsConfiguration jConfig = (JasperReportsConfiguration)((Object)settings.get("jasperreports_configuration"));
            jConfig.init(createdFile);
            return createdFile;
        }
        return super.createNewFile();
    }
}

