/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.CongratulationsWizardPage;
import com.jaspersoft.studio.wizards.DynamicNewFileCreationWizardPage;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.NewFileCreationWizardPage;
import com.jaspersoft.studio.wizards.category.ReportTemplatesWizardPage;
import com.jaspersoft.studio.wizards.datasource.StaticWizardDataSourcePage;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class ReportNewWizard
extends JSSWizard
implements INewWizard {
    public static final String CONTAINER_NAME_KEY = "containerNameKey";
    public static final String FILE_NAME_KEY = "fileNameKey";
    public static final String WIZARD_ID = "com.jaspersoft.studio.wizards.ReportNewWizard";
    public static final String NEW_REPORT_JRXML = "report.jrxml";
    private ReportTemplatesWizardPage templateChooserStep;
    private DynamicNewFileCreationWizardPage fileLocationStep;
    private CongratulationsWizardPage congratulationsStep;
    private boolean showCongratulationsStep = true;
    private ISelection selection;

    public ReportNewWizard() {
        this.setWindowTitle(Messages.ReportNewWizard_title);
        this.setNeedsProgressMonitor(true);
        JasperReportsConfiguration jrConfig = JasperReportsConfiguration.getDefaultJRConfig();
        JasperDesign jd = new JasperDesign();
        jd.setName("report");
        jd.setJasperReportsContext((JasperReportsContext)jrConfig);
        jrConfig.setJasperDesign(jd);
        this.setConfig(jrConfig, true);
        JDTUtils.deactivateLinkedResourcesSupport();
    }

    public ReportNewWizard(IWizard parentWizard, IWizardPage fallbackPage) {
        super(parentWizard, fallbackPage);
        this.setWindowTitle(Messages.ReportNewWizard_title);
        this.setNeedsProgressMonitor(true);
        this.showCongratulationsStep = false;
        JDTUtils.deactivateLinkedResourcesSupport();
    }

    @Override
    public void addPages() {
        this.templateChooserStep = new ReportTemplatesWizardPage();
        this.addPage((IWizardPage)this.templateChooserStep);
        this.fileLocationStep = new DynamicNewFileCreationWizardPage("newFilePage1", (IStructuredSelection)this.selection);
        this.addPage((IWizardPage)this.fileLocationStep);
        if (this.showCongratulationsStep) {
            this.congratulationsStep = new CongratulationsWizardPage(Messages.CongratulationsWizardPage_title, Messages.CongratulationsWizardPage_titleMessage, Messages.CongratulationsWizardPage_label1, Messages.CongratulationsWizardPage_label2, Messages.CongratulationsWizardPage_label3);
            this.addPage((IWizardPage)this.congratulationsStep);
        }
    }

    public boolean performCancel() {
        JDTUtils.restoreLinkedResourcesSupport();
        this.templateChooserStep.doCancel();
        return super.performCancel();
    }

    @Override
    public boolean performFinish() {
        try {
            this.getContainer().getCurrentPage().getNextPage();
            JDTUtils.restoreLinkedResourcesSupport();
            Map<String, Object> settings = this.getSettings();
            settings.put(CONTAINER_NAME_KEY, this.fileLocationStep.getContainerFullPath().toPortableString());
            settings.put(FILE_NAME_KEY, this.fileLocationStep.getFileName());
            IWizardPage p = this.getContainer().getCurrentPage();
            if (p instanceof StaticWizardDataSourcePage) {
                try {
                    ((StaticWizardDataSourcePage)p).setupParameters();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ReportNewWizard_2, -1);
                    try {
                        try {
                            IFile reportFile = ReportNewWizard.this.templateChooserStep.getTemplateBundle().doFinish(ReportNewWizard.this, monitor);
                            if (reportFile != null) {
                                monitor.setTaskName(Messages.ReportNewWizard_5);
                                JaspersoftStudioPlugin.getInstance().getUsageManager().audit(ReportNewWizard.this.templateChooserStep.getTemplateBundle().getClass().getName(), "Report");
                                UIUtils.getDisplay().asyncExec(() -> {
                                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                    try {
                                        IDE.openEditor((IWorkbenchPage)page, (IFile)reportFile, (boolean)true);
                                    }
                                    catch (PartInitException e) {
                                        e.printStackTrace();
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            UIUtils.showError((Throwable)e);
                            ReportNewWizard.this.templateChooserStep.doCancel();
                            monitor.done();
                        }
                    }
                    finally {
                        ReportNewWizard.this.templateChooserStep.doCancel();
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        return super.performFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection instanceof StructuredSelection) {
            IProject p;
            IProject[] prjs;
            if (selection.getFirstElement() instanceof IProject || selection.getFirstElement() instanceof IFile || selection.getFirstElement() instanceof IFolder || selection.getFirstElement() instanceof IPackageFragment) {
                this.selection = selection;
                return;
            }
            for (Object obj : selection.toList()) {
                IEditorInput ein;
                if (!(obj instanceof EditPart) || !((ein = SelectionHelper.getActiveJRXMLEditor().getEditorInput()) instanceof FileEditorInput)) continue;
                this.selection = new TreeSelection(new TreePath(new Object[]{((FileEditorInput)ein).getFile()}));
                return;
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            IProject[] iProjectArray = prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = prjs.length;
            int n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (ProjectUtil.isOpen((IProject)p) && p.getNature("org.eclipse.jdt.core.javanature") != null) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile(NEW_REPORT_JRXML)}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            iProjectArray = prjs;
            n = prjs.length;
            n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (ProjectUtil.isOpen((IProject)p)) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile(NEW_REPORT_JRXML)}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        this.selection = selection;
    }

    @Override
    public boolean canFinish() {
        boolean result;
        boolean bl = result = this.templateChooserStep.isPageComplete() && this.fileLocationStep.isPageComplete() && (!this.hasCongratulationStep() || this.congratulationsStep.isPageComplete());
        if (!result) {
            return result;
        }
        WizardPage[] wizardPageArray = this.templateChooserStep.getTemplateBundle().getCustomWizardPages();
        int n = wizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            WizardPage page = wizardPageArray[n2];
            if (!page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public CongratulationsWizardPage getCongratulationsStep() {
        return this.congratulationsStep;
    }

    public ReportTemplatesWizardPage getTemplateChooserStep() {
        return this.templateChooserStep;
    }

    public NewFileCreationWizardPage getFileLocationStep() {
        return this.fileLocationStep;
    }

    public boolean hasCongratulationStep() {
        return this.showCongratulationsStep;
    }

    public IFile createTargetFile() {
        return new FileCreator(this.getFileLocationStep()).createFile();
    }

    public IWizardPage getFallbackPage() {
        return this.fallbackPage;
    }

    private class FileCreator {
        private IFile result;
        private NewFileCreationWizardPage creationWizard;

        public FileCreator(NewFileCreationWizardPage creationWizard) {
            this.creationWizard = creationWizard;
        }

        public IFile createFile() {
            this.result = null;
            UIUtils.getDisplay().syncExec(() -> {
                IFile iFile = this.result = this.creationWizard.createNewFile();
            });
            return this.result;
        }
    }
}

