/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.category;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.model.subreport.command.wizard.SubreportWizard;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.templates.StudioTemplateManager;
import com.jaspersoft.studio.utils.SWTImageEffects;
import com.jaspersoft.studio.wizards.BuiltInCategories;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import com.jaspersoft.studio.wizards.category.TemplateCategory;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.ValidatedTemplateBundle;
import com.jaspersoft.templates.WizardTemplateBundle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.nebula.widgets.gallery.RoundedGalleryItemRenderer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.ResourceManager;

public class ReportTemplatesWizardPage
extends JSSWizardPage {
    protected static final String TEMPLATE_KEY = "template";
    private static final int GALLERY_HEIGHT = 100;
    private static final int GALLERY_WIDTH = 100;
    public static final String TEMPLATE_CATEGORY_SEPARATOR = "\n";
    private Scale scale;
    private HashMap<String, Gallery> cachedGalleries = new HashMap();
    private HashMap<TemplateBundle, HashSet<String>> categoryCache = new HashMap();
    private List<TemplateCategory> categoryList;
    private StackLayout layout;
    private List<TemplateBundle> bundles;
    private Composite galleryComposite;
    private TemplateBundle selectedTemplate = null;
    private HashSet<TemplateBundle> createdBundles = new HashSet();
    MouseWheelListener scaleListener = new MouseWheelListener(){

        public void mouseScrolled(MouseEvent e) {
            if ((e.stateMask & 0x40000) != 0) {
                int direction = e.count > 0 ? 1 : -1;
                ReportTemplatesWizardPage.this.scale.setSelection(ReportTemplatesWizardPage.this.scale.getSelection() + direction);
                ReportTemplatesWizardPage.this.zoomModified();
            }
        }
    };

    public WizardTemplateBundle getTemplateBundle() {
        return (WizardTemplateBundle)this.selectedTemplate;
    }

    public ReportTemplatesWizardPage() {
        super("templatenewreportwizardPage");
        this.setTitle(Messages.ReportTemplatesWizardPage_title);
        this.setDescription(Messages.ReportTemplatesWizardPage_description);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_TEMPLATE_PAGE;
    }

    private void showGallery(String galleryCategory) {
        Gallery toShow = this.cachedGalleries.get(galleryCategory);
        if (toShow == null) {
            toShow = this.createGalleryForCategory(galleryCategory);
        }
        this.layout.topControl = toShow;
        this.galleryComposite.layout();
        GalleryItem rootItem = toShow.getItem(0);
        if (toShow.getSelectionCount() <= 0 && rootItem.getItemCount() > 0) {
            toShow.setSelection(new GalleryItem[]{rootItem.getItem(0)});
            this.setPageComplete(this.validatePage());
        }
        this.storeSettings();
        this.setPageComplete(this.validatePage());
        this.zoomModified();
    }

    private Gallery createGalleryComponent() {
        Gallery gal = new Gallery(this.galleryComposite, 0x10000A00);
        NoGroupRenderer gr = new NoGroupRenderer();
        gr.setMinMargin(2);
        gr.setItemSize(100, 100);
        gr.setAutoMargin(true);
        gal.setGroupRenderer(gr);
        RoundedGalleryItemRenderer ir = new RoundedGalleryItemRenderer();
        ir.setShowLabels(true);
        gal.setItemRenderer(ir);
        gal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportTemplatesWizardPage.this.storeSettings();
                ReportTemplatesWizardPage.this.setPageComplete(ReportTemplatesWizardPage.this.validatePage());
            }
        });
        gal.addMouseWheelListener(this.scaleListener);
        gal.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ReportTemplatesWizardPage.this.validatePage()) {
                    ReportTemplatesWizardPage.this.getContainer().showPage(ReportTemplatesWizardPage.this.getNextPage());
                }
            }
        });
        return gal;
    }

    public static void templateImagesPreCache() {
        RGB greyColor = new RGB(192, 192, 192);
        List<TemplateBundle> bundles = StudioTemplateManager.getInstance().getTemplateBundles();
        for (TemplateBundle b : bundles) {
            String standardShadowedImgeKey;
            Image standardShadowedImg;
            WizardTemplateBundle wizardBundle;
            Image itemImage;
            if (!(b instanceof WizardTemplateBundle) || (itemImage = ResourceManager.getImage((ImageDescriptor)(wizardBundle = (WizardTemplateBundle)b).getIcon())) == null) continue;
            String selectedImageKey = String.valueOf(wizardBundle.getTemplateURL().toExternalForm()) + "selectedImage";
            Image selectedImg = ResourceManager.getImage((String)selectedImageKey);
            if (selectedImg == null) {
                selectedImg = new Image((Device)UIUtils.getDisplay(), SWTImageEffects.extendArea(itemImage.getImageData(), 40, null));
                ResourceManager.addImage((String)selectedImageKey, (Image)selectedImg);
            }
            if ((standardShadowedImg = ResourceManager.getImage((String)(standardShadowedImgeKey = String.valueOf(wizardBundle.getTemplateURL().toExternalForm()) + "standardShadowedImg"))) != null) continue;
            standardShadowedImg = new Image((Device)UIUtils.getDisplay(), SWTImageEffects.Glow.glow(itemImage.getImageData(), ResourceManager.getColor((RGB)greyColor), 40, 0, 255));
            ResourceManager.addImage((String)standardShadowedImgeKey, (Image)standardShadowedImg);
        }
    }

    private void craeteItems(final Gallery gal, final String categoryName) {
        final GalleryItem itemGroup = new GalleryItem(gal, 0);
        final String universalCategory = this.categoryList.get(0).getCategoryKey();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ReportTemplatesWizardPage.this.getContainer().run(false, false, new IRunnableWithProgress(){

                        public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.ReportTemplatesWizardPage_loadtemplates, -1);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    for (TemplateBundle b : ((this).this).ReportTemplatesWizardPage.this.bundles) {
                                        HashSet<String> bundleCategories = ((this).this).ReportTemplatesWizardPage.this.categoryCache.get(b);
                                        if (ReportTemplatesWizardPage.this.canBeShown(b) && (categoryName.equals(universalCategory) || bundleCategories != null && bundleCategories.contains(categoryName))) {
                                            GalleryItem item = new GalleryItem(itemGroup, 0);
                                            item.setData(ReportTemplatesWizardPage.TEMPLATE_KEY, b);
                                            if (b instanceof WizardTemplateBundle) {
                                                WizardTemplateBundle jrxmlBundle = (WizardTemplateBundle)b;
                                                Image itemImage = ResourceManager.getImage((ImageDescriptor)jrxmlBundle.getIcon());
                                                if (itemImage != null) {
                                                    String standardShadowedImgeKey;
                                                    Image standardShadowedImg;
                                                    String selectedImageKey = String.valueOf(jrxmlBundle.getTemplateURL().toExternalForm()) + "selectedImage";
                                                    Image selectedImg = ResourceManager.getImage((String)selectedImageKey);
                                                    if (selectedImg == null) {
                                                        selectedImg = new Image((Device)UIUtils.getDisplay(), SWTImageEffects.extendArea(itemImage.getImageData(), 40, null));
                                                        ResourceManager.addImage((String)selectedImageKey, (Image)selectedImg);
                                                    }
                                                    if ((standardShadowedImg = ResourceManager.getImage((String)(standardShadowedImgeKey = String.valueOf(jrxmlBundle.getTemplateURL().toExternalForm()) + "standardShadowedImg"))) == null) {
                                                        standardShadowedImg = new Image((Device)UIUtils.getDisplay(), SWTImageEffects.Glow.glow(itemImage.getImageData(), ResourceManager.getColor((int)15), 40, 0, 255));
                                                        ResourceManager.addImage((String)standardShadowedImgeKey, (Image)standardShadowedImg);
                                                    }
                                                    item.setSelectedImage(selectedImg);
                                                    item.setStandardImage(standardShadowedImg);
                                                    item.setImage(standardShadowedImg);
                                                }
                                                item.setText(b.getLabel());
                                            }
                                        }
                                        if (monitor.isCanceled()) break;
                                    }
                                    if (!((this).this).ReportTemplatesWizardPage.this.bundles.isEmpty()) {
                                        ((this).this).ReportTemplatesWizardPage.this.selectedTemplate = ((this).this).ReportTemplatesWizardPage.this.bundles.get(0);
                                    }
                                    GalleryItem rootItem = gal.getItem(0);
                                    if (gal.getSelectionCount() <= 0 && rootItem.getItemCount() > 0) {
                                        gal.setSelection(new GalleryItem[]{rootItem.getItem(0)});
                                        ReportTemplatesWizardPage.this.storeSettings();
                                        ReportTemplatesWizardPage.this.setPageComplete(ReportTemplatesWizardPage.this.validatePage());
                                    }
                                }
                            });
                        }
                    });
                    ReportTemplatesWizardPage.this.getContainer().updateButtons();
                }
                catch (InvocationTargetException e) {
                    UIUtils.showError((Throwable)e);
                }
                catch (InterruptedException e) {
                    UIUtils.showError((Throwable)e);
                }
            }
        });
    }

    private Gallery createGalleryForCategory(String categoryName) {
        Gallery gal = this.createGalleryComponent();
        this.craeteItems(gal, categoryName);
        this.cachedGalleries.put(categoryName, gal);
        return gal;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(container, 0);
        lbl.setText(Messages.ReportTemplatesWizardPage_zoom);
        GridData gd = new GridData(896);
        lbl.setLayoutData((Object)gd);
        this.scale = new Scale(container, 0);
        this.scale.setMinimum(1);
        this.scale.setMaximum(50);
        this.scale.setIncrement(1);
        this.scale.setPageIncrement(5);
        SashForm sashForm = new SashForm(container, 0);
        GridData sashData = new GridData(4, 4, true, true, 2, 1);
        sashData.widthHint = 700;
        sashForm.setLayoutData((Object)sashData);
        Table table = new Table((Composite)sashForm, 2564);
        table.setLayoutData((Object)new GridData(4, 4, false, true));
        gd = new GridData(128);
        gd.widthHint = 150;
        this.scale.setLayoutData((Object)gd);
        this.galleryComposite = new Composite((Composite)sashForm, 0);
        GridData galleryData = new GridData(1808);
        this.galleryComposite.setLayoutData((Object)galleryData);
        this.layout = new StackLayout();
        this.galleryComposite.setLayout((Layout)this.layout);
        this.categoryList = new ArrayList<TemplateCategory>();
        for (String builtInCategory : BuiltInCategories.getCategoriesList()) {
            String key = "template.category." + builtInCategory;
            String localizedName = builtInCategory;
            if (MessagesByKeys.hasTranslation(key)) {
                localizedName = MessagesByKeys.getString(key);
            }
            this.categoryList.add(new TemplateCategory(builtInCategory, localizedName));
        }
        for (TemplateCategory cat : this.categoryList) {
            this.cachedGalleries.put(cat.getCategoryKey(), null);
        }
        this.bundles = StudioTemplateManager.getInstance().getTemplateBundles();
        this.findTemplates();
        sashForm.setWeights(new int[]{20, 80});
        this.scale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ReportTemplatesWizardPage.this.zoomModified();
            }
        });
        container.addMouseWheelListener(this.scaleListener);
        this.scale.setSelection(6);
        this.zoomModified();
        this.createTableColumn(table);
        this.showGallery(this.categoryList.get(0).getCategoryKey());
        this.setControl((Control)container);
    }

    private void createTableColumn(Table table) {
        table.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(table, 0)};
        col[0].setText(Messages.ReportTemplatesWizardPage_categories);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        table.setLayout((Layout)tlayout);
        TableColumn[] tableColumnArray = col;
        int n = col.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.pack();
            ++n2;
        }
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TemplateCategory category = (TemplateCategory)element;
                return category.getCategoryName();
            }
        });
        tableViewer.setInput(this.categoryList);
        table.addSelectionListener((SelectionListener)new CategoryChooser());
        table.setSelection(0);
    }

    private void initializeBackgroundData() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int i = 1;
                while (i < ReportTemplatesWizardPage.this.categoryList.size()) {
                    String category = ReportTemplatesWizardPage.this.categoryList.get(i).getCategoryKey();
                    if (ReportTemplatesWizardPage.this.cachedGalleries.get(category) == null) {
                        ReportTemplatesWizardPage.this.createGalleryForCategory(category);
                    }
                    ++i;
                }
            }
        });
    }

    private void zoomModified() {
        double c = 1.0 + 0.1 * (double)this.scale.getSelection();
        if (this.layout.topControl != null) {
            NoGroupRenderer gr = (NoGroupRenderer)((Gallery)this.layout.topControl).getGroupRenderer();
            gr.setItemSize((int)(100.0 * c), (int)(100.0 * c));
        }
    }

    private boolean canBeShown(TemplateBundle bundle) {
        boolean canShow = true;
        if (this.getWizard() instanceof JSSWizard && ((JSSWizard)this.getWizard()).getParentWizard() instanceof SubreportWizard) {
            canShow = bundle.hasSupportForSubreport();
        }
        return canShow;
    }

    private void findTemplates() {
        for (TemplateBundle b : this.bundles) {
            if (!this.canBeShown(b)) continue;
            Object templateCategory = b.getProperty("template.category");
            if (templateCategory != null) {
                String[] strCategoryList = templateCategory.toString().split(TEMPLATE_CATEGORY_SEPARATOR);
                HashSet<String> categorySet = new HashSet<String>();
                String[] stringArray = strCategoryList;
                int n = strCategoryList.length;
                int n2 = 0;
                while (n2 < n) {
                    String cat = stringArray[n2];
                    if (!cat.trim().isEmpty()) {
                        if (!this.cachedGalleries.containsKey(cat.toLowerCase())) {
                            String categoryLocalizedName = cat;
                            if (b instanceof WizardTemplateBundle) {
                                categoryLocalizedName = ((WizardTemplateBundle)b).getLocalizedString(cat);
                            }
                            this.categoryList.add(new TemplateCategory(cat, categoryLocalizedName));
                            this.cachedGalleries.put(cat.toLowerCase(), null);
                        }
                        categorySet.add(cat);
                    }
                    ++n2;
                }
                this.categoryCache.put(b, categorySet);
                continue;
            }
            this.categoryCache.put(b, new HashSet());
        }
    }

    public static String capitalizeFirstLetters(String s) {
        int i = 0;
        while (i < s.length()) {
            if (i == 0) {
                s = String.format("%s%s", Character.valueOf(Character.toUpperCase(s.charAt(0))), s.substring(1));
            }
            if (!Character.isLetterOrDigit(s.charAt(i)) && i + 1 < s.length()) {
                s = String.format("%s%s%s", s.subSequence(0, i + 1), Character.valueOf(Character.toUpperCase(s.charAt(i + 1))), s.substring(i + 2));
            }
            ++i;
        }
        return s;
    }

    public boolean validatePage() {
        ValidatedTemplateBundle validatedBundle;
        List<String> errors;
        Gallery gal = (Gallery)this.layout.topControl;
        if (gal.getSelectionCount() == 0) {
            return false;
        }
        GalleryItem selectedItem = gal.getSelection()[0];
        TemplateBundle selectedBundle = (TemplateBundle)selectedItem.getData(TEMPLATE_KEY);
        if (selectedBundle instanceof ValidatedTemplateBundle && (errors = (validatedBundle = (ValidatedTemplateBundle)((Object)selectedBundle)).validateConfiguration()) != null && !errors.isEmpty()) {
            String errorMessage = "";
            String last = errors.get(errors.size() - 1);
            for (String error : errors) {
                errorMessage = String.valueOf(errorMessage) + error;
                if (error == last) continue;
                errorMessage = String.valueOf(errorMessage) + TEMPLATE_CATEGORY_SEPARATOR;
            }
            this.setErrorMessage(errorMessage);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void storeSettings() {
        Gallery gal = (Gallery)this.layout.topControl;
        if (this.getSettings() == null) {
            return;
        }
        if (gal == null) {
            return;
        }
        ArrayList<String> keyList = new ArrayList<String>(this.getSettings().keySet());
        for (String k : keyList) {
            if ("jasperreports_configuration".equals(k)) continue;
            this.getSettings().remove(k);
        }
        GalleryItem[] selection = gal.getSelection();
        if (selection != null && selection.length > 0) {
            this.selectedTemplate = (TemplateBundle)selection[0].getData(TEMPLATE_KEY);
            this.createdBundles.add(this.selectedTemplate);
            this.getSettings().put(TEMPLATE_KEY, this.selectedTemplate);
        } else {
            this.getSettings().remove(TEMPLATE_KEY);
            this.selectedTemplate = null;
        }
    }

    public void doCancel() {
        for (TemplateBundle bundle : this.createdBundles) {
            if (!(bundle instanceof WizardTemplateBundle)) continue;
            ((WizardTemplateBundle)bundle).wizardClosed();
        }
        this.createdBundles.clear();
    }

    private class CategoryChooser
    extends SelectionAdapter {
        private CategoryChooser() {
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = ((Table)e.widget).getSelectionIndex();
            String selectedCategory = ReportTemplatesWizardPage.this.categoryList.get(selectionIndex).getCategoryKey();
            ReportTemplatesWizardPage.this.showGallery(selectedCategory);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            String selectedCategory = ReportTemplatesWizardPage.this.categoryList.get(0).getCategoryKey();
            ReportTemplatesWizardPage.this.showGallery(selectedCategory);
        }
    }
}

