/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.fields;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.TLabelProvider;
import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.MoveT2TButtons;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class StaticWizardFieldsPage
extends JSSWizardPage {
    protected List<Object> inFields;
    protected List<Object> outFields;
    protected Table rightTable;
    private Table leftTable;
    protected TableViewer rightTView;
    protected TableViewer leftTView;
    protected Composite mainComposite;
    private MoveT2TButtons mt2t = null;
    private ListOrderButtons lob = null;

    public StaticWizardFieldsPage(String key) {
        super(key);
        this.setTitle(Messages.common_fields);
        this.setDescription(Messages.WizardFieldsPage_description);
        this.inFields = new ArrayList<Object>();
        this.outFields = new ArrayList<Object>();
    }

    public StaticWizardFieldsPage() {
        this("fieldpage");
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_SELECT_FIELDS;
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)this.mainComposite);
        this.leftTable = new Table(this.mainComposite, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        this.leftTable.setLayoutData((Object)gd);
        this.leftTable.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(this.leftTable, 0)};
        col[0].setText(Messages.WizardFieldsPage_dataset_fields);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.leftTable.setLayout((Layout)tlayout);
        this.leftTView = new TableViewer(this.leftTable);
        this.leftTView.setContentProvider((IContentProvider)new ListContentProvider());
        this.setLabelProvider(this.leftTView);
        Composite bGroup = new Composite(this.mainComposite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.rightTable = new Table(this.mainComposite, 68098);
        gd = new GridData(1808);
        gd.minimumWidth = 300;
        this.rightTable.setLayoutData((Object)gd);
        this.rightTable.setHeaderVisible(true);
        this.createColumns();
        this.rightTView = new TableViewer(this.rightTable);
        this.rightTView.setContentProvider((IContentProvider)new ListContentProvider());
        this.setLabelProvider(this.rightTView);
        this.attachCellEditors(this.rightTView, (Composite)this.rightTable);
        this.createOrderButtons(this.mainComposite);
        this.leftTView.setInput(this.inFields);
        this.rightTView.setInput(this.outFields);
        this.mt2t = new MoveT2TButtons();
        this.mt2t.createButtons(bGroup, (ColumnViewer)this.leftTView, this.rightTView);
        this.mt2t.addChangeListener(new ChangeListener(){

            @Override
            public void changed(ChangeEvent event) {
                StaticWizardFieldsPage.this.storeSettings();
                StaticWizardFieldsPage.this.fireChangeEvent();
            }
        });
    }

    protected void attachCellEditors(TableViewer viewer, Composite parent) {
    }

    protected void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
    }

    protected void rightTView(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
    }

    protected void createColumns() {
        TableColumn[] col = new TableColumn[]{new TableColumn(this.rightTable, 0)};
        col[0].setText(Messages.common_fields);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.rightTable.setLayout((Layout)tlayout);
    }

    private void createOrderButtons(Composite composite) {
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.lob = new ListOrderButtons();
        this.lob.createOrderButtons(bGroup, this.rightTView);
        this.lob.addChangeListener(new ChangeListener(){

            @Override
            public void changed(ChangeEvent event) {
                StaticWizardFieldsPage.this.storeSettings();
                StaticWizardFieldsPage.this.fireChangeEvent();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.loadSettings();
            this.storeSettings();
            this.fireChangeEvent();
        }
    }

    public void loadSettings() {
        if (this.getSettings() == null) {
            return;
        }
        if (this.getSettings().containsKey("discovered_fields")) {
            this.setAvailableFields((List)this.getSettings().get("discovered_fields"));
        } else {
            this.setAvailableFields(null);
        }
    }

    public void storeSettings() {
        if (this.getWizard() instanceof JSSWizard && this.getWizard() != null) {
            Map<String, Object> settings = ((JSSWizard)this.getWizard()).getSettings();
            if (settings == null) {
                return;
            }
            settings.put("dataset_fields", this.getSelectedFields());
        }
    }

    public void setAvailableFields(List<?> fields) {
        if (fields == null) {
            this.inFields.clear();
            this.outFields.clear();
        } else {
            this.inFields.clear();
            this.inFields.addAll(fields);
            int i = 0;
            while (i < this.outFields.size()) {
                Object obj = this.findElement(this.outFields.get(i), this.inFields);
                if (obj != null) {
                    this.inFields.remove(obj);
                } else {
                    this.outFields.remove(i);
                    --i;
                }
                ++i;
            }
        }
        this.rightTView.refresh();
        this.leftTView.refresh();
    }

    protected Object findElement(Object object, List<?> fields) {
        String objName = ((LabelProvider)this.rightTView.getLabelProvider()).getText(object);
        for (Object obj : fields) {
            if (!((LabelProvider)this.leftTView.getLabelProvider()).getText(obj).equals(objName)) continue;
            return obj;
        }
        return null;
    }

    public List<Object> getAvailableFields() {
        return new ArrayList<Object>(this.inFields);
    }

    public List<Object> getSelectedFields() {
        return new ArrayList<Object>(this.outFields);
    }

    public void clearSelection() {
        this.outFields.clear();
        this.storeSettings();
    }
}

