/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.functions;

import com.jaspersoft.studio.wizards.functions.GenerationInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;

public class FunctionsLibraryGenerationUtil {
    private static final String TEMPLATES_LOCATION_PREFIX = "com/jaspersoft/studio/wizards/functions/templates/";
    private static final String FUNCTION_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/wizards/functions/templates/FunctionClass.vm";
    private static final String CATEGORY_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/wizards/functions/templates/CategoryClass.vm";
    private static final String LIBRARY_MESSAGES_TEMPLATE_LOCATION = "com/jaspersoft/studio/wizards/functions/templates/SampleFunctionsMessages.vm";
    private static final String JR_EXTENSION_TEMPLATE_LOCATION = "com/jaspersoft/studio/wizards/functions/templates/JRExtension.vm";
    private static final String SAMPLE_JRXML_TEMPLATE_LOCATION = "com/jaspersoft/studio/wizards/functions/templates/SampleFunctionsReport.vm";
    private static final String JR_MESSAGES_PROPERTIES = "jasperreports_messages.properties";
    private static final String JR_EXTENSION_PROPERTIES = "jasperreports_extension.properties";
    private static final String SAMPLE_JRXML = "SampleFunctionsReport.jrxml";
    private IJavaProject javaProject;
    private IPackageFragmentRoot packageFragmentRoot;
    private IPackageFragment packageFragment;
    private IProgressMonitor monitor;
    private VelocityEngine ve;
    private String libraryName;
    private String packageName;

    public FunctionsLibraryGenerationUtil(GenerationInfo config, VelocityEngine ve, IProgressMonitor monitor) {
        this.ve = ve;
        this.monitor = monitor;
        this.javaProject = config.getJavaProject();
        this.packageFragmentRoot = config.getPackageFragmentRoot();
        this.packageFragment = config.getPackageFragment();
        this.libraryName = config.getLibraryName();
        this.packageName = config.getPackageName();
    }

    public void createFunctionClass(List<String> categories, boolean createSampleMethods) throws CoreException {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)this.packageName);
        functionContext.put("categoriesList", categories);
        functionContext.put("functionLibraryName", (Object)this.libraryName);
        functionContext.put("printSampleMethods", (Object)createSampleMethods);
        Template functionTemplate = this.ve.getTemplate(FUNCTION_CLASS_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        ICompilationUnit functionCU = this.packageFragment.createCompilationUnit(String.valueOf(this.libraryName) + ".java", fsw.toString(), true, this.monitor);
        JDTUtils.formatUnitSourceCode((ICompilationUnit)functionCU, (IProgressMonitor)this.monitor);
        functionCU.save(this.monitor, true);
        if (createSampleMethods) {
            IPath packagePath = this.packageFragment.getPath().makeRelativeTo(this.javaProject.getPath());
            IFile functionsLibraryI18nPropertiesFile = this.javaProject.getProject().getFile(packagePath.append(JR_MESSAGES_PROPERTIES));
            Template functionsLibraryI18nTemplate = this.ve.getTemplate(LIBRARY_MESSAGES_TEMPLATE_LOCATION);
            VelocityContext functionsLibContext = new VelocityContext();
            String functionsLibraryClass = this.libraryName;
            if (!Misc.isNullOrEmpty((String)this.packageName)) {
                functionsLibraryClass = String.valueOf(this.packageName) + "." + this.libraryName;
            }
            functionsLibContext.put("functionsLibraryClass", (Object)functionsLibraryClass);
            StringWriter flibsw = new StringWriter();
            functionsLibraryI18nTemplate.merge((Context)functionsLibContext, (Writer)flibsw);
            if (functionsLibraryI18nPropertiesFile.exists()) {
                functionsLibraryI18nPropertiesFile.appendContents((InputStream)new ByteArrayInputStream(("\n" + flibsw.toString()).getBytes()), 1, this.monitor);
            } else {
                functionsLibraryI18nPropertiesFile.create((InputStream)new ByteArrayInputStream(flibsw.toString().getBytes()), 1, this.monitor);
            }
        }
    }

    public void createCategoryClass(String categoryClass, String categoryLabel, String categoryDescription) throws CoreException {
        boolean categoryExists;
        int lastDotIdx = categoryClass.lastIndexOf(46);
        String categoryPackage = "";
        if (lastDotIdx != -1) {
            categoryPackage = categoryClass.substring(0, lastDotIdx);
        }
        String categoryClassName = categoryClass.substring(lastDotIdx + 1);
        IType categoryClassType = this.javaProject.findType(categoryClass);
        IPath categoryPackagePath = null;
        boolean bl = categoryExists = categoryClassType != null;
        if (!categoryExists) {
            VelocityContext categoryContext = new VelocityContext();
            categoryContext.put("categoryPackage", (Object)categoryPackage);
            categoryContext.put("categoryClassName", (Object)categoryClassName);
            Template categoryTemplate = this.ve.getTemplate(CATEGORY_CLASS_TEMPLATE_LOCATION);
            StringWriter csw = new StringWriter();
            categoryTemplate.merge((Context)categoryContext, (Writer)csw);
            ICompilationUnit categoryCU = this.packageFragment.createCompilationUnit(String.valueOf(categoryClassName) + ".java", csw.toString(), true, this.monitor);
            JDTUtils.formatUnitSourceCode((ICompilationUnit)categoryCU, (IProgressMonitor)this.monitor);
            categoryCU.save(this.monitor, true);
            categoryPackagePath = this.packageFragment.getPath().makeRelativeTo(this.javaProject.getPath());
        } else {
            categoryPackagePath = categoryClassType.getPath().makeRelativeTo(this.javaProject.getPath());
        }
        if (!categoryExists) {
            IFile categoryI18nPropertiesFile = this.javaProject.getProject().getFile(categoryPackagePath.append(JR_MESSAGES_PROPERTIES));
            StringBuffer sb = new StringBuffer("\n");
            sb.append(categoryClass).append(".").append("name").append("=").append(categoryLabel).append("\n");
            sb.append(categoryClass).append(".").append("description").append("=").append(categoryDescription);
            if (categoryI18nPropertiesFile.exists()) {
                categoryI18nPropertiesFile.appendContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), 1, this.monitor);
            } else {
                categoryI18nPropertiesFile.create((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), 1, this.monitor);
            }
        }
    }

    public void createJasperReportsExtensionFile() throws CoreException {
        IPath srcFolderPath = this.packageFragmentRoot.getPath().makeRelativeTo(this.javaProject.getPath());
        IFile extensionsFile = this.javaProject.getProject().getFile(srcFolderPath.append(JR_EXTENSION_PROPERTIES));
        String libraryClass = this.libraryName;
        if (!Misc.isNullOrEmpty((String)this.packageName)) {
            libraryClass = String.valueOf(this.packageName) + "." + this.libraryName;
        }
        if (extensionsFile.exists()) {
            String newLibrary = "\nnet.sf.jasperreports.extension.functions." + this.libraryName.toLowerCase() + "=" + libraryClass;
            extensionsFile.appendContents((InputStream)new ByteArrayInputStream(newLibrary.getBytes()), 1, this.monitor);
        } else {
            Template extensionTemplate = this.ve.getTemplate(JR_EXTENSION_TEMPLATE_LOCATION);
            VelocityContext extensionContext = new VelocityContext();
            extensionContext.put("libraryName", (Object)this.libraryName.toLowerCase());
            extensionContext.put("libraryClass", (Object)libraryClass);
            StringWriter extsw = new StringWriter();
            extensionTemplate.merge((Context)extensionContext, (Writer)extsw);
            extensionsFile.create((InputStream)new ByteArrayInputStream(extsw.toString().getBytes()), 1, this.monitor);
        }
    }

    public void createSampleJRXML() throws CoreException {
        IFile sampleJRXMLFile = this.javaProject.getProject().getFile(SAMPLE_JRXML);
        if (!sampleJRXMLFile.exists()) {
            VelocityContext sampleJRXMLContext = new VelocityContext();
            Template categoryTemplate = this.ve.getTemplate(SAMPLE_JRXML_TEMPLATE_LOCATION);
            StringWriter jrxmlsw = new StringWriter();
            categoryTemplate.merge((Context)sampleJRXMLContext, (Writer)jrxmlsw);
            sampleJRXMLFile.create((InputStream)new ByteArrayInputStream(jrxmlsw.toString().getBytes()), 1, this.monitor);
        }
    }
}

