/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.wizards.functions;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.swt.widgets.AutoCompletionHelper;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.functions.NewFunctionsLibraryWizard;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.sf.jasperreports.eclipse.util.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FunctionsLibraryInformationPage
extends NewTypeWizardPage {
    private Text libraryName;
    private Text categoryClass;
    private IJavaProject selectedJavaProject;
    private Button createSampleFunctions;
    private Button createSampleJRXML;
    private List<String> existingCategories;
    private IStatus libraryNameStatus = Status.OK_STATUS;
    private IStatus categoryClassStatus = Status.OK_STATUS;
    private Text categoryLabel;
    private Text categoryDescription;

    protected FunctionsLibraryInformationPage() {
        super(0, "functionsLibraryInformationPage");
        this.setTitle("Functions Library Information");
        this.setDescription("Please enter the details for the new functions library that will be created.");
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        if (jelem != null) {
            this.selectedJavaProject = jelem.getJavaProject();
        }
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
    }

    public boolean isPageComplete() {
        return this.isMandatoryInfoOK() && this.isSourceFolderInfoGood() && !this.categoryLabel.getText().isEmpty() && super.isPageComplete();
    }

    private boolean isMandatoryInfoOK() {
        int severityCode;
        int severityCode2;
        boolean libraryIsOK = false;
        if (this.libraryNameStatus != null && (severityCode2 = this.libraryNameStatus.getSeverity()) != 4 && severityCode2 != 8) {
            libraryIsOK = !this.libraryName.getText().isEmpty();
        }
        boolean categoryIsOK = false;
        if (this.categoryClassStatus != null && (severityCode = this.categoryClassStatus.getSeverity()) != 4 && severityCode != 8) {
            boolean bl = categoryIsOK = !this.categoryClass.getText().isEmpty();
        }
        return libraryIsOK && categoryIsOK;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int cols = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = cols;
        composite.setLayout((Layout)layout);
        this.createLibraryNameControls(composite, cols);
        this.createContainerControls(composite, cols);
        this.createPackageControls(composite, cols);
        this.createSeparator(composite, cols);
        this.createCategoryLabelAndDescControls(composite, cols);
        this.createCategoryClassControls(composite, cols);
        this.createSeparator(composite, cols);
        this.createSamplesControls(composite, cols);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ContextHelpIDs.WIZARD_NEW_FUNCTIONS_LIBRARY);
    }

    private void createLibraryNameControls(Composite parent, int cols) {
        Label libraryNameLbl = new Label(parent, 0);
        libraryNameLbl.setText("Library Name:");
        libraryNameLbl.setToolTipText("A class-name like identifier that will be used to generate the class file containing your functions");
        libraryNameLbl.setLayoutData((Object)new GridData(4, 128, false, false));
        this.libraryName = new Text(parent, 2048);
        this.libraryName.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
        this.libraryName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FunctionsLibraryInformationPage.this.libraryNameStatus = JavaConventions.validateJavaTypeName((String)FunctionsLibraryInformationPage.this.libraryName.getText(), (String)"1.6", (String)"1.6");
                FunctionsLibraryInformationPage.this.doStatusUpdate();
            }
        });
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        super.createContainerControls(parent, nColumns);
        this.setTooltipOnPrivateField(NewContainerWizardPage.class, "fContainerDialogField", "The chosen Build-Path entry");
    }

    protected void createPackageControls(Composite parent, int nColumns) {
        super.createPackageControls(parent, nColumns);
        this.setTooltipOnPrivateField(NewTypeWizardPage.class, "fPackageDialogField", "The Java package where most of the generated output files will be placed");
    }

    private void createCategoryLabelAndDescControls(Composite parent, int cols) {
        Label categoryLabelLbl = new Label(parent, 0);
        categoryLabelLbl.setText("Category Label:");
        categoryLabelLbl.setToolTipText("The text shown in the Expression Editor categories list");
        categoryLabelLbl.setLayoutData((Object)new GridData(4, 128, false, false));
        this.categoryLabel = new Text(parent, 2048);
        this.categoryLabel.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
        this.categoryLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String nameTxt = FunctionsLibraryInformationPage.this.categoryLabel.getText();
                nameTxt = WordUtils.capitalize((String)nameTxt).replaceAll("\\s", "");
                String txt = FunctionsLibraryInformationPage.this.getPackageText();
                if (!txt.isEmpty()) {
                    txt = String.valueOf(txt) + ".";
                }
                FunctionsLibraryInformationPage.this.categoryClass.setText(String.valueOf(txt) + nameTxt);
                FunctionsLibraryInformationPage.this.doStatusUpdate();
            }
        });
        Label categoryDescriptionLbl = new Label(parent, 0);
        categoryDescriptionLbl.setText("Category Description:");
        categoryDescriptionLbl.setLayoutData((Object)new GridData(4, 128, false, false));
        categoryDescriptionLbl.setToolTipText("Additional details regarding the category");
        this.categoryDescription = new Text(parent, 2048);
        this.categoryDescription.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
    }

    private void createCategoryClassControls(Composite parent, int cols) {
        Label categoryClassLbl = new Label(parent, 0);
        categoryClassLbl.setText("Category Class:");
        categoryClassLbl.setLayoutData((Object)new GridData(4, 128, false, false));
        categoryClassLbl.setToolTipText("The class that will represent the category. Usually automatically suggested");
        this.categoryClass = new Text(parent, 2048);
        this.categoryClass.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
        this.categoryClass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FunctionsLibraryInformationPage.this.categoryClassStatus = JavaConventions.validateJavaTypeName((String)FunctionsLibraryInformationPage.this.categoryClass.getText(), (String)"1.6", (String)"1.6");
                if (FunctionsLibraryInformationPage.this.categoryClassStatus.isOK()) {
                    String libraryNameTxt = FunctionsLibraryInformationPage.this.libraryName.getText();
                    String categoryClassTxt = FunctionsLibraryInformationPage.this.categoryClass.getText();
                    if (categoryClassTxt.endsWith("." + libraryNameTxt) || categoryClassTxt.equals(libraryNameTxt)) {
                        FunctionsLibraryInformationPage.this.categoryClassStatus = new Status(4, "com.jaspersoft.studio", -1, "Category class can not be the same one of the Library itself", null);
                    }
                }
                FunctionsLibraryInformationPage.this.doStatusUpdate();
            }
        });
        AutoCompletionHelper.enableAutoCompletion(this.categoryClass, this.getExistingCategories());
    }

    private void createSamplesControls(Composite parent, int cols) {
        Label samplesCreationQuestion = new Label(parent, 0);
        samplesCreationQuestion.setText("Which samples information do you want to create?");
        samplesCreationQuestion.setLayoutData((Object)new GridData(4, 4, true, false, cols, 1));
        Label emptyLbl = new Label(parent, 0);
        emptyLbl.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        this.createSampleFunctions = new Button(parent, 32);
        this.createSampleFunctions.setText("Some example methods");
        this.createSampleFunctions.setToolTipText("Will create some example methods in the generated function class");
        this.createSampleFunctions.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
        this.createSampleFunctions.setSelection(true);
        this.createSampleFunctions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = FunctionsLibraryInformationPage.this.createSampleFunctions.getSelection();
                FunctionsLibraryInformationPage.this.createSampleJRXML.setEnabled(enable);
                FunctionsLibraryInformationPage.this.createSampleJRXML.setSelection(enable);
            }
        });
        this.createSampleJRXML = new Button(parent, 32);
        this.createSampleJRXML.setText("A sample report that uses the example functions");
        this.createSampleJRXML.setToolTipText("Creates an example JRXML that will use the newly created sample functions");
        this.createSampleJRXML.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
        this.createSampleJRXML.setSelection(true);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.libraryNameStatus, this.fContainerStatus, this.fPackageStatus, this.categoryClassStatus};
        this.updateStatus(status);
    }

    public void setMessage(String newMessage, int newType) {
        if ("OK".equals(newMessage)) {
            newMessage = this.getDescription();
        }
        super.setMessage(newMessage, newType);
    }

    private boolean isSourceFolderInfoGood() {
        String str = this.getPackageFragmentRootText();
        if (StringUtils.isNullOrEmpty((String)str)) {
            return false;
        }
        Path path = new Path(str);
        IResource res = this.getWorkspaceRoot().findMember((IPath)path);
        return this.selectedJavaProject == null || !this.selectedJavaProject.getResource().equals((Object)res);
    }

    protected IStatus containerChanged() {
        if (!this.isSourceFolderInfoGood()) {
            StatusInfo err = new StatusInfo();
            err.setError("Please check the source folder information. It must exists and be set on classpath.");
            return err;
        }
        return super.containerChanged();
    }

    private List<String> getExistingCategories() {
        if (this.existingCategories == null) {
            final TreeSet categories = new TreeSet();
            if (this.selectedJavaProject != null) {
                SearchRequestor requestor = new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        String fqn;
                        if (match.getElement() instanceof IType && !(fqn = ((IType)match.getElement()).getFullyQualifiedName()).startsWith("net.sf.jasperreports.functions.standard")) {
                            categories.add(fqn);
                        }
                    }
                };
                IJavaElement[] elements = new IJavaElement[]{this.selectedJavaProject};
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
                int matchRule = 8;
                SearchPattern fullAnnotationPattern = SearchPattern.createPattern((String)"net.sf.jasperreports.functions.annotations.FunctionCategory", (int)8, (int)65536, (int)matchRule);
                SearchPattern simpleNamePattern = SearchPattern.createPattern((String)"FunctionCategory", (int)8, (int)65536, (int)matchRule);
                SearchPattern annotationsPattern = SearchPattern.createOrPattern((SearchPattern)fullAnnotationPattern, (SearchPattern)simpleNamePattern);
                SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                try {
                    new SearchEngine().search(annotationsPattern, searchParticipants, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
            this.existingCategories = new ArrayList<String>(categories);
            ((NewFunctionsLibraryWizard)this.getWizard()).setAvailableCategories(this.existingCategories);
        }
        return this.existingCategories;
    }

    public String getLibraryName() {
        return this.libraryName.getText();
    }

    public boolean isCreateSampleFunctions() {
        return this.createSampleFunctions.getSelection();
    }

    public boolean isCreateSampleReport() {
        return this.createSampleJRXML.getSelection();
    }

    public String getCategoryClass() {
        return this.categoryClass.getText();
    }

    public String getCategoryLabel() {
        return this.categoryLabel.getText();
    }

    public String getCategoryDescription() {
        return this.categoryDescription.getText();
    }

    private void setTooltipOnPrivateField(Class<?> targetClazz, String fieldName, String tooltip) {
        try {
            Field containerWidget = targetClazz.getDeclaredField(fieldName);
            containerWidget.setAccessible(true);
            Object obj = containerWidget.get((Object)this);
            if (obj instanceof DialogField) {
                ((DialogField)obj).getLabelControl(null).setToolTipText(tooltip);
            }
        }
        catch (Exception e) {
            JaspersoftStudioPlugin.getInstance().logError("Unable to set the tooltip on the label control", e);
        }
    }
}

