/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.templates;

import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ReportNewWizard;
import com.jaspersoft.templates.GenericTemplateBundle;
import com.jaspersoft.templates.ReportBundle;
import com.jaspersoft.templates.TemplateBundle;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;

public abstract class WizardTemplateBundle
extends GenericTemplateBundle {
    public WizardTemplateBundle(URL url, boolean isExternal, JasperReportsContext jrContext) throws Exception {
        super(url, isExternal, jrContext);
    }

    public WizardTemplateBundle(URL url, JasperReportsContext jrContext) throws Exception {
        super(url, jrContext);
    }

    public abstract WizardPage[] getCustomWizardPages();

    public abstract IFile doFinish(ReportNewWizard var1, IProgressMonitor var2) throws CoreException;

    public abstract void wizardClosed();

    protected void saveReportBundleResources(IProgressMonitor monitor, TemplateBundle reportBundle, IContainer container) {
        monitor.subTask(Messages.ReportNewWizard_6);
        if (reportBundle != null) {
            List<String> resourceNames = reportBundle.getResourceNames();
            for (String resourceName : resourceNames) {
                IFile resourceFile = container.getFile((IPath)new Path(resourceName));
                InputStream is = null;
                try {
                    try {
                        if (!resourceFile.exists() && (is = reportBundle.getResource(resourceName)) != null) {
                            resourceFile.create(is, true, monitor);
                        }
                    }
                    catch (Exception e) {
                        UIUtils.showError((Throwable)e);
                        FileUtils.closeStream(is);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(is);
                    throw throwable;
                }
                FileUtils.closeStream(is);
            }
        }
        monitor.done();
    }

    protected IFile saveBundleIntoFile(ReportBundle bundleToSave, ReportNewWizard reportWizard, JasperReportsConfiguration jConfig, IProgressMonitor monitor) {
        ByteArrayInputStream stream = null;
        IFile result = null;
        try {
            result = reportWizard.createTargetFile();
            String repname = result.getName();
            int lindx = repname.lastIndexOf(".");
            if (lindx > 0 && lindx < repname.length() - 1) {
                repname = repname.substring(0, lindx);
            }
            bundleToSave.getJasperDesign().setName(repname);
            String contents = JRXmlWriterHelper.writeReport(jConfig, (JRReport)bundleToSave.getJasperDesign(), result, false);
            stream = new ByteArrayInputStream(contents.getBytes());
            try {
                if (result.exists()) {
                    result.setContents((InputStream)stream, true, true, monitor);
                } else {
                    result.create((InputStream)stream, true, monitor);
                }
            }
            finally {
                FileUtils.closeStream((Closeable)stream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected IContainer getReportContainer(ReportNewWizard reportWizard) {
        Map<String, Object> settings = reportWizard.getSettings();
        String containerName = (String)settings.get("containerNameKey");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        return (IContainer)resource;
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.jaspersoft.studio", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public String getLocalizedString(String key) {
        return MessagesByKeys.getString(key);
    }
}

