/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.effects.SetColorEffect;
import org.eclipse.nebula.animation.movement.ExpoOut;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class HoverListener
implements MouseMoveListener,
MouseTrackListener,
MouseWheelListener {
    private static final String ANIMATION_DATA = "hoverAnimation";
    private Color backgroundColor = null;
    private Color hoverColor = null;
    GalleryItem current = null;
    Gallery gallery = null;
    int durationIn = 1000;
    int durationOut = 1000;

    public HoverListener(Gallery gallery, Color background, Color hover, int durationIn, int durationOut) {
        this.setBackgroundColor(background);
        this.setHoverColor(hover);
        this.durationIn = durationIn;
        this.durationOut = durationOut;
        this.gallery = gallery;
        gallery.addMouseMoveListener(this);
        gallery.addMouseTrackListener(this);
        gallery.addMouseWheelListener(this);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
    }

    public void mouseMove(MouseEvent e) {
        this.updateHover(e);
    }

    public void mouseEnter(MouseEvent e) {
        this.updateHover(e);
    }

    public void mouseExit(MouseEvent e) {
        this.animateBackgroundColor(this.current, this.backgroundColor, this.durationOut);
    }

    public void mouseHover(MouseEvent e) {
    }

    private void animateBackgroundColor(GalleryItem item, Color color, int duration) {
        if (item != null) {
            Color bg;
            Object o = item.getData(ANIMATION_DATA);
            if (o != null && o instanceof AnimationRunner) {
                ((AnimationRunner)o).cancel();
            }
            if ((bg = item.getBackground()) == null) {
                bg = this.backgroundColor;
            }
            AnimationRunner animation = new AnimationRunner();
            item.setData(ANIMATION_DATA, animation);
            animation.runEffect(new SetColorEffect(new GalleryItemBackgroundColorAdapter(item), bg, color, duration, new ExpoOut(), new AnimationDataCleaner(item), new AnimationDataCleaner(item)));
        }
    }

    private void updateHover(MouseEvent e) {
        GalleryItem item = ((Gallery)e.widget).getItem(new Point(e.x, e.y));
        if (item != this.current) {
            this.animateBackgroundColor(this.current, this.backgroundColor, this.durationOut);
            this.animateBackgroundColor(item, this.hoverColor, this.durationIn);
            this.current = item;
        }
    }

    public void mouseScrolled(MouseEvent e) {
        this.updateHover(e);
    }

    public class AnimationDataCleaner
    implements Runnable {
        private GalleryItem item;

        public AnimationDataCleaner(GalleryItem item) {
            this.item = item;
        }

        @Override
        public void run() {
            this.item.setData(HoverListener.ANIMATION_DATA, null);
        }
    }

    public class GalleryItemBackgroundColorAdapter
    implements SetColorEffect.IColoredObject {
        GalleryItem item;

        public GalleryItemBackgroundColorAdapter(GalleryItem item) {
            this.item = item;
        }

        @Override
        public Color getColor() {
            return this.item.getBackground();
        }

        @Override
        public void setColor(Color c) {
            this.item.setBackground(c);
        }
    }
}

