/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.jface.fieldassist;

import de.itemis.xtext.utils.jface.fieldassist.ICompletionProposalListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CompletionProposalAdapter
implements ICompletionListener {
    private final IContentAssistant contentAssistant;
    public static final boolean DEBUG = false;
    private Control control;
    private KeyStroke triggerKeyStroke;
    private String autoActivateString;
    private Listener controlListener;
    private ListenerList proposalListeners2 = new ListenerList();
    private boolean isEnabled = true;
    private int autoActivationDelay = 0;
    private boolean receivedKeyDown;

    public CompletionProposalAdapter(Control control, IContentAssistant contentAssistant, KeyStroke keyStroke, char[] autoActivationCharacters) {
        this.control = control;
        this.triggerKeyStroke = keyStroke;
        if (autoActivationCharacters != null) {
            this.autoActivateString = new String(autoActivationCharacters);
        }
        this.contentAssistant = contentAssistant;
        this.addControlListener(control);
    }

    public Control getControl() {
        return this.control;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public char[] getAutoActivationCharacters() {
        if (this.autoActivateString == null) {
            return null;
        }
        return this.autoActivateString.toCharArray();
    }

    public void setAutoActivationCharacters(char[] autoActivationCharacters) {
        this.autoActivateString = autoActivationCharacters == null ? null : new String(autoActivationCharacters);
    }

    public int getAutoActivationDelay() {
        return this.autoActivationDelay;
    }

    public void setAutoActivationDelay(int delay) {
        this.autoActivationDelay = delay;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled) {
            // empty if block
        }
        this.isEnabled = enabled;
    }

    public void addContentProposalListener(ICompletionProposalListener listener) {
        this.proposalListeners2.add((Object)listener);
    }

    public void removeContentProposalListener(ICompletionProposalListener listener) {
        this.proposalListeners2.remove((Object)listener);
    }

    private void addControlListener(Control control) {
        if (this.controlListener != null) {
            return;
        }
        this.controlListener = new Listener(){

            public void handleEvent(Event e) {
                if (!CompletionProposalAdapter.this.isEnabled) {
                    return;
                }
                switch (e.type) {
                    case 1: 
                    case 31: {
                        if (e.type == 31) {
                            return;
                        }
                        if (CompletionProposalAdapter.this.triggerKeyStroke != null && (CompletionProposalAdapter.this.triggerKeyStroke.getModifierKeys() == 0 && CompletionProposalAdapter.this.triggerKeyStroke.getNaturalKey() == e.character || CompletionProposalAdapter.this.triggerKeyStroke.getNaturalKey() == e.keyCode && (CompletionProposalAdapter.this.triggerKeyStroke.getModifierKeys() & e.stateMask) == CompletionProposalAdapter.this.triggerKeyStroke.getModifierKeys())) {
                            e.doit = false;
                            CompletionProposalAdapter.this.openProposalPopup(false);
                            return;
                        }
                        if (e.character != '\u0000') {
                            if (CompletionProposalAdapter.this.autoActivateString == null) break;
                            if (CompletionProposalAdapter.this.autoActivateString.indexOf(e.character) >= 0) {
                                CompletionProposalAdapter.this.autoActivate();
                                break;
                            }
                            CompletionProposalAdapter.this.receivedKeyDown = true;
                            break;
                        }
                        CompletionProposalAdapter.this.receivedKeyDown = true;
                        break;
                    }
                }
            }

            private void dump(String who, Event e) {
                StringBuffer sb = new StringBuffer("--- [ContentProposalAdapter]\n");
                sb.append(who);
                sb.append(" - e: keyCode=" + e.keyCode + this.hex(e.keyCode));
                sb.append("; character=" + e.character + this.hex(e.character));
                sb.append("; stateMask=" + e.stateMask + this.hex(e.stateMask));
                sb.append("; doit=" + e.doit);
                sb.append("; detail=" + e.detail + this.hex(e.detail));
                sb.append("; widget=" + e.widget);
                System.out.println(sb);
            }

            private String hex(int i) {
                return "[0x" + Integer.toHexString(i) + ']';
            }
        };
        control.addListener(1, this.controlListener);
        control.addListener(31, this.controlListener);
        control.addListener(24, this.controlListener);
    }

    private void openProposalPopup(boolean autoActivated) {
        if (this.isValid() && this.isEnabled()) {
            this.contentAssistant.showPossibleCompletions();
            ((ContentAssistant)this.contentAssistant).addCompletionListener((ICompletionListener)this);
        }
    }

    protected void openProposalPopup() {
        this.openProposalPopup(false);
    }

    private boolean isValid() {
        return this.control != null && !this.control.isDisposed();
    }

    private void autoActivate() {
        if (this.autoActivationDelay > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CompletionProposalAdapter.this.receivedKeyDown = false;
                    try {
                        Thread.sleep(CompletionProposalAdapter.this.autoActivationDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!CompletionProposalAdapter.this.isValid() || CompletionProposalAdapter.this.receivedKeyDown) {
                        return;
                    }
                    CompletionProposalAdapter.this.getControl().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CompletionProposalAdapter.this.openProposalPopup(true);
                        }
                    });
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        } else {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CompletionProposalAdapter.this.isValid()) {
                        CompletionProposalAdapter.this.openProposalPopup(true);
                    }
                }
            });
        }
    }

    private void notifyPopupOpened() {
        Object[] listenerArray = this.proposalListeners2.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((ICompletionProposalListener)listenerArray[i]).proposalPopupOpened(this);
            ++i;
        }
    }

    private void notifyPopupClosed() {
        Object[] listenerArray = this.proposalListeners2.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((ICompletionProposalListener)listenerArray[i]).proposalPopupClosed(this);
            ++i;
        }
    }

    public boolean isProposalPopupOpen() {
        return this.isValid() && this.isProposalPopupActive();
    }

    private boolean isProposalPopupActive() {
        try {
            Method m = ContentAssistant.class.getDeclaredMethod("isProposalPopupActive", new Class[0]);
            m.setAccessible(true);
            try {
                Object result = m.invoke((Object)this.contentAssistant, new Object[0]);
                if (result != null && result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new IllegalStateException("Method is expected to return boolean!");
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.notifyPopupOpened();
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.notifyPopupClosed();
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }
}

