/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.jface.viewers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.itemis.xtext.utils.jface.viewers.StyledTextXtextAdapter;
import de.itemis.xtext.utils.jface.viewers.XtextStyledTextHighlightingReconciler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.xtext.ui.editor.XtextPresentationReconciler;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingPresenter;
import org.eclipse.xtext.ui.editor.syntaxcoloring.TextAttributeProvider;

class XtextStyledTextHighlightingHelper
implements IPropertyChangeListener {
    @Inject
    private Provider<XtextStyledTextHighlightingReconciler> reconcilerProvider;
    @Inject
    private Provider<HighlightingPresenter> presenterProvider;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccessor;
    @Inject
    private TextAttributeProvider textAttributeProvider;
    private HighlightingPresenter fPresenter;
    private XtextStyledTextHighlightingReconciler fReconciler;
    private StyledTextXtextAdapter styledTextXtextAdapter;
    private XtextSourceViewer fSourceViewer;
    private XtextSourceViewerConfiguration fConfiguration;
    private XtextPresentationReconciler fPresentationReconciler;
    private IPreferenceStore preferenceStore;

    XtextStyledTextHighlightingHelper() {
    }

    public void install(StyledTextXtextAdapter styledTextXtextAdapter, XtextSourceViewer sourceViewer) {
        this.styledTextXtextAdapter = styledTextXtextAdapter;
        this.fSourceViewer = sourceViewer;
        if (styledTextXtextAdapter != null) {
            this.fConfiguration = styledTextXtextAdapter.getXtextSourceViewerConfiguration();
            this.fPresentationReconciler = (XtextPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.preferenceStore = this.getPreferenceStoreAccessor().getPreferenceStore();
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.enable();
    }

    private void enable() {
        this.fPresenter = (HighlightingPresenter)this.getPresenterProvider().get();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.styledTextXtextAdapter != null) {
            this.fReconciler = (XtextStyledTextHighlightingReconciler)this.reconcilerProvider.get();
            this.fReconciler.install(this.styledTextXtextAdapter, this.fSourceViewer, this.fPresenter);
        }
    }

    public void uninstall() {
        this.disable();
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.styledTextXtextAdapter = null;
        this.fSourceViewer = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
    }

    public XtextStyledTextHighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    public void setReconcilerProvider(Provider<XtextStyledTextHighlightingReconciler> reconcilerProvider) {
        this.reconcilerProvider = reconcilerProvider;
    }

    public Provider<XtextStyledTextHighlightingReconciler> getReconcilerProvider() {
        return this.reconcilerProvider;
    }

    public void setPresenterProvider(Provider<HighlightingPresenter> presenterProvider) {
        this.presenterProvider = presenterProvider;
    }

    public Provider<HighlightingPresenter> getPresenterProvider() {
        return this.presenterProvider;
    }

    public void setPreferenceStoreAccessor(IPreferenceStoreAccess preferenceStoreAccessor) {
        this.preferenceStoreAccessor = preferenceStoreAccessor;
    }

    public IPreferenceStoreAccess getPreferenceStoreAccessor() {
        return this.preferenceStoreAccessor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fReconciler != null && event.getProperty().contains(".syntaxColorer.tokenStyles")) {
            this.textAttributeProvider.propertyChange(event);
            this.fReconciler.refresh();
        }
    }
}

