/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api;

import com.jaspersoft.jasperserver.api.JSException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JSExceptionWrapper
extends JSException {
    private final String stackTrace;
    private final Exception originalException;

    public JSExceptionWrapper(String message, Exception e) {
        super(message, e);
        this.originalException = e;
        this.stackTrace = this.readStackTrace(e);
    }

    public JSExceptionWrapper(Exception e) {
        this(e.getMessage(), e);
    }

    private String readStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.print(String.valueOf(this.getClass().getName()) + ": ");
            s.print(this.stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.print(String.valueOf(this.getClass().getName()) + ": ");
            s.print(this.stackTrace);
        }
    }

    public void rethrow() throws Exception {
        throw this.originalException;
    }

    public Exception getOriginalException() {
        return this.originalException;
    }
}

