/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.domain;

import com.jaspersoft.jasperserver.api.JasperServerAPI;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.jaxb.FtpTypeAdapter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@JasperServerAPI
@XmlRootElement
public class FTPInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    String userName;
    String password;
    String folderPath;
    String serverName;
    private volatile Map<String, String> propertiesMap;
    private static String FTP_TYPE_PROPERTY = "FTP_TYPE_PROPERTY";
    private static String PORT_PROPERTY = "PORT_PROPERTY";
    private static String PROTOCOL_PROPERTY = "PROTOCOL_PROPERTY";
    private static String IS_IMPLICIT_PROPERTY = "IS_IMPLICIT_PROPERTY";
    private static String PHSZ_PROPERTY = "PHSZ_PROPERTY";
    private static String PROT_PROPERTY = "PROT_PROPERTY";
    public static String TYPE_FTP = "TYPE_FTP";
    public static String TYPE_FTPS = "TYPE_FTPS";

    public FTPInfo() {
    }

    public FTPInfo(FTPInfo source) {
        this.setUserName(source.getUserName());
        this.setPassword(source.getPassword());
        this.setFolderPath(source.getFolderPath());
        this.setServerName(source.getServerName());
        if (source.getPropertiesMap() != null) {
            this.setPropertiesMap(new HashMap<String, String>(source.getPropertiesMap()));
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName != null && !userName.isEmpty() ? userName : "anonymous";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @XmlJavaTypeAdapter(value=FtpTypeAdapter.class)
    public String getType() {
        String prop = null;
        if (this.propertiesMap != null) {
            prop = this.propertiesMap.get(FTP_TYPE_PROPERTY);
        }
        if (prop == null) {
            return TYPE_FTPS;
        }
        return prop;
    }

    public void setType(String type) {
        this.setProperty(FTP_TYPE_PROPERTY, type);
    }

    public int getPort() {
        String prop = null;
        if (this.propertiesMap != null) {
            prop = this.propertiesMap.get(PORT_PROPERTY);
        }
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        if (this.getType().equals(TYPE_FTPS)) {
            return 990;
        }
        return 21;
    }

    public void setPort(int port) {
        this.setProperty(PORT_PROPERTY, String.valueOf(port));
    }

    public String getProtocol() {
        if (this.propertiesMap == null) {
            return null;
        }
        return this.propertiesMap.get(PROTOCOL_PROPERTY);
    }

    public void setProtocol(String protocol) {
        this.setProperty(PROTOCOL_PROPERTY, protocol);
    }

    public boolean isImplicit() {
        if (this.propertiesMap == null) {
            return true;
        }
        String prop = this.propertiesMap.get(IS_IMPLICIT_PROPERTY);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return true;
    }

    public void setImplicit(boolean implicit) {
        this.setProperty(IS_IMPLICIT_PROPERTY, String.valueOf(implicit));
    }

    public long getPbsz() {
        if (this.propertiesMap == null) {
            return 0L;
        }
        String prop = this.propertiesMap.get(PHSZ_PROPERTY);
        if (prop != null) {
            return Long.parseLong(prop);
        }
        return 0L;
    }

    public void setPbsz(long pbsz) {
        this.setProperty(PHSZ_PROPERTY, String.valueOf(pbsz));
    }

    public String getProt() {
        if (this.propertiesMap == null) {
            return null;
        }
        return this.propertiesMap.get(PROT_PROPERTY);
    }

    public void setProt(String prot) {
        this.setProperty(PROT_PROPERTY, prot);
    }

    @XmlTransient
    public Map<String, String> getPropertiesMap() {
        return this.propertiesMap;
    }

    public void setPropertiesMap(Map<String, String> propertiesMap) {
        this.propertiesMap = propertiesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProperty(String propertyName, String propertyValue) {
        if (this.propertiesMap == null) {
            FTPInfo fTPInfo = this;
            synchronized (fTPInfo) {
                if (this.propertiesMap == null) {
                    this.propertiesMap = new HashMap<String, String>();
                }
            }
        }
        if (propertyValue == null) {
            this.propertiesMap.remove(propertyName);
        } else {
            this.propertiesMap.put(propertyName, propertyValue);
        }
    }
}

