/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.property.SetPropertyValueCommand;
import com.jaspersoft.studio.repository.IRepositoryViewProvider;
import com.jaspersoft.studio.repository.actions.Separator;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.action.resource.AddResourceAction;
import com.jaspersoft.studio.server.action.resource.CopyResourceAction;
import com.jaspersoft.studio.server.action.resource.CutResourceAction;
import com.jaspersoft.studio.server.action.resource.DeleteResourceAction;
import com.jaspersoft.studio.server.action.resource.DownloadFileAction;
import com.jaspersoft.studio.server.action.resource.ExportMetadataAction;
import com.jaspersoft.studio.server.action.resource.FindResourceAction;
import com.jaspersoft.studio.server.action.resource.ImportDataSourceInJSSAction;
import com.jaspersoft.studio.server.action.resource.ImportMetadataAction;
import com.jaspersoft.studio.server.action.resource.OpenInBrowserAction;
import com.jaspersoft.studio.server.action.resource.OpenInEditorAction;
import com.jaspersoft.studio.server.action.resource.PasteResourceAction;
import com.jaspersoft.studio.server.action.resource.PasteResourceAsLinkAction;
import com.jaspersoft.studio.server.action.resource.PropertiesAction;
import com.jaspersoft.studio.server.action.resource.RefreshResourcesAction;
import com.jaspersoft.studio.server.action.resource.RunReportUnitAction;
import com.jaspersoft.studio.server.action.server.CreateServerAction;
import com.jaspersoft.studio.server.action.server.DeleteServerAction;
import com.jaspersoft.studio.server.action.server.DuplicateServerAction;
import com.jaspersoft.studio.server.action.server.EditServerAction;
import com.jaspersoft.studio.server.dnd.InputControlDragSourceListener;
import com.jaspersoft.studio.server.dnd.InputControlDropTargetListener;
import com.jaspersoft.studio.server.dnd.RepositoryFileResourceDropTargetListener;
import com.jaspersoft.studio.server.dnd.RepositoryImageDragSourceListener;
import com.jaspersoft.studio.server.dnd.ResourceDragSourceListener;
import com.jaspersoft.studio.server.dnd.ResourceDropTargetListener;
import com.jaspersoft.studio.server.dnd.UnitDragSourceListener;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.MServers;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class ServerProvider
implements IRepositoryViewProvider {
    private CreateServerAction createServerAction;
    private FindResourceAction findResourceAction;
    private EditServerAction editServerAction;
    private DeleteServerAction deleteServerAction;
    private DuplicateServerAction duplicateServerAction;
    private DeleteResourceAction deleteAction;
    private RefreshResourcesAction refreshAction;
    private PropertiesAction editAction;
    private CutResourceAction cutAction;
    private CopyResourceAction copyAction;
    private PasteResourceAction pasteAction;
    private PasteResourceAsLinkAction pasteLinkAction;
    private AddResourceAction addAction;
    private RunReportUnitAction runReportUnitAction;
    private OpenInEditorAction openInEditorAction;
    private OpenInBrowserAction openInBrowserAction;
    private DownloadFileAction downloadFileAction;
    private ImportMetadataAction importMetadata;
    private ExportMetadataAction exportMetadata;
    private ImportDataSourceInJSSAction importDataSourceInJSSAction;
    private boolean skipLazyLoad = false;

    public Action[] getActions(TreeViewer treeViewer) {
        this.createActions(treeViewer);
        return new Action[]{this.findResourceAction, this.createServerAction};
    }

    private void createActions(TreeViewer treeViewer) {
        if (this.createServerAction == null) {
            this.createServerAction = new CreateServerAction(treeViewer);
        }
        if (this.findResourceAction == null) {
            this.findResourceAction = new FindResourceAction(treeViewer, this);
        }
        if (this.editServerAction == null) {
            this.editServerAction = new EditServerAction(treeViewer);
        }
        if (this.deleteServerAction == null) {
            this.deleteServerAction = new DeleteServerAction(treeViewer);
        }
        if (this.duplicateServerAction == null) {
            this.duplicateServerAction = new DuplicateServerAction(treeViewer);
        }
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteResourceAction(treeViewer);
        }
        if (this.refreshAction == null) {
            this.refreshAction = new RefreshResourcesAction(treeViewer);
        }
        if (this.cutAction == null) {
            this.cutAction = new CutResourceAction(treeViewer);
        }
        if (this.copyAction == null) {
            this.copyAction = new CopyResourceAction(treeViewer);
        }
        if (this.pasteAction == null) {
            this.pasteAction = new PasteResourceAction(treeViewer);
        }
        if (this.pasteLinkAction == null) {
            this.pasteLinkAction = new PasteResourceAsLinkAction(treeViewer);
        }
        if (this.addAction == null) {
            this.addAction = new AddResourceAction(treeViewer);
        }
        if (this.runReportUnitAction == null) {
            this.runReportUnitAction = new RunReportUnitAction(treeViewer);
        }
        if (this.editAction == null) {
            this.editAction = new PropertiesAction(treeViewer);
        }
        if (this.importDataSourceInJSSAction == null) {
            this.importDataSourceInJSSAction = new ImportDataSourceInJSSAction(treeViewer);
        }
        if (this.openInEditorAction == null) {
            this.openInEditorAction = new OpenInEditorAction(treeViewer);
        }
        if (this.openInBrowserAction == null) {
            this.openInBrowserAction = new OpenInBrowserAction(treeViewer);
        }
        if (this.downloadFileAction == null) {
            this.downloadFileAction = new DownloadFileAction(treeViewer);
        }
        if (this.importMetadata == null) {
            this.importMetadata = new ImportMetadataAction(treeViewer);
        }
        if (this.exportMetadata == null) {
            this.exportMetadata = new ExportMetadataAction(treeViewer);
        }
    }

    public List<IAction> fillContextMenu(TreeViewer treeViewer, ANode node) {
        this.createActions(treeViewer);
        ArrayList<IAction> lst = new ArrayList<IAction>();
        if (node instanceof MServers) {
            if (this.createServerAction.isEnabled()) {
                lst.add((IAction)this.createServerAction);
            }
        } else if (node instanceof MServerProfile) {
            if (this.addAction.isEnabled()) {
                lst.add((IAction)this.addAction);
            }
            if (this.duplicateServerAction.isEnabled()) {
                lst.add((IAction)this.duplicateServerAction);
            }
            lst.add((IAction)new Separator());
            if (this.pasteAction.isEnabled()) {
                lst.add((IAction)this.pasteAction);
            }
            if (this.pasteLinkAction.isEnabled()) {
                lst.add((IAction)this.pasteLinkAction);
            }
            lst.add((IAction)new Separator());
            if (this.editServerAction.isEnabled()) {
                lst.add((IAction)this.editServerAction);
            }
            if (this.openInBrowserAction.isEnabled()) {
                lst.add((IAction)this.openInBrowserAction);
            }
            lst.add((IAction)new Separator());
            if (this.findResourceAction.isEnabled()) {
                lst.add((IAction)this.findResourceAction);
            }
            lst.add((IAction)new Separator());
            if (this.refreshAction.isEnabled()) {
                lst.add((IAction)this.refreshAction);
            }
            lst.add((IAction)new Separator());
            if (this.deleteServerAction.isEnabled()) {
                lst.add((IAction)this.deleteServerAction);
            }
            lst.add((IAction)new Separator());
            if (this.importMetadata.isEnabled()) {
                lst.add((IAction)this.importMetadata);
            }
            if (this.exportMetadata.isEnabled()) {
                lst.add((IAction)this.exportMetadata);
            }
        } else if (node instanceof AMResource) {
            if (this.addAction.isEnabled() && (node instanceof MFolder || node instanceof MReportUnit)) {
                lst.add((IAction)this.addAction);
            }
            lst.add((IAction)new Separator());
            if (((AMResource)node).isInsideReportUnit() && this.runReportUnitAction.isEnabled()) {
                lst.add((IAction)this.runReportUnitAction);
            }
            lst.add((IAction)new Separator());
            if (this.openInEditorAction.isEnabled()) {
                lst.add((IAction)this.openInEditorAction);
            }
            if (node instanceof AFileResource && this.downloadFileAction.isEnabled() && !(node instanceof MReportUnit)) {
                lst.add((IAction)this.downloadFileAction);
            }
            lst.add((IAction)new Separator());
            if (this.cutAction.isEnabled()) {
                lst.add((IAction)this.cutAction);
            }
            if (this.copyAction.isEnabled()) {
                lst.add((IAction)this.copyAction);
            }
            if (this.pasteAction.isEnabled()) {
                lst.add((IAction)this.pasteAction);
            }
            if (this.pasteLinkAction.isEnabled()) {
                lst.add((IAction)this.pasteLinkAction);
            }
            if (this.deleteAction.isEnabled()) {
                lst.add((IAction)this.deleteAction);
            }
            if (this.importDataSourceInJSSAction.isEnabled()) {
                lst.add((IAction)this.importDataSourceInJSSAction);
            }
            lst.add((IAction)new Separator());
            if (this.openInBrowserAction.isEnabled()) {
                lst.add((IAction)this.openInBrowserAction);
            }
            lst.add((IAction)new Separator());
            if (this.findResourceAction.isEnabled()) {
                lst.add((IAction)this.findResourceAction);
            }
            lst.add((IAction)new Separator());
            if (this.refreshAction.isEnabled()) {
                lst.add((IAction)this.refreshAction);
            }
            lst.add((IAction)new Separator());
            if (this.editAction.isEnabled()) {
                lst.add((IAction)this.editAction);
            }
            lst.add((IAction)new Separator());
            if (this.importMetadata.isEnabled()) {
                lst.add((IAction)this.importMetadata);
            }
            if (this.exportMetadata.isEnabled()) {
                lst.add((IAction)this.exportMetadata);
            }
        }
        return lst;
    }

    private boolean isMacDelete(KeyEvent event) {
        return Util.isMac() && event.character == '\b';
    }

    public void hookKeyEvent(TreeViewer treeViewer, KeyEvent event) {
        if ((event.character == '\u007f' || this.isMacDelete(event)) && event.stateMask == 0) {
            if (this.deleteServerAction.isEnabled()) {
                this.deleteServerAction.run();
            }
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
        } else if ((event.stateMask & 0x40000) == 262144 && event.keyCode == 102 && this.findResourceAction.isEnabled()) {
            this.findResourceAction.run();
        }
    }

    public void doubleClick(TreeViewer treeViewer) {
        TreeSelection ts = (TreeSelection)treeViewer.getSelection();
        Object el = ts.getFirstElement();
        if (el instanceof MFolder) {
            if (treeViewer.getExpandedState(el)) {
                treeViewer.collapseToLevel(el, 1);
            } else {
                if (this.refreshAction.isEnabled()) {
                    this.refreshAction.run();
                }
                treeViewer.expandToLevel(el, 1);
            }
        } else if (this.editServerAction.isEnabled()) {
            this.editServerAction.run();
        } else if (this.openInEditorAction.isEnabled()) {
            this.openInEditorAction.run();
        } else if ((el instanceof MReportUnit || el instanceof ANode && ((ANode)el).getParent() instanceof MReportUnit && el instanceof MJrxml && ((MJrxml)((Object)el)).getValue().isMainReport()) && this.runReportUnitAction.isEnabled()) {
            this.runReportUnitAction.run();
        } else if (el instanceof AMResource && this.editAction.isEnabled()) {
            this.editAction.run();
        }
    }

    public ANode getNode(ANode root) {
        MServers servers = new MServers(root);
        ServerManager.loadServerProfiles(servers);
        return servers;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        ServerManager.getPropertyChangeSupport().addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        ServerManager.getPropertyChangeSupport().removePropertyChangeListener(pcl);
    }

    public void handleTreeEvent(TreeExpansionEvent event) {
        if (event.getElement() instanceof MServerProfile) {
            this.listServer(event);
        } else if (event.getElement() instanceof AMResource) {
            this.lazyLoadResource(event);
        }
    }

    public void handleTreeEvent(TreeExpansionEvent event, IProgressMonitor monitor) {
        if (event.getElement() instanceof MServerProfile) {
            this.listServer(event, monitor);
        } else if (event.getElement() instanceof AMResource) {
            this.lazyLoadResource(event, monitor);
        }
    }

    private void listServer(final TreeExpansionEvent event) {
        if (this.skipLazyLoad) {
            return;
        }
        Job job = new Job("Refreshing tree"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    status = ServerProvider.this.listServer(event, monitor);
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        job.setPriority(20);
        job.setSystem(false);
        job.setUser(true);
        job.schedule();
    }

    private void lazyLoadResource(final TreeExpansionEvent event) {
        if (this.skipLazyLoad) {
            return;
        }
        Job job = new Job("Refreshing tree"){

            protected IStatus run(IProgressMonitor monitor) {
                return ServerProvider.this.lazyLoadResource(event, monitor);
            }
        };
        job.setPriority(20);
        job.setSystem(false);
        job.setUser(true);
        job.schedule();
    }

    public IStatus lazyLoadResource(TreeExpansionEvent event, IProgressMonitor monitor) {
        if (this.skipLazyLoad) {
            return Status.OK_STATUS;
        }
        AMResource r = (AMResource)((Object)event.getElement());
        try {
            WSClientHelper.refreshResource(r, monitor);
            Display.getDefault().asyncExec(() -> event.getTreeViewer().refresh(true));
            return Status.OK_STATUS;
        }
        catch (Throwable e) {
            Display.getDefault().syncExec(() -> {
                event.getTreeViewer().collapseToLevel(event.getElement(), 1);
                UIUtils.showErrorDialog((String)e.getMessage(), (Throwable)e);
            });
            return Status.CANCEL_STATUS;
        }
    }

    private IStatus listServer(TreeExpansionEvent event, IProgressMonitor monitor) {
        TreeViewer tv = (TreeViewer)event.getTreeViewer();
        MServerProfile r = (MServerProfile)((Object)event.getElement());
        try {
            WSClientHelper.connectGetData(r, monitor, false);
            UIUtils.getDisplay().asyncExec(() -> tv.refresh((Object)r, true));
            return Status.OK_STATUS;
        }
        catch (Throwable e) {
            UIUtils.getDisplay().syncExec(() -> {
                tv.collapseToLevel((Object)r, 1);
                if (!monitor.isCanceled()) {
                    UIUtils.showErrorDialog((String)e.getMessage(), (Throwable)e);
                }
            });
            return Status.CANCEL_STATUS;
        }
    }

    public List<TransferDragSourceListener> getTransferDragSourceListeners(TreeViewer treeViewer) {
        ArrayList<TransferDragSourceListener> dragListeners = new ArrayList<TransferDragSourceListener>(2);
        dragListeners.add(new RepositoryImageDragSourceListener(treeViewer));
        dragListeners.add(new UnitDragSourceListener(treeViewer));
        dragListeners.add(new InputControlDragSourceListener(treeViewer));
        dragListeners.add(new ResourceDragSourceListener(treeViewer));
        return dragListeners;
    }

    public List<TransferDropTargetListener> getTransferDropTargetListeners(TreeViewer treeViewer) {
        ArrayList<TransferDropTargetListener> dropListeners = new ArrayList<TransferDropTargetListener>(1);
        dropListeners.add(new RepositoryFileResourceDropTargetListener((Transfer)FileTransfer.getInstance()));
        dropListeners.add(new InputControlDropTargetListener(treeViewer));
        dropListeners.add(new ResourceDropTargetListener(treeViewer));
        return dropListeners;
    }

    public void setSkipLazyLoad(boolean skipLazyLoad) {
        this.skipLazyLoad = skipLazyLoad;
    }

    public List<Command> dropResource(String key, INode root) throws InterruptedException {
        if (root instanceof MReport || root instanceof MPage) {
            MServerProfile sp = ServerManager.getServerProfile(key);
            if (sp == null) {
                return null;
            }
            JasperDesign jd = root.getJasperDesign();
            ServerProfile v = sp.getValue();
            JRPropertiesMap pm = jd.getPropertiesMap();
            String surl = jd.getProperty("ireport.jasperserver.url");
            String suser = jd.getProperty("ireport.jasperserver.user");
            String puser = AExporter.encodeUsr(v);
            ArrayList<Command> cmds = new ArrayList<Command>();
            if (surl == null || !surl.equals(v.getUrlString()) || !suser.equals(puser)) {
                if (!UIUtils.showConfirmation((String)"Drop Image", (String)"Source server is different from the current server.\nDo you want to overwrite server address?")) {
                    throw new InterruptedException();
                }
                cmds.add((Command)new SetPropertyValueCommand(pm, "ireport.jasperserver.url", v.getUrlString()));
                cmds.add((Command)new SetPropertyValueCommand(pm, "ireport.jasperserver.user", puser));
            }
            return cmds;
        }
        return null;
    }
}

