/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.dnd;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.dnd.NodeTreeDropAdapter;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.action.resource.PasteResourceAction;
import com.jaspersoft.studio.server.dnd.ResourceDragSourceListener;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MReference;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.IConnection;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.TreeItem;

public class ResourceDropTargetListener
extends NodeTreeDropAdapter
implements TransferDropTargetListener {
    public ResourceDropTargetListener(TreeViewer treeViewer) {
        super(treeViewer);
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        ArrayList<AMResource> mc = new ArrayList<AMResource>();
        if (data.getClass().isArray()) {
            Object[] ar;
            Object[] objectArray = ar = (Object[])data;
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof AMResource) {
                    mc.add((AMResource)((Object)obj));
                }
                ++n2;
            }
        } else if (data instanceof AMResource) {
            mc.add((AMResource)((Object)data));
        }
        final List<AMResource> droppedObjects = this.getDroppedObjects();
        Job job = new Job("Moving elements"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                block29: {
                    status = Status.OK_STATUS;
                    monitor.beginTask("Moving elements", -1);
                    try {
                        Object target = ResourceDropTargetListener.this.getCurrentTarget();
                        if (!(target instanceof ANode)) break block29;
                        ArrayList<Object> toRefresh = new ArrayList<Object>();
                        if (((ANode)target).getParent() instanceof MReportUnit || !(target instanceof MFolder) && ((ANode)target).getParent() instanceof MFolder) {
                            target = ((ANode)target).getParent();
                        }
                        if (target instanceof MFolder) {
                            MFolder mFolder = (MFolder)((Object)target);
                            for (Object amr : droppedObjects) {
                                try {
                                    if (amr.getParent() == mFolder) continue;
                                    toRefresh.add(amr.getParent());
                                    ((MFolder)((Object)target)).getWsClient().move(monitor, ((AMResource)((Object)amr)).getValue(), mFolder.getValue().getUriString());
                                    toRefresh.add((INode)target);
                                }
                                catch (Exception e) {
                                    UIUtils.showError((Throwable)e);
                                }
                            }
                        } else if (target instanceof MServerProfile) {
                            for (AMResource aMResource : droppedObjects) {
                                try {
                                    toRefresh.add(aMResource.getParent());
                                    ((MServerProfile)((Object)target)).getWsClient().move(monitor, aMResource.getValue(), "/");
                                }
                                catch (Exception e) {
                                    UIUtils.showError((Throwable)e);
                                }
                            }
                        } else if (target instanceof MReportUnit) {
                            IConnection iConnection = ((MReportUnit)target).getWsClient();
                            ResourceDescriptor prd = ((MReportUnit)target).getValue();
                            for (AMResource amr : droppedObjects) {
                                toRefresh.add(amr.getParent());
                                try {
                                    PasteResourceAction.putIntoReportUnit(monitor, (MReportUnit)target, iConnection, amr.getValue());
                                }
                                catch (Exception e) {
                                    UIUtils.showError((Throwable)e);
                                }
                            }
                            try {
                                iConnection.addOrModifyResource(monitor, prd, null);
                            }
                            catch (Exception e) {
                                UIUtils.showError((Throwable)e);
                            }
                        }
                        for (INode iNode : toRefresh) {
                            try {
                                if (ResourceDropTargetListener.this.hasParent(toRefresh, iNode) && !(iNode instanceof MServerProfile)) continue;
                                PasteResourceAction.refreshNode(iNode, monitor);
                            }
                            catch (Exception e) {
                                UIUtils.showError((Throwable)e);
                            }
                        }
                        try {
                            if (target instanceof MReference) {
                                target = ((ANode)target).getParent();
                            }
                            if (target instanceof AMResource) {
                                WSClientHelper.refreshResource((AMResource)((Object)target), monitor);
                            } else if (target instanceof MServerProfile) {
                                WSClientHelper.listFolder((MServerProfile)((Object)target), ((MServerProfile)((Object)target)).getWsClient(), "/", monitor, 0);
                            }
                        }
                        catch (Exception exception) {
                            UIUtils.showError((Throwable)exception);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                return status;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
        return true;
    }

    private List<AMResource> getDroppedObjects() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        ArrayList<AMResource> res = new ArrayList<AMResource>();
        TreeSelection sel = (TreeSelection)viewer.getSelection();
        for (Object obj : sel.toList()) {
            if (!(obj instanceof AMResource)) continue;
            res.add((AMResource)((Object)obj));
        }
        ArrayList<AMResource> toDel = new ArrayList<AMResource>();
        for (AMResource amr : res) {
            if (!this.hasParent(res, (INode)amr)) continue;
            toDel.add(amr);
        }
        res.removeAll(toDel);
        return res;
    }

    private boolean hasParent(List<? extends INode> lst, INode amr) {
        INode parent = amr.getParent();
        while (parent != null) {
            if (lst.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public boolean isEnabled(DropTargetEvent event) {
        if (event.item instanceof TreeItem) {
            TreeItem item = (TreeItem)event.item;
            Object d = item.getData();
            if (d instanceof MReportUnit) {
                return false;
            }
            if (d instanceof AMResource && ResourceDragSourceListener.isDragable(((AMResource)((Object)d)).getParent())) {
                TreeViewer viewer = (TreeViewer)this.getViewer();
                TreeSelection sel = (TreeSelection)viewer.getSelection();
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof AMResource) {
                        if (d instanceof AMResource && !PasteResourceAction.isSameServer((ANode)((AMResource)((Object)d)), (AMResource)((Object)obj))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public Transfer getTransfer() {
        return NodeTransfer.getInstance();
    }
}

