/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class JrsClassLoader
extends ClassLoader {
    private IContainer container;
    private URLClassLoader loader;
    private ResourceListener listener;
    private Set<URL> urls;

    public JrsClassLoader(ClassLoader parent, IContainer container) {
        super(parent);
        this.container = container;
        this.refresh();
        this.listener = new ResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 7);
    }

    private URL[] buildPaths() {
        this.urls = new HashSet<URL>();
        try {
            this.container.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && resource.getFileExtension() != null && (resource.getFileExtension().equals("jar") || resource.getFileExtension().equals("zip") || resource.getFileExtension().equals("properties"))) {
                        try {
                            JrsClassLoader.this.urls.add(resource.getLocationURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    return true;
                }
            });
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return this.urls.toArray(new URL[this.urls.size()]);
    }

    public void refresh() {
        this.disposeClassLoader();
        this.loader = URLClassLoader.newInstance(this.buildPaths(), this.getParent());
    }

    private void disposeClassLoader() {
        if (this.loader != null) {
            JavaProjectClassLoader.clean((URLClassLoader)this.loader);
            this.loader = null;
        }
    }

    public void dispose() {
        this.disposeClassLoader();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
    }

    @Override
    protected URL findResource(String name) {
        if (this.loader != null) {
            return this.loader.getResource(name);
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (this.loader != null) {
            return this.loader.getResources(name);
        }
        return super.findResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.loader != null) {
            return this.loader.loadClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    private final class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final IResource r = event.getResource();
            if (this.toRefresh(r)) {
                JrsClassLoader.this.refresh();
            } else if (r == null && event.getType() == 1 && event.getDelta().getKind() == 4) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource res = delta.getResource();
                            if (!res.exists()) {
                                return true;
                            }
                            int type = res.getType();
                            if (ResourceListener.this.toRefresh(r)) {
                                JrsClassLoader.this.refresh();
                            }
                            if (type == 2 && delta.getKind() == 2) {
                                res.accept(new IResourceVisitor(){

                                    /*
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     */
                                    public boolean visit(IResource resource) throws CoreException {
                                        if (resource.getType() != 1) return true;
                                        IFile file = (IFile)resource;
                                        if (!file.getProject().equals((Object)((ResourceListener)(this).ResourceListener.this).JrsClassLoader.this.container.getProject())) return true;
                                        try {
                                            URL u;
                                            URL rurl = file.getLocationURI().toURL();
                                            Iterator<URL> iterator = ((ResourceListener)(this).ResourceListener.this).JrsClassLoader.this.urls.iterator();
                                            do {
                                                if (iterator.hasNext()) continue;
                                                return true;
                                            } while (!(u = iterator.next()).equals(rurl));
                                            JrsClassLoader.this.refresh();
                                            return false;
                                        }
                                        catch (MalformedURLException malformedURLException) {}
                                        return true;
                                    }
                                });
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean toRefresh(IResource r) {
            return r instanceof IProject || r instanceof IFolder && this.isFolderOrParent(r) || r instanceof IFile && (r.getName().endsWith(".jar") || r.getName().endsWith(".zip") || r.getName().endsWith(".properties"));
        }

        private boolean isFolderOrParent(IResource r) {
            IContainer c = JrsClassLoader.this.container;
            do {
                if (!c.equals((Object)r)) continue;
                return true;
            } while ((c = c.getParent()) instanceof IFolder);
            return false;
        }
    }
}

