/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input;

import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.editor.input.PResourceDescriptor;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.TimestampRange;
import org.eclipse.swt.widgets.Composite;

public class DateInput
extends com.jaspersoft.studio.editor.preview.input.DateInput {
    public DateInput() {
        super(true, true);
    }

    public void createInput(Composite parent, IParameter param, Map<String, Object> params) {
        if (param instanceof PResourceDescriptor) {
            PResourceDescriptor p = (PResourceDescriptor)param;
            ServerProfile sp = WSClientHelper.getServerProfile(p.getWsClient());
            if (sp != null) {
                this.setSupportDateRange(sp.isSupportsDateRanges());
            }
            this.isNumeric = !p.getWsClient().isSupported(Feature.SEARCHREPOSITORY);
        }
        this.params = params;
        this.param = param;
        Class valueClass = param.getValueClass();
        if (java.sql.Date.class.isAssignableFrom(valueClass)) {
            if (this.supportDateRange) {
                this.createDateRange(parent, param, params);
            } else {
                this.createDate(parent, param, params);
            }
        } else if (Time.class.isAssignableFrom(valueClass)) {
            this.createTime(parent, param, params);
        } else if (Timestamp.class.isAssignableFrom(valueClass) || Date.class.isAssignableFrom(valueClass)) {
            if (this.supportDateRange) {
                this.createTimestampRange(parent, param, params);
            } else {
                this.createTimestamp(parent, param, params);
            }
        } else if (TimestampRange.class.isAssignableFrom(valueClass)) {
            this.createTimestampRange(parent, param, params);
        } else if (DateRange.class.isAssignableFrom(valueClass)) {
            this.createDateRange(parent, param, params);
        }
        this.date.setToolTipText(VParameters.createToolTip((IParameter)param));
        this.date.addFocusListener(this.focusListener);
    }

    protected void handleDateRangeChange(Class<? extends Date> clazz) {
        if (this.date.getSelection() != null) {
            Date d = this.date.getSelection();
            this.updateWithDate(d);
        } else {
            String ntxt;
            String exp = Misc.nvl((String)this.date.getText()).toUpperCase();
            Matcher matcher = Pattern.compile("^(DAY|WEEK|MONTH|QUARTER|SEMI|YEAR)([\\+|-][\\d]{1,9})?$").matcher(exp.replaceAll(" ", ""));
            if (!matcher.matches() && this.date.getPattern() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.date.getPattern());
                try {
                    this.updateWithDate(sdf.parse(exp));
                    return;
                }
                catch (ParseException parseException) {}
            }
            if ((ntxt = this.date.getNullText()).equals("<choose date>")) {
                this.updateModel(null);
            } else {
                this.updateModel(Misc.nvl((String)ntxt.replaceAll(" ", "")).toUpperCase());
            }
        }
    }

    private void updateWithDate(Date d) {
        if (d != null) {
            if (this.isNumeric) {
                this.updateModel(d.getTime());
            } else {
                this.updateModel(d);
            }
        }
    }
}

