/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.ic;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWTextButton;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWidget;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.selector.SelectServerWizard;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class WResourcePathSelector
extends AWTextButton {
    public WResourcePathSelector(AWidget aw) {
        super(aw);
    }

    protected void createButton(Composite cmp) {
        super.createButton(cmp);
        this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String servUser;
                JasperDesign jDesign = WResourcePathSelector.this.aw.getjConfig().getJasperDesign();
                String servURL = jDesign.getProperty("ireport.jasperserver.url");
                MServerProfile msp = ServerManager.getServerByUrl(servURL, servUser = jDesign.getProperty("ireport.jasperserver.user"));
                if (msp == null) {
                    SelectServerWizard wizard = new SelectServerWizard();
                    if (new WizardDialog(WResourcePathSelector.this.btn.getShell(), (IWizard)wizard).open() == 0) {
                        msp = wizard.getValue();
                        try {
                            jDesign.setProperty("ireport.jasperserver.url", msp.getValue().getUrl());
                            jDesign.setProperty("ireport.jasperserver.user", AExporter.encodeUsr(msp.getValue()));
                        }
                        catch (MalformedURLException | URISyntaxException e1) {
                            UIUtils.showError((Throwable)e1);
                        }
                    }
                }
                if (msp != null) {
                    WResourcePathSelector.this.showFindDialog(msp);
                }
            }
        });
    }

    protected void showFindDialog(MServerProfile msp) {
        if (msp.isSupported(Feature.SEARCHREPOSITORY)) {
            ResourceDescriptor rd = FindResourceJob.doFindResource(msp, this.getCompatibleResources(), null, true, this.getName());
            if (rd == null) {
                return;
            }
            this.postSelection(rd);
        } else {
            RepositoryDialog rd = new RepositoryDialog(this.btn.getShell(), (INode)msp){

                @Override
                public boolean isResourceCompatible(AMResource r) {
                    return WResourcePathSelector.this.isResourceCompatible(r);
                }
            };
            if (rd.open() == 0) {
                AMResource rs = rd.getResource();
                this.postSelection(rs.getValue());
            }
        }
        this.fillValue();
    }

    protected String getName() {
        return null;
    }

    protected void postSelection(ResourceDescriptor rd) {
        if (rd != null) {
            this.aw.setValue((Object)rd.getUriString());
        } else {
            this.aw.setValue(null);
        }
    }

    protected String[] getCompatibleResources() {
        return new String[0];
    }

    protected boolean isResourceCompatible(AMResource r) {
        return true;
    }
}

