/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.model.server;

import com.jaspersoft.jasperserver.dto.serverinfo.ServerInfo;
import com.jaspersoft.studio.editor.context.EditorContextUtil;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.server.ServerIconDescriptor;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.utils.Callback;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;

public class MServerProfile
extends ANode {
    public static final long serialVersionUID = 10200L;
    public static final String MAPPINGFILE = "com/jaspersoft/studio/server/model/server/ServerProfileImpl.xml";
    private static IIconDescriptor iconDescriptor;
    private transient IConnection wsClient;
    private transient IContainer tmpLocation;

    public MServerProfile(ANode parent, ServerProfile server) {
        super(parent, -1);
        this.setValue(server);
    }

    public ServerProfile getValue() {
        return (ServerProfile)super.getValue();
    }

    public INode getRoot() {
        return this;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("profile_name") && this.getParent() != null) {
            this.getParent().propertyChange(evt);
        }
    }

    public void setJasperConfiguration(JasperReportsConfiguration jConfig) {
        super.setJasperConfiguration(jConfig);
        if (this.getParent() != null) {
            ((ANode)this.getParent().getRoot()).setJasperConfiguration(jConfig);
        }
        if (this.getValue() != null && jConfig != null) {
            jConfig.setProperty("net.sf.jasperreports.report.version", this.getValue().getJrVersion());
        }
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new ServerIconDescriptor("server");
        }
        return iconDescriptor;
    }

    public String getDisplayText() {
        ServerProfile v = this.getValue();
        if (v != null && v.getName() != null && !v.getName().isEmpty()) {
            return v.getName();
        }
        return MServerProfile.getIconDescriptor().getTitle();
    }

    public ImageDescriptor getImagePath() {
        return MServerProfile.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        ServerProfile v = this.getValue();
        if (v != null && v.getName() != null && !v.getName().isEmpty()) {
            String tt = v.getName();
            try {
                String ci;
                if (v.getUrl() != null) {
                    tt = String.valueOf(tt) + "\n" + v.getUrl();
                }
                if (v.getUser() != null) {
                    tt = String.valueOf(tt) + Messages.MServerProfile_2 + v.getUser();
                }
                if (!Misc.isNullOrEmpty((String)(ci = this.getConnectionInfo()))) {
                    tt = String.valueOf(tt) + "\n\n" + ci;
                }
                return tt;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return MServerProfile.getIconDescriptor().getTitle();
    }

    public String getConnectionInfo() {
        String tt = "";
        if (this.wsClient != null) {
            try {
                ServerInfo info = this.wsClient.getServerInfo(null);
                tt = String.valueOf(tt) + Messages.MServerProfile_5 + info.getVersion();
                tt = String.valueOf(tt) + Messages.MServerProfile_6 + Misc.nvl((String)info.getEditionName()) + " " + (info.getEdition() != null ? info.getEdition() : "");
                tt = String.valueOf(tt) + Messages.MServerProfile_9 + Misc.nvl((String)info.getBuild());
                tt = String.valueOf(tt) + Messages.MServerProfile_10 + Misc.nvl((String)info.getLicenseType());
                tt = String.valueOf(tt) + Messages.MServerProfile_11 + Misc.nvl((String)info.getExpiration());
                tt = String.valueOf(tt) + Messages.MServerProfile_12 + Misc.nvl((String)info.getFeatures());
                tt = String.valueOf(tt) + Messages.MServerProfile_13 + Misc.nvl((String)info.getDateFormatPattern());
                tt = String.valueOf(tt) + Messages.MServerProfile_14 + Misc.nvl((String)info.getDatetimeFormatPattern());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tt;
    }

    public String toXML() {
        return CastorHelper.write((Object)this.getValue(), (String)MAPPINGFILE);
    }

    public IConnection getWsClient(Callback<IConnection> c) {
        return this.getWsClient(c, false);
    }

    public IConnection getWsClient(final Callback<IConnection> c, boolean showProgress) {
        if (this.wsClient == null) {
            Job job = new Job(Messages.MServerProfile_15){

                protected IStatus run(IProgressMonitor monitor) {
                    block8: {
                        monitor.beginTask("", -1);
                        try {
                            try {
                                MServerProfile.this.getWsClient(monitor);
                            }
                            catch (Exception exception) {
                                if (c != null) {
                                    UIUtils.getDisplay().asyncExec(() -> c.completed((Object)MServerProfile.this.wsClient));
                                }
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            if (c != null) {
                                UIUtils.getDisplay().asyncExec(() -> c.completed((Object)MServerProfile.this.wsClient));
                            }
                            throw throwable;
                        }
                        if (c != null) {
                            UIUtils.getDisplay().asyncExec(() -> c.completed((Object)MServerProfile.this.wsClient));
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            if (showProgress) {
                job.setUser(true);
            }
            job.setPriority(30);
            job.schedule();
        }
        return this.wsClient;
    }

    public IConnection getWsClient() {
        return this.wsClient;
    }

    public IConnection getWsClient(IProgressMonitor monitor) throws Exception {
        if (this.wsClient == null) {
            WSClientHelper.connect(this, monitor);
        }
        return this.wsClient;
    }

    public void setWsClient(IConnection wsClient) {
        this.wsClient = wsClient;
    }

    public void setValue(Object value) {
        ServerProfile oldValue = this.getValue();
        super.setValue(value);
        this.resetTmpPaths();
        if (this.getParent() != null) {
            this.getParent().propertyChange(new PropertyChangeEvent((Object)this, "SERVERPROFILE", oldValue, value));
        }
        if (this.getJasperConfiguration() != null) {
            if (value == null) {
                this.getJasperConfiguration().removeProperty("net.sf.jasperreports.report.version");
            } else {
                this.getJasperConfiguration().setProperty("net.sf.jasperreports.report.version", ((ServerProfile)value).getJrVersion());
            }
        }
    }

    protected void resetTmpPaths() {
        this.tmpLocation = null;
        AExporter.fileurimap.clear();
    }

    public void setProjectPath(String projectPath) {
        this.getValue().setProjectPath(projectPath);
        this.resetTmpPaths();
    }

    public IContainer getTempWorkspaceLocation(IProgressMonitor monitor) throws IOException, CoreException {
        if (this.tmpLocation == null || !this.tmpLocation.exists()) {
            IResource relatedResource;
            String prjpath = this.getValue().getProjectPath();
            if (prjpath != null && !prjpath.trim().isEmpty() && (relatedResource = ResourcesPlugin.getWorkspace().getRoot().findMember(prjpath)) instanceof IContainer) {
                this.tmpLocation = (IContainer)relatedResource;
            }
            if (this.tmpLocation == null) {
                IProject prj = FileUtils.getProject((IProgressMonitor)monitor);
                String sname = IDStringValidator.safeChar((String)this.getValue().getName());
                String suffix = "";
                int i = 1;
                do {
                    this.tmpLocation = prj.getFolder(String.valueOf(sname) + suffix);
                    suffix = "_" + i;
                    ++i;
                } while (this.tmpLocation.exists());
                this.getValue().setProjectPath(this.tmpLocation.getFullPath().toString());
                ServerManager.saveServerProfile(this);
            }
            if (!this.tmpLocation.getFullPath().toFile().exists()) {
                if (!this.tmpLocation.exists() && this.tmpLocation instanceof IFolder) {
                    FileUtils.createResource((IResource)this.tmpLocation, (IProgressMonitor)monitor);
                    this.tmpLocation.setPersistentProperty(EditorContextUtil.EC_KEY, "jrs");
                }
                ServerManager.saveServerProfile(this);
            }
        }
        return this.tmpLocation;
    }

    public boolean isSupported(Feature f) {
        IConnection c = this.getWsClient();
        if (c != null) {
            return c.isSupported(f);
        }
        return false;
    }
}

